unit fmObjectWithIns;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, PerfCounters, PerfMonitor, PerfInstances;

type
  TObjectWithInsForm = class(TForm)
    PnCaption: TPanel;
    LV: TListView;
    PerfCounters: TPerfCounters;
    PerfMonitor: TPerfMonitor;
    Timer: TTimer;
    procedure LVEnter(Sender: TObject);
    procedure LVExit(Sender: TObject);
    procedure PnCaptionClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
    procedure Refresh;
  public
    { Public declarations }
    constructor Create(Owner: TComponent; ObjectName: String);
  end;


implementation

uses
    fmPerfExplorerMain;

{$R *.DFM}

constructor TObjectWithInsForm.Create(Owner: TComponent; ObjectName: String);
var i: Integer;
    MI: TPerfMonitorItem;
    LC: TListColumn;
begin
    inherited Create(Owner);
    PerfCounters.ObjectName:=ObjectName;
    PnCaption.Caption:=Format(PnCaption.Caption,[ObjectName]);

    for i:=0 to PerfCounters.CounterCount - 1 do
    begin
        if PerfCounters.CounterTitle[i] = '' then continue;

        MI:=PerfMonitor.Items.Add;
        try
            MI.ObjectName:=ObjectName;
            MI.CounterName:=PerfCounters.CounterTitle[i];
        except
            MI.Free;
            continue;
        end;
        
        if AnsiCompareText(ObjectName,'Process') = 0 then
            MI.ObjectKey:='ID Process'
        else if AnsiCompareText(ObjectName,'Thread') = 0 then
            MI.ObjectKey:='ID Process';

        LC:=LV.Columns.Add;
        LC.Caption:=MI.CounterName;
    end;
    Refresh;
end;

procedure TObjectWithInsForm.LVEnter(Sender: TObject);
begin
    SetPanelState(PnCaption,True);
end;

procedure TObjectWithInsForm.LVExit(Sender: TObject);
begin
    SetPanelState(PnCaption,False);
end;

procedure TObjectWithInsForm.PnCaptionClick(Sender: TObject);
begin
    (Parent as TForm).ActiveControl:=LV;
end;

procedure TObjectWithInsForm.TimerTimer(Sender: TObject);
begin
    Refresh;
end;

procedure TObjectWithInsForm.Refresh;
var i,j,k: Integer;
    MI: TPerfMonitorItem;
    CV: TPerfMonitorCounterValue;
    LI: TListItem;
    LICaption: String;
begin
    PerfMonitor.Collect;
    LV.Items.BeginUpdate;
    LV.Items.Clear;

    for i:=0 to PerfMonitor.Items.Count-1 do
    begin
        MI:=PerfMonitor.Items[i];
        for j:=0 to MI.InstanceCount-1 do
        begin
            CV:=MI.InstanceValues[j];

            LICaption:=Format('%s(%s)',[CV.InstanceName,CV.ObjectKeyValue]);

            LI:=nil;
            for k:=0 to LV.Items.Count-1 do
            begin
                LI:=LV.Items[k];
                if LI.Caption = LICaption then break;
                LI:=nil;
            end;
            if LI = nil then
            begin
                LI:=LV.Items.Add;
                LI.Caption:=LICaption;
                for k:=0 to PerfMonitor.Items.Count-1 do LI.SubItems.Add('');
            end;
            LI.SubItems[i]:=Format('%s(%s)',[CV.AsString,CV.AvgAsString]);
        end;
    end;

    LV.Items.EndUpdate;
end;

end.
