unit fmObjectNoIns;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, PerfCounters, PerfMonitor;

type
  TObjectNoInsForm = class(TForm)
    PnCaption: TPanel;
    LV: TListView;
    PerfCounters: TPerfCounters;
    PerfMonitor: TPerfMonitor;
    Timer: TTimer;
    procedure LVEnter(Sender: TObject);
    procedure LVExit(Sender: TObject);
    procedure PnCaptionClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
    procedure Refresh;
  public
    { Public declarations }
    constructor Create(Owner: TComponent; ObjectName: String);
  end;


implementation

uses
    fmPerfExplorerMain;

{$R *.DFM}

constructor TObjectNoInsForm.Create(Owner: TComponent; ObjectName: String);
var i: Integer;
    MI: TPerfMonitorItem;
    LI: TListItem;
begin
    inherited Create(Owner);
    PerfCounters.ObjectName:=ObjectName;
    PnCaption.Caption:=Format(PnCaption.Caption,[ObjectName]);
    for i:=0 to PerfCounters.CounterCount - 1 do
    begin
        MI:=PerfMonitor.Items.Add;
        try
            MI.ObjectName:=ObjectName;
            MI.CounterName:=PerfCounters.CounterTitle[i];
        except
            MI.Free;
            continue;
        end;
        LI:=LV.Items.Add;
        LI.Caption:=MI.CounterName;
        LI.SubItems.Add('');
        LI.SubItems.Add('');
    end;
    Refresh;
end;

procedure TObjectNoInsForm.LVEnter(Sender: TObject);
begin
    SetPanelState(PnCaption,True);
end;

procedure TObjectNoInsForm.LVExit(Sender: TObject);
begin
    SetPanelState(PnCaption,False);
end;

procedure TObjectNoInsForm.PnCaptionClick(Sender: TObject);
begin
    (Parent as TForm).ActiveControl:=LV;
end;

procedure TObjectNoInsForm.TimerTimer(Sender: TObject);
begin
    Refresh;
end;

procedure TObjectNoInsForm.Refresh;
var i: Integer;
    MI: TPerfMonitorItem;
    CV: TPerfMonitorCounterValue;
    LI: TListItem;
begin
    PerfMonitor.Collect;
    LV.Items.BeginUpdate;

    for i:=0 to LV.Items.Count-1 do
    begin
        LI:=LV.Items[i];
        MI:=PerfMonitor.Items[i];
        CV:=MI.InstanceValues[0];

        LI.SubItems[0]:=CV.AsString+' '+MI.Suffix;
        LI.SubItems[1]:=CV.AvgAsString+' '+MI.Suffix;
    end;

    LV.Items.EndUpdate;
end;

end.
