unit fmAllDetails;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, PerfInstances, PerfCounters, PerfObjects;

type
  TAllDetailesForm = class(TForm)
    PnLV: TPanel;
    LV: TListView;
    PerfObjects: TPerfObjects;
    PerfCounters: TPerfCounters;
    PerfInstances: TPerfInstances;
    Timer: TTimer;
    procedure PnLVClick(Sender: TObject);
    procedure LVEnter(Sender: TObject);
    procedure LVExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
    procedure Refresh;
  public
    { Public declarations }
  end;


implementation

uses
    fmPerfExplorerMain;
{$R *.DFM}

procedure TAllDetailesForm.PnLVClick(Sender: TObject);
begin
    (Parent as TForm).ActiveControl:=LV;
end;

procedure TAllDetailesForm.LVEnter(Sender: TObject);
begin
    SetPanelState(PnLV,True);
end;

procedure TAllDetailesForm.LVExit(Sender: TObject);
begin
    SetPanelState(PnLV,False);
end;

procedure TAllDetailesForm.FormCreate(Sender: TObject);
var i: Integer;
    LI: TListItem;
begin
    for i:=0 to PerfObjects.ObjectCount-1 do
    begin
        if PerfObjects.ObjectTitle[i] = '' then continue;
        LI:=LV.Items.Add;
        LI.Caption:=PerfObjects.ObjectTitle[i];
        PerfCounters.ObjectName:=LI.Caption;
        LI.SubItems.Add(IntToStr(PerfCounters.CounterCount));
        LI.SubItems.Add('');
    end;
    Refresh;
end;

procedure TAllDetailesForm.Refresh;
var i: Integer;
    LI: TListItem;
begin
    LV.Items.BeginUpdate;
    for i:=0 to LV.Items.Count - 1 do
    begin
        LI:=LV.Items[i];
        if PerfObjects.ObjectData[PerfObjects.IndexOfObject[LI.Caption]].NumInstances >= 0 then
        begin
            PerfInstances.ObjectName:=LI.Caption;
            LI.SubItems[1]:=IntToStr(PerfInstances.InstanceCount);
        end else
            LI.SubItems[1]:='-';
    end;
    LV.Items.EndUpdate;
end;

procedure TAllDetailesForm.TimerTimer(Sender: TObject);
begin
    Refresh;
end;

end.
