unit fmMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PerfObjects, ExtCtrls, StdCtrls, Buttons, CheckLst, PerfData, PerfTitles,
  PerfFilter, WinPerf, WinPerfUtils;

type
  TMemoryLeakForm = class(TForm)
    CLBxObjects: TCheckListBox;
    BnStart: TBitBtn;
    BnStop: TBitBtn;
    Timer: TTimer;
    Label1: TLabel;
    Label3: TLabel;
    LbInitMax: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    LbCurMax: TLabel;
    LbIncMax: TLabel;
    LbAvgMax: TLabel;
    Label8: TLabel;
    LbCycles: TLabel;
    Bevel1: TBevel;
    PerfObjects: TPerfObjects;
    PerfTitles: TPerfTitles;
    PerfFilter: TPerfFilter;
    procedure FormCreate(Sender: TObject);
    procedure BnStartClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BnStopClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
    InitMax: TInt64;
    CurMax: TInt64;
    IncMax: TInt64;
    AvgMax: Double;
    Cycles: Integer;
    Process: DWORD;
    Data: TPerfData;
    ISBusy: Boolean;
    procedure Init;
    procedure Refresh;
  public
    { Public declarations }
  end;

var
  MemoryLeakForm: TMemoryLeakForm;

implementation

{$R *.DFM}

procedure TMemoryLeakForm.FormCreate(Sender: TObject);
var i: Integer;
begin
    Process:=GetCurrentProcess;
    Init;
    for i:=0 to PerfObjects.ObjectCount-1 do
    CLBxObjects.Items.Add(PerfObjects.ObjectTitle[i]);
end;

procedure TMemoryLeakForm.Init;
var i: Integer;
begin
    PerfFilter.Collect;
    for i:=0 to PerfFilter.Items[0].InstanceCount-1 do
    begin
        if AnsiCompareText(PerfFilter.Items[0].InstanceNames[i],'CheckLeaks') = 0 then
        begin
            InitMax:=PerfFilter.Items[0].InsCtrAsInteger(i);
            break;
        end;
    end;
    Cycles:=0;
    Refresh;
end;

procedure TMemoryLeakForm.Refresh;
var i: Integer;
begin
    PerfFilter.Collect;
    for i:=0 to PerfFilter.Items[0].InstanceCount-1 do
    begin
        if AnsiCompareText(PerfFilter.Items[0].InstanceNames[i],'CheckLeaks') = 0 then
        begin
            CurMax:=PerfFilter.Items[0].InsCtrAsInteger(i);
            break;
        end;
    end;

    IncMax:=CurMax-InitMax;
    if Cycles > 0 then
        AvgMax:=IncMax/Cycles;
    LbInitMax.Caption:=Int64ToStr(InitMax);
    LbCurMax.Caption:=Int64ToStr(CurMax);
    LbIncMax.Caption:=Int64ToStr(IncMax);
    LbAvgMax.Caption:=Format('%9.2f',[AvgMax]);
    LbCycles.Caption:=IntToStr(Cycles);
end;

procedure TMemoryLeakForm.BnStartClick(Sender: TObject);
var i: Integer;
    S: String;
begin
    S:='';
    for i:=0 to PerfObjects.ObjectCount-1 do
    begin
        if not CLBxObjects.Checked[i] then continue;
        S:=S+' '+PerfTitles.IdxOfTitle[CLBxObjects.Items[i]];
    end;
    if S = '' then exit;
    Data:=TPerfData.Create(S);
    Init;

    Timer.Enabled:=True;
    BnStart.Enabled:=False;
    BnStop.Enabled:=True;
end;

procedure TMemoryLeakForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
    CanClose:=not Timer.Enabled;
end;

procedure TMemoryLeakForm.BnStopClick(Sender: TObject);
begin
    Timer.Enabled:=False;
    BnStart.Enabled:=True;
    BnStop.Enabled:=False;
    Data.Free;
    Data:=nil;
end;

procedure TMemoryLeakForm.TimerTimer(Sender: TObject);
var i : Integer;
begin
    if IsBusy then exit;
    IsBusy := True;
    try
        for i:=1 to 10 do
        begin
            INC(Cycles);
            Data.Refresh;
        end;
        LbCycles.Caption:=IntToStr(Cycles);
        if (Cycles mod 1000) = 0 then Refresh;
    finally
        IsBusy := False;
    end;
end;

end.
