unit fmTaskView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, PerfFilter, Menus, ComCtrls, PerfData;

type
  TTaskViewForm = class(TForm)
    PerfFilter: TPerfFilter;
    Timer: TTimer;
    Panel1: TPanel;
    LV: TListView;
    MainMenu: TMainMenu;
    Help1: TMenuItem;
    About1: TMenuItem;
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
    _IsBusy: Boolean;
  public
    { Public declarations }
  end;

var
  TaskViewForm: TTaskViewForm;

const
    ProductName = 'TaskView';
    Version = '1.2';

implementation

uses fmAbout;

{$R *.DFM}

procedure TTaskViewForm.TimerTimer(Sender: TObject);
var i,j,c: Integer;
    CI,PCI: TPerfCounterItem;
    PID: Comp;
    ET : Double;
    LI: TListItem;
begin
    if _IsBusy then exit;
    _IsBusy :=True;
    try
        // Refresh performance information
        PerfFilter.Collect;

        LV.Items.BeginUpdate;

        // Adjust the number of ListView items.
        CI:=PerfFilter.Items[0];
        c:=CI.InstanceCount;
        while LV.Items.Count < c do LV.Items.Add;
        while LV.Items.Count > c do LV.Items.Delete(c);

        for i:=0 to c - 1 do
        begin
            LI:=LV.Items[i];
            LI.Caption:=CI.InstanceNames[i];

            // Get and display the counter values for each counter item.
            for j:=0 to PerfFilter.Items.Count-1 do
            begin
                PCI:=PerfFilter.Items[j];
                PID:=PCI.InsCtrAsInteger(i);
                if LI.SubItems.Count <= j then LI.SubItems.Add('');

                if AnsiCompareText(PCI.CounterName,'Elapsed time') = 0 then
                begin
                    ET:=(PCI.ObjectTime - PID)/PCI.ObjectFreq /24/3600;
                    LI.SubItems[j]:=FormatDateTime('hh:nn:ss',ET);
                end else
                    LI.SubItems[j]:=FormatFloat('0,',PID);
            end;
        end;
        LV.Items.EndUpdate;
    finally
        _IsBusy :=False;
    end;
end;

procedure TTaskViewForm.FormCreate(Sender: TObject);
var i,c: Integer;
    LC: TListColumn;
begin
    c:=PerfFilter.Items.Count;
    if LV.Columns.Count > c+1 then LV.Columns.Clear;
    while LV.Columns.Count < c+1 do LV.Columns.Add;

    // Fill ListView columns by names of counter items.
    LV.Columns.Items[0].Caption:='Task name';
    for i:=0 to c-1 do
    begin
        LC:=LV.Columns.Items[i+1];
        LC.Caption:=PerfFilter.Items[i].CounterName;
        LC.Alignment:=taRightJustify;
        LC.Width:=100;
    end;

    // Update display information.
    Timer.OnTimer(nil);
end;

procedure TTaskViewForm.About1Click(Sender: TObject);
begin
    with TAboutBox.Create(nil) do
    begin
        SetProductInfo(ProductName,Version);
        ShowModal;
    end;
end;

end.
