unit fmAbout;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ShellApi;

type
  TAboutBox = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    LbProductName: TLabel;
    LbVersion: TLabel;
    Copyright: TLabel;
    OKButton: TButton;
    LbProductTitle: TLabel;
    Bevel1: TBevel;
    LbMailTo: TLabel;
    LbHomepage: TLabel;
    procedure LbMailToClick(Sender: TObject);
    procedure LbHomepageClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetProductInfo(ProductName : String; Version: String);
  end;

var
  AboutBox: TAboutBox;

implementation

{$R *.DFM}

procedure TAboutBox.LbMailToClick(Sender: TObject);
begin
    ShellExecute(Application.Handle, 'open', 'mailto:aldyn@chat.ru?subject=Your PerfUtils Components',
        nil, nil, SW_SHOWDEFAULT);
end;

procedure TAboutBox.LbHomepageClick(Sender: TObject);
begin
    ShellExecute(Application.Handle, 'open', 'http://www.chat.ru/~aldyn/',
        nil, nil, SW_SHOWDEFAULT);
end;

procedure TAboutBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Action := caFree;
end;

procedure TAboutBox.SetProductInfo(ProductName : String; Version: String);
begin
    Caption:='About '+ProductName;
    LbProductTitle.Caption:=ProductName;
    LbVersion.Caption:='Version '+Version;
end;

end.

