{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Alexey A. Dynnikov
EMail:        aldyn@chat.ru
WebSite:      http://www.chat.ru/~aldyn/index.html
Support:      Use the e-mail aldyn@chat.ru

Creation:     May 23, 1998
Version:      1.00

Legal issues: Copyright (C) 1997 by Alexey A. Dynnikov <aldyn@chat.ru>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit ObjectPropertyEditor;

interface

uses
    Windows, Messages, SysUtils, Classes,
    Graphics, Controls, Forms, Dialogs, DsgnIntf,
    PerfTitles, PerfObjects, PerfCounters, PerfInstances,
    PerfFilter, PerfMonitor;

type
    TObjectPropertyEditor = class(TPropertyEditor)
    private
        _Objects: TPerfObjects;
    public
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure GetValues(Proc: TGetStrProc); override;
        procedure SetValue(const Value: string); override;
        destructor Destroy; override;
    end;

procedure DoRegister;

implementation

function TObjectPropertyEditor.GetAttributes: TPropertyAttributes;
begin
    result:=[paValueList, paSortList];
end;

function TObjectPropertyEditor.GetValue: string;
begin
    Result := GetStrValue;
end;

procedure TObjectPropertyEditor.GetValues(Proc: TGetStrProc);
var i: Integer;
    C: TPersistent;
begin
    if _Objects = nil then _Objects:=TPerfObjects.Create(nil);

    C:=GetComponent(0);
    if C is TPerfCounters then
        _Objects.LocaleID:=(C as TPerfCounters).LocaleID
    else

    if C is TPerfInstances then
        _Objects.LocaleID:=(C as TPerfInstances).LocaleID
    else

    if C is TPerfCounterItem then
        _Objects.LocaleID:=(C as TPerfCounterItem).Filter.LocaleID
    else

    if C is TPerfMonitorItem then
        _Objects.LocaleID:=(C as TPerfMonitorItem).Monitor.LocaleID
    else

        raise Exception.Create('Invalid property');

    for i:=0 to _Objects.ObjectCount-1 do Proc(_Objects.ObjectTitle[i]);
end;

procedure TObjectPropertyEditor.SetValue(const Value: string);
begin
    SetStrValue(Value);
end;

destructor TObjectPropertyEditor.Destroy;
begin
    _Objects.Free;
end;

procedure DoRegister;
begin
    RegisterPropertyEditor(TypeInfo(String),TPerfCounters,'ObjectName',TObjectPropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfInstances,'ObjectName',TObjectPropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfCounterItem,'ObjectName',TObjectPropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfMonitorItem,'ObjectName',TObjectPropertyEditor);
end;

end.
