unit fmPerfExplorerMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, PerfTitles, PerfObjects, PerfCounters,
  PerfInstances, Menus;

type
  TPerfExplorerMainForm = class(TForm)
    PnLeftPane: TPanel;
    TV: TTreeView;
    PnTV: TPanel;
    Splitter1: TSplitter;
    PerfHelps: TPerfHelps;
    PerfObjects: TPerfObjects;
    PerfCounters: TPerfCounters;
    MainMenu: TMainMenu;
    Help1: TMenuItem;
    About1: TMenuItem;
    procedure TVEnter(Sender: TObject);
    procedure TVExit(Sender: TObject);
    procedure PnTVClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TVChange(Sender: TObject; Node: TTreeNode);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
    _RightPane: TForm;
    procedure CreatePerformanceTree;
    procedure CreateObjectBranch(Node: TTreeNode; ObjectName: String; HasInstances: Boolean);
    procedure CreateCounterBranch(Node: TTreeNode; CounterName: String; HasInstances: Boolean);
    procedure SetRightPane(Form: TForm);
    property RightPane: TForm read _RightPane write SetRightPane;
  public
    { Public declarations }
  end;

var
  PerfExplorerMainForm: TPerfExplorerMainForm;

const
    ProductName = 'PerfExplorer';
    Version = '1.2';

procedure SetPanelState(Panel: TPanel; Active: Boolean);

implementation

uses
    fmAllDetails, fmObjectNoIns, fmObjectWithIns, fmCounterWithIns, fmAbout;

{$R *.DFM}

const
    PE_ALL                          = 0;
    PE_OBJECT_WITH_INSTANCES        = 1;
    PE_OBJECT_WITHOUT_INSTANCES     = 2;
    PE_COUNTER_WITH_INSTANCES       = 3;
    PE_COUNTER_WITHOUT_INSTANCES    = 4;

procedure SetPanelState(Panel: TPanel; Active: Boolean);
begin
    if Active then
    begin
        Panel.Color:=clBlue;
        Panel.Font.Color:=clHighlightText;
        Panel.Font.Style:=[fsBold];
    end else
    begin
        Panel.Color:=clBtnFace;
        Panel.Font.Color:=clBlack;
        Panel.Font.Style:=[];
    end;
end;

procedure TPerfExplorerMainForm.TVEnter(Sender: TObject);
begin
    SetPanelState(PnTV,True);
end;

procedure TPerfExplorerMainForm.TVExit(Sender: TObject);
begin
    SetPanelState(PnTV,False);
end;

procedure TPerfExplorerMainForm.PnTVClick(Sender: TObject);
begin
    ActiveControl:=TV;
end;

procedure TPerfExplorerMainForm.FormCreate(Sender: TObject);
begin
//    PerfHelps.Init;
    CreatePerformanceTree;
end;

procedure TPerfExplorerMainForm.CreatePerformanceTree;
var i: Integer;
    Node: TTreeNode;
begin
    Node:=TV.Items.AddChild(nil,'Performance objects');
    Node.Data:=Pointer(PE_ALL);

    for i:=0 to PerfObjects.ObjectCount-1 do
        CreateObjectBranch(Node,PerfObjects.ObjectTitle[i],PerfObjects.ObjectData[i].NumInstances >= 0);
end;

procedure TPerfExplorerMainForm.CreateObjectBranch(Node: TTreeNode; ObjectName: String; HasInstances: Boolean);
var ObjectNode: TTreeNode;
    i: Integer;
begin
    if Objectname = '' then exit;
    ObjectNode:=TV.Items.AddChild(Node,ObjectName);
    if HasInstances then
    begin
        ObjectNode.Data:=Pointer(PE_OBJECT_WITH_INSTANCES);

        PerfCounters.ObjectName:=ObjectName;

        for i:=0 to PerfCounters.CounterCount-1 do
        begin
            if PerfCounters.CounterTitle[i] = '' then continue;
            CreateCounterBranch(ObjectNode,PerfCounters.CounterTitle[i], HasInstances);
        end;
    end else
        ObjectNode.Data:=Pointer(PE_OBJECT_WITHOUT_INSTANCES);

end;

procedure TPerfExplorerMainForm.CreateCounterBranch(Node: TTreeNode; CounterName: String; HasInstances: Boolean);
var CounterNode : TTreeNode;
begin
    CounterNode:=TV.Items.AddChild(Node,CounterName);
    if HasInstances then
        CounterNode.Data:=Pointer(PE_COUNTER_WITH_INSTANCES)
    else
        CounterNode.Data:=Pointer(PE_COUNTER_WITHOUT_INSTANCES);
end;

procedure TPerfExplorerMainForm.TVChange(Sender: TObject; Node: TTreeNode);
begin
    case Integer(Node.Data) of
        PE_ALL:
            RightPane:=TAllDetailesForm.Create(nil);

        PE_OBJECT_WITHOUT_INSTANCES:
            RightPane:=TObjectNoInsForm.Create(nil,Node.Text);

        PE_OBJECT_WITH_INSTANCES:
            RightPane:=TObjectWithInsForm.Create(nil,Node.Text);

        PE_COUNTER_WITH_INSTANCES:
            RightPane:=TCounterWithInsForm.Create(nil,Node.Parent.Text,Node.Text);

    else
        RightPane:=nil;
    end;
end;

procedure TPerfExplorerMainForm.SetRightPane(Form: TForm);
begin

    if _RightPane <> nil then _RightPane.Release;
    _RightPane:=Form;

    if _RightPane <> nil then
    with _RightPane do
    begin
        BorderStyle:=bsNone;
        Align:=alClient;
        Realign;
        Parent:=Self;
        SetBounds(PnLeftPane.Width+3,Top,Self.ClientWidth-(PnLeftPane.Width+3),Self.ClientHEight);
        Visible:=True;
    end;
end;

procedure TPerfExplorerMainForm.About1Click(Sender: TObject);
begin
    with TAboutBox.Create(nil) do
    begin
        SetProductInfo(ProductName,Version);
        ShowModal;
    end;
end;

end.
