unit fmCounterWithIns;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, PerfCounters, PerfMonitor;

type
  TCounterWithInsForm = class(TForm)
    PnCaption: TPanel;
    LV: TListView;
    PerfCounters: TPerfCounters;
    PerfMonitor: TPerfMonitor;
    Timer: TTimer;
    procedure LVEnter(Sender: TObject);
    procedure LVExit(Sender: TObject);
    procedure PnCaptionClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private declarations }
    IsBusy: Boolean;
    procedure Refresh;
  public
    { Public declarations }
    constructor Create(Owner: TComponent; ObjectName,CounterName: String);
  end;


implementation

uses
    fmPerfExplorerMain;

{$R *.DFM}

constructor TCounterWithInsForm.Create(Owner: TComponent; ObjectName, CounterName: String);
var MI: TPerfMonitorItem;
begin
    inherited Create(Owner);
    PnCaption.Caption:=Format(PnCaption.Caption,[ObjectName,CounterName]);

    MI:=PerfMonitor.Items.Add;
    MI.ObjectName:=ObjectName;
    MI.CounterName:=CounterName;

    if AnsiCompareText(ObjectName,'Process') = 0 then MI.ObjectKey:='ID Process';
    if AnsiCompareText(ObjectName,'Thread') = 0 then MI.ObjectKey:='ID Process;ID Thread';
    Refresh;
end;

procedure TCounterWithInsForm.LVEnter(Sender: TObject);
begin
    SetPanelState(PnCaption,True);
end;

procedure TCounterWithInsForm.LVExit(Sender: TObject);
begin
    SetPanelState(PnCaption,False);
end;

procedure TCounterWithInsForm.PnCaptionClick(Sender: TObject);
begin
    (Parent as TForm).ActiveControl:=LV;
end;

procedure TCounterWithInsForm.TimerTimer(Sender: TObject);
begin
    Refresh;
end;

procedure TCounterWithInsForm.Refresh;
var i: Integer;
    MI: TPerfMonitorItem;
    CV: TPerfMonitorCounterValue;
    LI: TListItem;
begin
    if IsBusy then exit;
    IsBusy:=True;
    try
        PerfMonitor.Collect;
        LV.Items.BeginUpdate;
        MI:=PerfMonitor.Items[0];

        while LV.Items.Count > MI.InstanceCount do LV.Items[MI.InstanceCount].Free;
        while LV.Items.Count < MI.InstanceCount do
        begin
            LI:=LV.Items.Add;
            LI.SubItems.Add('');
            LI.SubItems.Add('');
        end;

        for i:=0 to LV.Items.Count-1 do
        begin
            LI:=LV.Items[i];
            CV:=MI.InstanceValues[i];

            LI.Caption:=CV.InstanceName;
            LI.SubItems[0]:=CV.AsString+' '+MI.Suffix;
            LI.SubItems[1]:=CV.AvgAsString+' '+MI.Suffix;
        end;

        LV.Items.EndUpdate;
    finally
        IsBusy:=False;
    end;
end;

end.
