// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PerfMonitor.pas' rev: 3.00

#ifndef PerfMonitorHPP
#define PerfMonitorHPP
#include <PerfTitles.hpp>
#include <WinPerfUtils.hpp>
#include <WinPerf.hpp>
#include <PerfFilter.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Perfmonitor
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TPerfMonitorCounterValue;
class PASCALIMPLEMENTATION TPerfMonitorCounterValue : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int _CounterType;
	bool _HasBase;
	bool _IsUsed;
	System::AnsiString _InstanceName;
	System::AnsiString _ObjectKeyValue;
	Classes::TNotifyEvent _OnDestroy;
	bool _PrevAvailable;
	int _RefreshCount;
	Extended _FirstCounter;
	Extended _FirstBase;
	Extended _PrevCounter;
	Extended _PrevBase;
	Extended _Counter;
	Extended _Base;
	Extended _SysTime;
	Extended _DeltaSysTime;
	Extended _TotalSysTime;
	Extended __fastcall GetAsFloat(void);
	Extended __fastcall GetAvgAsFloat(void);
	Extended __fastcall GetAsInteger(void);
	Extended __fastcall GetAvgAsInteger(void);
	System::AnsiString __fastcall GetAsString();
	System::AnsiString __fastcall GetAvgAsString();
	
public:
	__property int CounterType = {read=_CounterType, nodefault};
	__property int RefreshCount = {read=_RefreshCount, nodefault};
	__property Extended FirstCounter = {read=_FirstCounter};
	__property Extended FirstBase = {read=_FirstBase};
	__property Extended PrevCounter = {read=_PrevCounter};
	__property Extended PrevBase = {read=_PrevBase};
	__property Extended Counter = {read=_Counter};
	__property Extended Base = {read=_Base};
	__property bool HasBase = {read=_HasBase, nodefault};
	__property System::AnsiString ObjectKeyValue = {read=_ObjectKeyValue};
	__property System::AnsiString InstanceName = {read=_InstanceName};
	__property Classes::TNotifyEvent OnDestroy = {read=_OnDestroy, write=_OnDestroy};
	__property bool PrevAvailable = {read=_PrevAvailable, nodefault};
	__property Extended AsFloat = {read=GetAsFloat};
	__property Extended AvgAsFloat = {read=GetAvgAsFloat};
	__property Extended AsInteger = {read=GetAsInteger};
	__property Extended AvgAsInteger = {read=GetAvgAsInteger};
	__property System::AnsiString AsString = {read=GetAsString};
	__property System::AnsiString AvgAsString = {read=GetAvgAsString};
public:
	/* TObject.Create */ __fastcall TPerfMonitorCounterValue(void) : System::TObject() { }
	/* TObject.Destroy */ __fastcall virtual ~TPerfMonitorCounterValue(void) { }
	
};

class DELPHICLASS TPerfMonitorItem;
class DELPHICLASS TPerfMonitor;
class PASCALIMPLEMENTATION TPerfMonitorItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	System::AnsiString _ObjectKey;
	Classes::TList* _KeyCounters;
	Classes::TList* _InstanceValues;
	TPerfMonitorCounterValue* _NoInstanceValue;
	void __fastcall CreateKeyCounters(void);
	void __fastcall FreeKeyCounters(void);
	System::AnsiString _CounterName;
	System::AnsiString _ObjectName;
	Perffilter::TPerfCounterItem* _Counter;
	Perffilter::TPerfCounterItem* __fastcall Counter(void);
	System::AnsiString __fastcall GetObjectName();
	void __fastcall SetObjectName(System::AnsiString Value);
	System::AnsiString __fastcall GetObjectKey();
	void __fastcall SetObjectKey(System::AnsiString Value);
	System::AnsiString __fastcall GetCounterName();
	void __fastcall SetCounterName(System::AnsiString Value);
	Perffilter::TPerfCounterType* __fastcall GetCounterType(void);
	void __fastcall SetCounterType(Perffilter::TPerfCounterType* Value);
	void __fastcall Collect(void);
	Winperf::PPERF_COUNTER_DEFINITION __fastcall GetCounterDefinition(void);
	int __fastcall GetInstanceCount(void);
	TPerfMonitorCounterValue* __fastcall GetInstanceValues(int Index);
	void __fastcall CollectValue(TPerfMonitorCounterValue* CV, int InstanceIdx, bool JustCreated);
	void __fastcall CollectNoInstanceValue(TPerfMonitorCounterValue* CV, bool JustCreated);
	System::AnsiString __fastcall GetSuffix();
	
public:
	__property Winperf::PPERF_COUNTER_DEFINITION CounterDefinition = {read=GetCounterDefinition};
	TPerfMonitor* __fastcall Monitor(void);
	virtual void __fastcall Assign(Classes::TPersistent* Value);
	__fastcall virtual TPerfMonitorItem(Classes::TCollection* Collection);
	__fastcall virtual ~TPerfMonitorItem(void);
	bool __fastcall HasInstances(void);
	__property int InstanceCount = {read=GetInstanceCount, nodefault};
	__property TPerfMonitorCounterValue* InstanceValues[int Index] = {read=GetInstanceValues};
	__property System::AnsiString Suffix = {read=GetSuffix};
	
__published:
	__property System::AnsiString ObjectName = {read=GetObjectName, write=SetObjectName};
	__property System::AnsiString CounterName = {read=GetCounterName, write=SetCounterName};
	__property Perffilter::TPerfCounterType* CounterType = {read=GetCounterType, write=SetCounterType, 
		stored=false};
	__property System::AnsiString ObjectKey = {read=GetObjectKey, write=SetObjectKey};
};

class DELPHICLASS TPerfMonitorItems;
class PASCALIMPLEMENTATION TPerfMonitorItems : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TPerfMonitor* _Owner;
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	TPerfMonitorItem* __fastcall GetMonitorItems(int index);
	
public:
	__property TPerfMonitor* Owner = {read=_Owner};
	__property TPerfMonitorItem* Items[int index] = {read=GetMonitorItems/*, default*/};
	HIDESBASE TPerfMonitorItem* __fastcall Add(void);
	__fastcall TPerfMonitorItems(TPerfMonitor* Owner, System::TMetaClass* ItemClass);
public:
	/* TCollection.Destroy */ __fastcall virtual ~TPerfMonitorItems(void) { }
	
};

class PASCALIMPLEMENTATION TPerfMonitor : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool _JustCreated;
	Perffilter::TPerfFilter* _Filter;
	TPerfMonitorItems* _Items;
	Extended _SysTime;
	Extended _FirstSysTime;
	Extended _PrevSysTime;
	Extended _DeltaSysTime;
	Extended _TotalSysTime;
	void __fastcall SetItems(TPerfMonitorItems* Value);
	
protected:
	System::AnsiString __fastcall GetLocaleID();
	void __fastcall SetLocaleID(System::AnsiString Value);
	Perftitles::TPerfHelps* __fastcall GetHelps(void);
	void __fastcall SetHelps(Perftitles::TPerfHelps* Value);
	
public:
	__fastcall virtual TPerfMonitor(Classes::TComponent* AComponent);
	__fastcall virtual ~TPerfMonitor(void);
	void __fastcall Collect(void);
	
__published:
	__property System::AnsiString LocaleID = {read=GetLocaleID, write=SetLocaleID};
	__property TPerfMonitorItems* Items = {read=_Items, write=SetItems};
	__property Perftitles::TPerfHelps* Helps = {read=GetHelps, write=SetHelps};
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall ParseKey(System::AnsiString Key, Classes::TStrings* Keys);
extern PACKAGE void __fastcall DoRegister(void);

}	/* namespace Perfmonitor */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Perfmonitor;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// PerfMonitor
