{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Alexey A. Dynnikov
EMail:        aldyn@chat.ru
WebSite:      http://www.chat.ru/~aldyn/index.html
Support:      Use the e-mail aldyn@chat.ru

Creation:     May 23, 1998
Version:      1.00

Legal issues: Copyright (C) 1997 by Alexey A. Dynnikov <aldyn@chat.ru>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit ObjectKeyPropertyEditor;

interface


uses
    Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
    Buttons, PerfCounters, PerfMonitor, DsgnIntf;

type
  TObjectKeyPropertyForm = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    SrcList: TListBox;
    DstList: TListBox;
    SrcLabel: TLabel;
    DstLabel: TLabel;
    IncludeBtn: TSpeedButton;
    IncAllBtn: TSpeedButton;
    ExcludeBtn: TSpeedButton;
    ExAllBtn: TSpeedButton;
    PerfCounters: TPerfCounters;
    procedure IncludeBtnClick(Sender: TObject);
    procedure ExcludeBtnClick(Sender: TObject);
    procedure IncAllBtnClick(Sender: TObject);
    procedure ExcAllBtnClick(Sender: TObject);
    procedure MoveSelected(List: TCustomListBox; Items: TStrings);
    procedure SetItem(List: TListBox; Index: Integer);
    function GetFirstSelection(List: TCustomListBox): Integer;
    procedure SetButtons;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure InitItem(Item: String);
  public
    { Public declarations }
    procedure SetData(LocaleID,ObjectName,ObjectKey: String);
    function GetObjectKey: String;
  end;

type
    TObjectKeyPropertyEditor = class(TPropertyEditor)
        procedure Edit; override;
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure SetValue(const AValue: string); override;
    end;

procedure DoRegister;

implementation

{$R *.DFM}

procedure TObjectKeyPropertyForm.IncludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(SrcList);
  MoveSelected(SrcList, DstList.Items);
  SetItem(SrcList, Index);
end;

procedure TObjectKeyPropertyForm.ExcludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(DstList);
  MoveSelected(DstList, SrcList.Items);
  SetItem(DstList, Index);
end;

procedure TObjectKeyPropertyForm.IncAllBtnClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to SrcList.Items.Count - 1 do
    DstList.Items.AddObject(SrcList.Items[I], 
      SrcList.Items.Objects[I]);
  SrcList.Items.Clear;
  SetItem(SrcList, 0);
end;

procedure TObjectKeyPropertyForm.ExcAllBtnClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to DstList.Items.Count - 1 do
    SrcList.Items.AddObject(DstList.Items[I], DstList.Items.Objects[I]);
  DstList.Items.Clear;
  SetItem(DstList, 0);
end;

procedure TObjectKeyPropertyForm.MoveSelected(List: TCustomListBox; Items: TStrings);
var
  I: Integer;
begin
  for I := List.Items.Count - 1 downto 0 do
    if List.Selected[I] then
    begin
      Items.AddObject(List.Items[I], List.Items.Objects[I]);
      List.Items.Delete(I);
    end;
end;

procedure TObjectKeyPropertyForm.SetButtons;
var
  SrcEmpty, DstEmpty: Boolean;
begin
  SrcEmpty := SrcList.Items.Count = 0;
  DstEmpty := DstList.Items.Count = 0;
  IncludeBtn.Enabled := not SrcEmpty;
  IncAllBtn.Enabled := not SrcEmpty;
  ExcludeBtn.Enabled := not DstEmpty;
  ExAllBtn.Enabled := not DstEmpty;
end;

function TObjectKeyPropertyForm.GetFirstSelection(List: TCustomListBox): Integer;
begin
  for Result := 0 to List.Items.Count - 1 do
    if List.Selected[Result] then Exit;
  Result := LB_ERR;
end;

procedure TObjectKeyPropertyForm.SetItem(List: TListBox; Index: Integer);
var
  MaxIndex: Integer;
begin
  with List do
  begin
    SetFocus;
    MaxIndex := List.Items.Count - 1;
    if Index = LB_ERR then Index := 0
    else if Index > MaxIndex then Index := MaxIndex;
    Selected[Index] := True;
  end;
  SetButtons;
end;

procedure TObjectKeyPropertyForm.SetData(LocaleID,ObjectName,ObjectKey: String);
var i: Integer;
begin
    PerfCounters.LocaleID:=LocaleID;
    PerfCounters.ObjectName:=ObjectName;
    ParseKey(ObjectKey,DstList.Items);
    for i := 0 to PerfCounters.CounterCount - 1 do InitItem(PerfCounters.CounterTitle[i]);
end;

function TObjectKeyPropertyForm.GetObjectKey: String;
var i : Integer;
begin
    result:='';
    for i:=0 to DstList.Items.COunt-1 do
    begin
        if i > 0 then result:=result+';';
        result:=result+DstList.Items[i];
    end;
end;

procedure TObjectKeyPropertyForm.InitItem(Item: String);
begin
    if DstList.Items.IndexOf(Item) < 0 then SrcList.Items.Add(Item);
end;

procedure TObjectKeyPropertyForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    Action:=caHide;
end;

procedure TObjectKeyPropertyForm.FormCreate(Sender: TObject);
begin
    SrcList.Clear;
    DstList.Clear;
end;

//------------------------------------------------------------------------------
procedure TObjectKeyPropertyEditor.Edit;
var PMI: TPerfMonitorItem;
begin
    PMI:=GetComponent(0) as TPerfMonitorItem;
    with TObjectKeyPropertyForm.Create(nil) do
    begin
        SetData(PMI.Monitor.LocaleID,PMI.ObjectName,GetValue);
        if ShowModal = mrOK then SetValue(GetObjectKey);
        Release;
    end;
end;

function TObjectKeyPropertyEditor.GetAttributes: TPropertyAttributes;
begin
    result:=[paDialog];
end;

function TObjectKeyPropertyEditor.GetValue: string;
begin
    Result := GetStrValue;
end;

procedure TObjectKeyPropertyEditor.SetValue(const AValue: string);
begin
    SetStrValue(AValue);
end;


//------------------------------------------------------------------------------
procedure DoRegister;
begin
    RegisterPropertyEditor(TypeInfo(String),TPerfMonitorItem,'ObjectKey',TObjectKeyPropertyEditor);
end;


end.
