//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmAbout.h"
#include "fmPerfInfoMain.h"
#include "fmObjectInfo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfObjects"
#pragma link "PerfTitles"
#pragma link "WinPerf"
#pragma resource "*.dfm"
TPerfInfoMainForm *PerfInfoMainForm;


//---------------------------------------------------------------------------
__fastcall TPerfInfoMainForm::TPerfInfoMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TPerfInfoMainForm::About1Click(TObject *Sender)
{
    TAboutBox *bx;
    bx = new TAboutBox(NULL);
    bx -> SetProductInfo(ProductName,Version);
    bx -> ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TPerfInfoMainForm::Init()
{
    int i;
    AnsiString ObjectTitle;

    _ObjIdx=-1;

    PerfHelps -> Init();

    for(i=0 ; i < PerfObjects->ObjectCount; i++ )
    {
        ObjectTitle = PerfObjects->ObjectTitle[i];
        if( Trim(ObjectTitle) == "") continue;
        LBxObjects->Items->Add(ObjectTitle);
    }

    BnMoreInfo->Enabled=False;
}
//---------------------------------------------------------------------------
void __fastcall TPerfInfoMainForm::AddInfo(AnsiString InfoDesc,AnsiString Info)
{
    LBxObjectInfo->Items->Add(Format("%-21s = %-12s",ARRAYOFCONST((InfoDesc,Info))));
}
//---------------------------------------------------------------------------
void __fastcall TPerfInfoMainForm::FormCreate(TObject *Sender)
{
    Init();
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::LBxObjectsClick(TObject *Sender)
{
    PPERF_OBJECT_TYPE POT;
    int cr;

    if (_ObjIdx == LBxObjects->ItemIndex) return;
    _ObjIdx = LBxObjects->ItemIndex;

    LBxObjectInfo->Clear();
    if (_ObjIdx < 0) LBxObjectInfo->Items->Add("No object selected");

    BnMoreInfo->Enabled = _ObjIdx >= 0;

    POT = PerfObjects -> ObjectData[_ObjIdx];

    AddInfo("Total length",IntToStr(POT->TotalByteLength));
    AddInfo("Definition length",IntToStr(POT->DefinitionLength));
    AddInfo("Header length",IntToStr(POT->HeaderLength));
    AddInfo("Detail level",IntToStr(POT->DetailLevel));
    AddInfo("Number of counters",IntToStr(POT->NumCounters));
    AddInfo("Default counter",IntToStr(POT->DefaultCounter));
    AddInfo("Number of instances",IntToStr(POT->NumInstances));
    AddInfo("Code page",IntToStr(POT->CodePage));

    cr=Screen->Cursor;
    Screen->Cursor=crHourGlass;
    MObjectHelp->Text=PerfObjects->ObjectHelp[_ObjIdx];
    Screen->Cursor = TCursor(cr);

}
//---------------------------------------------------------------------------


void __fastcall TPerfInfoMainForm::LBxObjectsEnter(TObject *Sender)
{
    SetPanelState(PnObjects,True);
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::LBxObjectsExit(TObject *Sender)
{
    SetPanelState(PnObjects,False);
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::PnObjectsClick(TObject *Sender)
{
    ActiveControl=LBxObjects;
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::PnObjectInfoClick(TObject *Sender)
{
    ActiveControl=LBxObjectInfo;
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::PnObjectHelpClick(TObject *Sender)
{
    ActiveControl=MObjectHelp;
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::LBxObjectInfoEnter(TObject *Sender)
{
    SetPanelState(PnObjectInfo,True);
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::LBxObjectInfoExit(TObject *Sender)
{
    SetPanelState(PnObjectInfo,False);
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::MObjectHelpEnter(TObject *Sender)
{
    SetPanelState(PnObjectHelp,True);
}
//---------------------------------------------------------------------------

void __fastcall TPerfInfoMainForm::MObjectHelpExit(TObject *Sender)
{
    SetPanelState(PnObjectHelp,False);
}
//---------------------------------------------------------------------------
void __fastcall TPerfInfoMainForm::BnMoreInfoClick(TObject *Sender)
{
    if (_ObjIdx < 0)
    {
        Beep();
        return;
    }

    (new TObjectInfoForm(PerfObjects->ObjectTitle[_ObjIdx])) -> Show();
}
//---------------------------------------------------------------------------

