//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmObjectInfo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfCounters"
#pragma link "PerfInstances"
#pragma link "WinPerfUtils"
#pragma link "PerfTitles"
#pragma resource "*.dfm"
TObjectInfoForm *ObjectInfoForm;

//---------------------------------------------------------------------------
void SetPanelState(TPanel *Panel, Boolean Active)
{
    if (Active)
    {
        Panel->Color=clBlue;
        Panel->Font->Color=clHighlightText;
        Panel->Font->Style=Panel->Font->Style << fsBold;
    } else
    {
        Panel->Color=clBtnFace;
        Panel->Font->Color=clBlack;
        Panel->Font->Style.Clear();
    }
}


//---------------------------------------------------------------------------
__fastcall TObjectInfoForm::TObjectInfoForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
AnsiString TObjectInfoForm::GetObjectName()
{
    return PerfCounters->ObjectName;
}
//---------------------------------------------------------------------------
void TObjectInfoForm::AddInfo(AnsiString InfoDesc,AnsiString Info)
{
    LBxCounterInfo->Items->Add(Format("%-21s = %-12s",ARRAYOFCONST((InfoDesc,Info))));
}
//---------------------------------------------------------------------------
void TObjectInfoForm::AddCounterTypeExplanation(int CT)
{
    Boolean FirstPart;

#define AddExplanationPart(Part)                \
    {                                           \
        AnsiString S;                           \
        if (FirstPart)                          \
            S=AnsiString("          ")+Part;    \
        else                                    \
            S=AnsiString("       or ")+Part;    \
        LBxCounterInfo->Items->Add(S);          \
        FirstPart=False;                        \
    }

    FirstPart=True;
    switch (CT & CounterSizeMask)
    {
        case PERF_SIZE_DWORD : AddExplanationPart("PERF_SIZE_DWORD"); break;
        case PERF_SIZE_LARGE : AddExplanationPart("PERF_SIZE_LARGE"); break;
        case PERF_SIZE_ZERO  : AddExplanationPart("Perf_SIZE_ZERO");  break;
        case PERF_SIZE_VARIABLE_LEN : AddExplanationPart("PERF_SIZE_VARIABLE_LEN"); break;
    }

    switch (CT & CounterTypeMask)
    {
        case PERF_TYPE_NUMBER :
            {
                AddExplanationPart("PERF_TYPE_NUMBER");

                switch(CT & CounterSubTypeMask)
                {
                    case PERF_NUMBER_HEX : AddExplanationPart("PERF_NUMBER_HEX"); break;
                    case PERF_NUMBER_DECIMAL : AddExplanationPart("PERF_NUMBER_DECIMAL"); break;
                    case PERF_NUMBER_DEC_1000 : AddExplanationPart("PERF_NUMBER_DEC_1000"); break;
                    default:
                    AddExplanationPart("PERF_NUMBER_???");
                }
                break;
            }
        case PERF_TYPE_COUNTER :
            {
                AddExplanationPart("PERF_TYPE_COUNTER");

                switch(CT & CounterSubTypeMask)
                {
                    case PERF_COUNTER_VALUE : AddExplanationPart("PERF_COUNTER_VALUE"); break;
                    case PERF_COUNTER_RATE : AddExplanationPart("PERF_COUNTER_RATE"); break;
                    case PERF_COUNTER_FRACTION : AddExplanationPart("PERF_COUNTER_FRACTION"); break;
                    case PERF_COUNTER_BASE : AddExplanationPart("PERF_COUNTER_BASE"); break;
                    case PERF_COUNTER_ELAPSED : AddExplanationPart("PERF_COUNTER_ELAPSED"); break;
                    case PERF_COUNTER_QUEUELEN : AddExplanationPart("PERF_COUNTER_QUEUELEN"); break;
                    case PERF_COUNTER_HISTOGRAM : AddExplanationPart("PERF_COUNTER_HISTOGRAM"); break;
                    default:
                    AddExplanationPart("PERF_COUNTER_???");
                }
                break;
            }

        case PERF_TYPE_TEXT :
            {
                AddExplanationPart("PERF_TYPE_TEXT");

                switch(CT & CounterSubTypeMask )
                {
                    case PERF_TEXT_UNICODE : AddExplanationPart("PERF_TEXT_UNICODE"); break;
                    case PERF_TEXT_ASCII : AddExplanationPart("PERF_TEXT_ASCII"); break;
                    default:
                        AddExplanationPart("PERF_TEXT_???");
                }
                break;
            }

        case PERF_TYPE_ZERO : AddExplanationPart("PERF_TYPE_ZERO"); break;

        default:
            AddExplanationPart("PERF_TYPE_???");
    }

    switch (CT & CounterTimeBaseMask)
    {
        case PERF_TIMER_TICK : AddExplanationPart("PERF_TIMER_TICK"); break;
        case PERF_TIMER_100NS : AddExplanationPart("PERF_TIMER_100NS"); break;
        case PERF_OBJECT_TIMER : AddExplanationPart("PERF_OBJECT_TIMER"); break;
        default:
        AddExplanationPart("PERF_TIME_???");
    }

    if ((CT & PERF_DELTA_COUNTER) != 0) AddExplanationPart("PERF_DELTA_COUNTER");
    if ((CT & PERF_DELTA_BASE) != 0) AddExplanationPart("PERF_DELTA_BASE");
    if ((CT & PERF_INVERSE_COUNTER) != 0) AddExplanationPart("PERF_INVERSE_COUNTER");
    if ((CT & PERF_MULTI_COUNTER) != 0) AddExplanationPart("PERF_MULTI_COUNTER");

    switch ( CT & CounterDisplayMask )
    {
        case PERF_DISPLAY_NO_SUFFIX : AddExplanationPart("PERF_DISPLAY_NO_SUFFIX"); break;
        case PERF_DISPLAY_PER_SEC : AddExplanationPart("PERF_DISPLAY_PER_SEC"); break;
        case PERF_DISPLAY_PERCENT : AddExplanationPart("PERF_DISPLAY_PERCENT"); break;
        case PERF_DISPLAY_SECONDS : AddExplanationPart("PERF_DISPLAY_SECONDS"); break;
        case PERF_DISPLAY_NOSHOW : AddExplanationPart("PERF_DISPLAY_NOSHOW"); break;
        default:
        AddExplanationPart("PERF_DISPLAY_???");
    }

}
//---------------------------------------------------------------------------
__fastcall TObjectInfoForm::TObjectInfoForm(AnsiString ObjectName)
    : TForm(Application)
{
    int i;
    AnsiString CounterTitle;

    _CounterIDX = -1;
    PerfCounters -> ObjectName = ObjectName;
    Caption = Format("Performance object ""%s"" information",ARRAYOFCONST((ObjectName)));
    for (i=0; i < PerfCounters->CounterCount; i++)
    {
        CounterTitle = PerfCounters -> CounterTitle[i];
        if ( Trim(CounterTitle) == "" ) continue;
        LBxCounters->Items->Add(CounterTitle);
    }

    try
    {
        PerfInstances->ObjectName = ObjectName;
        for( i=0; i < PerfInstances->InstanceCount; i++ )
            LBxInstances->Items->Add(PerfInstances->InstanceName[i]);
    }
    catch(Exception &exception)
    {
        Timer -> Enabled = False;
        TShInstances->Free();
    }

}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::TimerTimer(TObject *Sender)
{
    int i;
    TStrings *SL;

    PerfInstances->Refresh();
    SL = LBxInstances->Items;
    for ( i=0; i < PerfInstances->InstanceCount; i++)
    {
        if (SL->Count <= i)
            SL->Add(PerfInstances->InstanceName[i]);
        else
            SL->Strings[i]=PerfInstances->InstanceName[i];
    }

    while (SL->Count > PerfInstances->InstanceCount) SL->Delete(SL->Count-1);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::PnCountersClick(TObject *Sender)
{
    ActiveControl=LBxCounters;
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::PnCounterInfoClick(TObject *Sender)
{
    ActiveControl=LBxCounterInfo;
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::PnCounterHelpClick(TObject *Sender)
{
    ActiveControl=MCounterHelp;
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::LBxCountersEnter(TObject *Sender)
{
    SetPanelState(PnCounters,True);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::LBxCountersExit(TObject *Sender)
{
    SetPanelState(PnCounters,False);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::LBxCounterInfoEnter(TObject *Sender)
{
    SetPanelState(PnCounterInfo,True);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::LBxCounterInfoExit(TObject *Sender)
{
    SetPanelState(PnCounterInfo,False);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::MCounterHelpEnter(TObject *Sender)
{
    SetPanelState(PnCounterHelp,True);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::MCounterHelpExit(TObject *Sender)
{
    SetPanelState(PnCounterHelp,False);
}
//---------------------------------------------------------------------------
void __fastcall TObjectInfoForm::LBxCountersClick(TObject *Sender)
{
    PPERF_COUNTER_DEFINITION PCD;

    if (_CounterIDX == LBxCounters->ItemIndex) return;

    _CounterIDX = LBxCounters->ItemIndex;

    LBxCounterInfo->Clear();
    MCounterHelp->Clear();

    if (_CounterIDX < 0)
    {
        LBxCounterInfo->Items->Add("No counter selected");
        return;
    }

    PCD = PerfCounters->CounterData[_CounterIDX];

    AddInfo("Length",IntToStr(PCD->ByteLength));
    AddInfo("Default scale",IntToStr(PCD->DefaultScale));
    AddInfo("Detail level",IntToStr(PCD->DetailLevel));


    AddInfo("Counter type","$"+Int64ToHex(PCD->CounterType,8));

    AddCounterTypeExplanation(PCD->CounterType);

    AddInfo("Counter size",IntToStr(PCD->CounterSize));
    AddInfo("Counter offset",IntToStr(PCD->CounterOffset));

    MCounterHelp->Text=PerfCounters->CounterHelp[_CounterIDX];
}
//---------------------------------------------------------------------------
