//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmAbout.h"
#include "fmWait.h"
#include "fmPerfExplorerMain.h"
#include "fmObjectNoIns.h"
#include "fmAllDetails.h"
#include "fmObjectWithIns.h"
#include "fmCounterWithIns.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfCounters"
#pragma link "PerfObjects"
#pragma link "PerfTitles"
#pragma resource "*.dfm"
TPerfExplorerMainForm * PerfExplorerMainForm;

//---------------------------------------------------------------------------
#define PE_ALL                          0
#define PE_OBJECT_WITH_INSTANCES        1
#define PE_OBJECT_WITHOUT_INSTANCES     2
#define PE_COUNTER_WITH_INSTANCES       3
#define PE_COUNTER_WITHOUT_INSTANCES    4
//---------------------------------------------------------------------------
__fastcall TPerfExplorerMainForm::TPerfExplorerMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void SetPanelState(TPanel * Panel, Boolean Active)
{
    if (Active)
    {
        Panel->Color = clBlue;
        Panel->Font->Color = clHighlightText;
        Panel->Font->Style=Panel->Font->Style << fsBold;
    }
    else
    {
        Panel->Color = clBtnFace;
        Panel->Font->Color = clBlack;
        Panel->Font->Style.Clear();
    }
}

//---------------------------------------------------------------------------
void TPerfExplorerMainForm::CreatePerformanceTree()
{
    int i;
    TTreeNode * Node;

    Node = TV -> Items -> AddChild(NULL,"Performance objects");
    Node -> Data = (void *)PE_ALL;

    for ( i=0; i < PerfObjects -> ObjectCount; i++)
        CreateObjectBranch(Node,PerfObjects -> ObjectTitle[i], PerfObjects -> ObjectData[i]-> NumInstances >= 0);
}
//---------------------------------------------------------------------------
void TPerfExplorerMainForm::CreateObjectBranch(TTreeNode * Node, AnsiString ObjectName, Boolean HasInstances)
{
    TTreeNode * ObjectNode;
    int i;

    if (ObjectName == "") return;

    ObjectNode = TV -> Items -> AddChild(Node,ObjectName);
    if (HasInstances)
    {
        ObjectNode->Data = (void *)PE_OBJECT_WITH_INSTANCES;

        PerfCounters -> ObjectName = ObjectName;

        for (i=0; i < PerfCounters->CounterCount; i++)
        {
            if (PerfCounters->CounterTitle[i] == "") continue;
            CreateCounterBranch(ObjectNode,PerfCounters->CounterTitle[i], HasInstances);
        }
    } else
        ObjectNode->Data=(void *)PE_OBJECT_WITHOUT_INSTANCES;
}
//---------------------------------------------------------------------------
void TPerfExplorerMainForm::CreateCounterBranch(TTreeNode * Node, AnsiString CounterName, Boolean HasInstances)
{
    TTreeNode * CounterNode;

    if (CounterName == "") return;

    CounterNode = TV -> Items -> AddChild(Node,CounterName);
    if (HasInstances)
        CounterNode->Data=(void*)PE_COUNTER_WITH_INSTANCES;
    else
        CounterNode->Data=(void*)PE_COUNTER_WITHOUT_INSTANCES;
}
//---------------------------------------------------------------------------
void TPerfExplorerMainForm::SetRightPane(TForm * Form)
{
    if (_RightPane != NULL) _RightPane->Release();
    _RightPane = Form;

    if (_RightPane != NULL)
    {
        _RightPane -> BorderStyle = bsNone;
        _RightPane -> Align = alClient;
        _RightPane -> Realign();
        _RightPane -> Parent = this;
        _RightPane -> SetBounds(PnLeftPane->Width+3,_RightPane -> Top,ClientWidth-(PnLeftPane->Width+3),ClientHeight);
        _RightPane -> Visible = True;
    }
}
//---------------------------------------------------------------------------
void __fastcall TPerfExplorerMainForm::FormCreate(TObject *Sender)
{
    CreatePerformanceTree();
}
//---------------------------------------------------------------------------

void __fastcall TPerfExplorerMainForm::TVChange(TObject *Sender,
      TTreeNode *Node)
{
    switch((int)Node->Data)
    {
        case PE_ALL:
            RightPane = new TAllDetailesForm(NULL);
            break;

        case PE_OBJECT_WITHOUT_INSTANCES:
            RightPane = new TObjectNoInsForm(NULL,Node->Text);
            break;

        case PE_OBJECT_WITH_INSTANCES:
            RightPane= new TObjectWithInsForm(NULL,Node->Text);
            break;

        case PE_COUNTER_WITH_INSTANCES:
            RightPane= new TCounterWithInsForm(NULL,Node->Parent->Text,Node->Text);
            break;

        default:
            RightPane=NULL;
    }

}
//---------------------------------------------------------------------------
void __fastcall TPerfExplorerMainForm::PnTVClick(TObject *Sender)
{
    ActiveControl = TV;
}
//---------------------------------------------------------------------------

void __fastcall TPerfExplorerMainForm::TVEnter(TObject *Sender)
{
    SetPanelState(PnTV,True);
}
//---------------------------------------------------------------------------

void __fastcall TPerfExplorerMainForm::TVExit(TObject *Sender)
{
    SetPanelState(PnTV,False);
}
//---------------------------------------------------------------------------

void __fastcall TPerfExplorerMainForm::About1Click(TObject *Sender)
{
    TAboutBox * bx;
    bx = new TAboutBox(NULL);
    bx -> SetProductInfo(ProductName,Version);
    bx -> ShowModal();
}
//---------------------------------------------------------------------------

