//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmObjectWithIns.h"
#include "fmPerfExplorerMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfCounters"
#pragma link "PerfMonitor"
#pragma resource "*.dfm"
TObjectWithInsForm *ObjectWithInsForm;
//---------------------------------------------------------------------------
__fastcall TObjectWithInsForm::TObjectWithInsForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
__fastcall TObjectWithInsForm::TObjectWithInsForm(TComponent * Owner, AnsiString ObjectName)
    : TForm(Owner)
{
    int i;
    TPerfMonitorItem * MI;
    TListColumn * LC;

    PerfCounters->ObjectName = ObjectName;
    PnCaption -> Caption = Format(PnCaption->Caption,ARRAYOFCONST((ObjectName)));

    for( i=0; i < PerfCounters->CounterCount; i++)
    {
        if(PerfCounters->CounterTitle[i] == "") continue;

        MI = PerfMonitor->Items->Add();
        try
        {
            MI->ObjectName = ObjectName;
            MI->CounterName = PerfCounters->CounterTitle[i];

            if (AnsiCompareText(ObjectName,"Process") == 0)
                MI->ObjectKey="ID Process";
            else if(AnsiCompareText(ObjectName,"Thread") == 0)
                MI->ObjectKey="ID Process";

            LC=LV->Columns->Add();
            LC->Caption=MI->CounterName;
        }
        catch(Exception &E)
        {
            MI->Free();
        }

    }

    Refresh();
}
//---------------------------------------------------------------------------
void TObjectWithInsForm::Refresh()
{
    if (_IsBusy) return;
    _IsBusy = TRUE;
    try
    {
        int i,j,k;
        TPerfMonitorItem * MI;
        TPerfMonitorCounterValue * CV;
        TListItem * LI;
        AnsiString LICaption;

        PerfMonitor -> Collect();
        LV -> Items -> BeginUpdate();
        LV -> Items -> Clear();

        for (i=0; i < PerfMonitor -> Items -> Count; i++)
        {
            MI = PerfMonitor -> Items -> Items[i];
            for (j=0; j < MI -> InstanceCount; j++)
            {
                CV = MI -> InstanceValues[j];

                LICaption = CV -> InstanceName + "(" +CV -> ObjectKeyValue+")";

                LI = NULL;
                for ( k=0; k < LV -> Items -> Count; k++)
                {
                    LI = LV -> Items->Item[k];
                    if (LI -> Caption == LICaption) break;
                    LI = NULL;
                }
                if (LI == NULL)
                {
                    LI = LV -> Items -> Add();
                    LI -> Caption = LICaption;
                    for (k=0; k < PerfMonitor -> Items -> Count; k++) LI -> SubItems -> Add("");
                }
                LI -> SubItems -> Strings[i] =CV -> AsString+"("+CV -> AvgAsString+")";
            }
        }

    }
    catch(Exception &E)
    {
    }
    LV -> Items -> EndUpdate();
    _IsBusy = FALSE;
}
//---------------------------------------------------------------------------

void __fastcall TObjectWithInsForm::LVEnter(TObject *Sender)
{
    SetPanelState(PnCaption,True);
}
//---------------------------------------------------------------------------

void __fastcall TObjectWithInsForm::LVExit(TObject *Sender)
{
    SetPanelState(PnCaption,FALSE);
}
//---------------------------------------------------------------------------

void __fastcall TObjectWithInsForm::TimerTimer(TObject *Sender)
{
    Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TObjectWithInsForm::PnCaptionClick(TObject *Sender)
{
    ((TForm*)Parent)->ActiveControl=LV;
}
//---------------------------------------------------------------------------

