//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmCounterWithIns.h"
#include "fmPerfExplorerMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfCounters"
#pragma link "PerfMonitor"
#pragma resource "*.dfm"
TCounterWithInsForm *CounterWithInsForm;
//---------------------------------------------------------------------------
__fastcall TCounterWithInsForm::TCounterWithInsForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
__fastcall TCounterWithInsForm::TCounterWithInsForm(TComponent * Owner, AnsiString ObjectName,AnsiString CounterName)
    : TForm(Owner)
{
    TPerfMonitorItem * MI;

    PnCaption->Caption = Format(PnCaption->Caption,ARRAYOFCONST((ObjectName,CounterName)));

    MI = PerfMonitor->Items->Add();
    MI -> ObjectName = ObjectName;
    MI -> CounterName = CounterName;

    if (AnsiCompareText(ObjectName,"Process") == 0)  MI->ObjectKey="ID Process";
    if (AnsiCompareText(ObjectName,"Thread") == 0) MI->ObjectKey="ID Process;ID Thread";
    Refresh();
}
//---------------------------------------------------------------------------
void TCounterWithInsForm::Refresh()
{
    int i;
    TPerfMonitorItem * MI;
    TPerfMonitorCounterValue * CV;
    TListItem * LI;

    if (_IsBusy) return;
    _IsBusy = TRUE;
    try
    {
        PerfMonitor->Collect();
        LV->Items->BeginUpdate();
        MI = PerfMonitor->Items->Items[0];

        while( LV->Items->Count > MI->InstanceCount ) LV->Items->Item[MI->InstanceCount]->Free();
        while( LV->Items->Count < MI->InstanceCount )
        {
            LI = LV->Items->Add();
            LI->SubItems->Add("");
            LI->SubItems->Add("");
        }

        for (i=0; i < LV->Items->Count; i++)
        {
            LI=LV->Items->Item[i];
            CV=MI->InstanceValues[i];

            LI->Caption=CV->InstanceName;
            LI->SubItems->Strings[0]=CV->AsString+" "+MI->Suffix;
            LI->SubItems->Strings[1]=CV->AvgAsString+" "+MI->Suffix;
        }
    }
    catch(Exception &E)
    {
    }
    _IsBusy = FALSE;
    LV->Items->EndUpdate();
}
//---------------------------------------------------------------------------
void __fastcall TCounterWithInsForm::PnCaptionClick(TObject *Sender)
{
    ((TForm*)Parent)->ActiveControl=LV;
}
//---------------------------------------------------------------------------
void __fastcall TCounterWithInsForm::LVEnter(TObject *Sender)
{
    SetPanelState(PnCaption,True);
}
//---------------------------------------------------------------------------
void __fastcall TCounterWithInsForm::LVExit(TObject *Sender)
{
    SetPanelState(PnCaption,FALSE);
}
//---------------------------------------------------------------------------
void __fastcall TCounterWithInsForm::TimerTimer(TObject *Sender)
{
    Refresh();    
}
//---------------------------------------------------------------------------

