//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmAllDetails.h"
#include "fmPerfExplorerMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfCounters"
#pragma link "PerfInstances"
#pragma link "PerfObjects"
#pragma resource "*.dfm"
TAllDetailesForm *AllDetailesForm;
//---------------------------------------------------------------------------
__fastcall TAllDetailesForm::TAllDetailesForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TAllDetailesForm::FormCreate(TObject *Sender)
{
    int i;
    TListItem * LI;

    for( i = 0; i < PerfObjects->ObjectCount; i++)
    {
        if( PerfObjects->ObjectTitle[i] == "") continue;

        LI = LV->Items->Add();
        LI->Caption = PerfObjects->ObjectTitle[i];
        PerfCounters->ObjectName = LI->Caption;
        LI->SubItems->Add(IntToStr(PerfCounters->CounterCount));
        LI->SubItems->Add("");
    }
    Refresh();
}
//---------------------------------------------------------------------------
void TAllDetailesForm::Refresh()
{
    int i;
    TListItem * LI;

    if(_IsBusy) return;

    _IsBusy = TRUE;
    try
    {
        LV->Items->BeginUpdate();
        for(i=0; i < LV->Items->Count; i++)
        {
            LI = LV->Items->Item[i];

            if (LI->Caption == "") continue;

            if (PerfObjects->ObjectData[PerfObjects->IndexOfObject[LI->Caption]]->NumInstances >= 0)
            {
                PerfInstances->ObjectName=LI->Caption;
                LI->SubItems->Strings[1] = IntToStr(PerfInstances->InstanceCount);
            } else
                LI->SubItems->Strings[1]='-';
        }
    }
    catch(Exception &E)
    {
    }

    _IsBusy = FALSE;

    LV->Items->EndUpdate();
}
void __fastcall TAllDetailesForm::LVEnter(TObject *Sender)
{
    SetPanelState(PnLV,True);
}
//---------------------------------------------------------------------------
void __fastcall TAllDetailesForm::LVExit(TObject *Sender)
{
    SetPanelState(PnLV,False);
}
//---------------------------------------------------------------------------
void __fastcall TAllDetailesForm::PnLVClick(TObject *Sender)
{
    ((TForm * )Parent)->ActiveControl=LV;
}
//---------------------------------------------------------------------------
void __fastcall TAllDetailesForm::TimerTimer(TObject *Sender)
{
    Refresh();    
}
//---------------------------------------------------------------------------
