unit PBEditPackDemo_unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DBCtrls, PBDBEdit, PBBinHexEdit, Mask, PBMaskEdit, StdCtrls,
  PBEdit, PBNumEdit, Spin, PBSpinEdit;

type
  TPBEditPackDemoForm = class(TForm)
    PBNumEdit1: TPBNumEdit;
    PBEdit1: TPBEdit;
    PBMaskEdit1: TPBMaskEdit;
    PBBinHexEdit1: TPBBinHexEdit;
    PBDBEdit1: TPBDBEdit;
    Bevel1: TBevel;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button2: TButton;
    Bevel2: TBevel;
    Button3: TButton;
    DecimalEdit: TPBNumEdit;
    SetDecimals: TButton;
    PBSpinEdit1: TPBSpinEdit;
    procedure Button1Click(Sender: TObject);
    procedure PBDBEdit1SetEdit(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SetDecimalsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PBEditPackDemoForm: TPBEditPackDemoForm;

implementation

{$R *.DFM}

procedure TPBEditPackDemoForm.Button1Click(Sender: TObject);
begin
	if PBEdit1.Alignment = taCenter then PBEdit1.Alignment := taLeftJustify
	else if PBEdit1.Alignment = taLeftJustify then PBEdit1.Alignment := taRightJustify
	else PBEdit1.Alignment := taCenter;
	if PBMaskEdit1.Alignment = taCenter then PBMaskEdit1.Alignment := taLeftJustify
	else if PBMaskEdit1.Alignment = taLeftJustify then PBMaskEdit1.Alignment := taRightJustify
	else PBMaskEdit1.Alignment := taCenter;
	if PBDBEdit1.Alignment = taCenter then PBDBEdit1.Alignment := taLeftJustify
	else if PBDBEdit1.Alignment = taLeftJustify then PBDBEdit1.Alignment := taRightJustify
	else PBDBEdit1.Alignment := taCenter;
	If PBNumEdit1.Alignment = taRightJustify then PBNumEdit1.Alignment := taCenter
	else if PBNumEdit1.Alignment = taCenter then PBNumEdit1.Alignment := taLeftJustify
	else PBNumEdit1.Alignment := taRightJustify;
	if PBBinHexEdit1.Alignment = taCenter then PBBinHexEdit1.Alignment := taLeftJustify
	else if PBBinHexEdit1.Alignment = taLeftJustify then PBBinHexEdit1.Alignment := taRightJustify
	else PBBinHexEdit1.Alignment := taCenter;
	if PBSpinEdit1.Alignment = taCenter then PBSpinEdit1.Alignment := taLeftJustify
	else if PBSpinEdit1.Alignment = taLeftJustify then PBSpinEdit1.Alignment := taRightJustify
	else PBSpinEdit1.Alignment := taCenter;
end;

procedure TPBEditPackDemoForm.PBDBEdit1SetEdit(Sender: TObject);
begin
	PBDBEdit1.EditText := 'PBDBEdit1';
end;

procedure TPBEditPackDemoForm.Button2Click(Sender: TObject);
begin
	if PBBinHexEdit1.BaseFormat = Binary then PBBinHexEdit1.BaseFormat := HexaDecimal
	else if PBBinHexEdit1.BaseFormat = HexaDecimal then PBBinHexEdit1.BaseFormat := Number
	else if PBBinHexEdit1.BaseFormat = Number then PBBinHexEdit1.BaseFormat := Binary;
end;

procedure TPBEditPackDemoForm.Button3Click(Sender: TObject);
begin
	if PBNumEdit1.NumberFormat = Engineering then PBNumEdit1.NumberFormat := Standard
	else if PBNumEdit1.NumberFormat = Standard then PBNumEdit1.NumberFormat := Thousands
	else if PBNumEdit1.NumberFormat = Thousands then PBNumEdit1.NumberFormat := Scientific
	else PBNumEdit1.NumberFormat := Engineering;
end;

procedure TPBEditPackDemoForm.FormCreate(Sender: TObject);
begin
	DecimalEdit.AsInteger := PBNumEdit1.Decimals;
  PBDBEdit1SetEdit(Sender);
end;

procedure TPBEditPackDemoForm.SetDecimalsClick(Sender: TObject);
begin
	PBNumEdit1.Decimals := DecimalEdit.AsInteger;
	DecimalEdit.AsInteger := PBNumEdit1.Decimals;
end;

end.

