unit UTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,UParseText,
  StdCtrls;

type
  TTestForm = class(TForm)
    Edit1: TEdit;
    ff: TButton;
    Memo1: TMemo;
    fn: TButton;
    sp: TButton;
    fp: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label6: TLabel;
    CaseSensitive: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure ffClick(Sender: TObject);
    procedure fnClick(Sender: TObject);
    procedure spClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure fpClick(Sender: TObject);
    procedure CaseSensitiveClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    loc : TLocation;
    ParseText1: TParseText;
    procedure ParseText1AfterFindFirst(actMatch: Integer);
    procedure ParseText1AfterFindNext(actMatch: Integer);
    procedure ParseText1AfterFindPrev(actMatch: Integer);
  end;

var
  TestForm: TTestForm;

implementation

{$R *.DFM}

procedure TTestForm.FormCreate(Sender: TObject);
begin
  ParseText1 := TParseText.Create(self);
  ParseText1.OnAfterFindFirst := ParseText1AfterFindFirst;
  ParseText1.OnAfterFindNext := ParseText1AfterFindNext;
  ParseText1.OnAfterFindPrev := ParseText1AfterFindPrev;
  ParseText1.text := memo1.Text;
  ParseText1.pattern := edit1.text; 
  ParseText1.casesensitive := CaseSensitive.Checked;
  memo1.SelStart := 0;
  memo1.SelLength := 0;
end;

procedure TTestForm.ffClick(Sender: TObject);
begin
  try
    if ParseText1.findFirst(loc) then
      begin
        fp.Enabled := True;
        fn.Enabled := True;
        sp.Enabled := True;
        memo1.SetFocus;
        memo1.SelStart := loc.start-1;
        memo1.SelLength := loc.len;
      end
    else
      begin
        fp.Enabled := False;
        fn.Enabled := False;
        sp.Enabled := True;
        MessageDlg('No matches found',mtInformation,[mbOK],0);
      end;
  except on E : Exception do
    begin
      fp.Enabled := False;
      fn.Enabled := False;
      sp.Enabled := False;
      MessageDlg(E.Message,mtError,[mbOK],0);
    end;
  end;
end;

procedure TTestForm.fpClick(Sender: TObject);
begin
  try
    if ParseText1.findPrev(loc) then
      begin
        fn.Enabled := True;
      end
    else
      begin
        fp.Enabled := False;
        MessageDlg('No previous match',mtInformation,[mbOK],0);
      end;       
    memo1.SetFocus;
    memo1.SelStart := loc.start-1;
    memo1.SelLength := loc.len;
  except on E : Exception do
    begin
      fp.Enabled := False;
      fn.Enabled := False;
      sp.Enabled := False;
      MessageDlg(E.Message,mtError,[mbOK],0);
    end;
  end;
end;

procedure TTestForm.fnClick(Sender: TObject);
begin  
  try
    if ParseText1.findNext(loc) then
      begin
        fp.Enabled := True;
      end
    else
      begin
        fn.Enabled := False;
        MessageDlg('No next match',mtInformation,[mbOK],0);
      end;          
    memo1.SetFocus;
    memo1.SelStart := loc.start-1;
    memo1.SelLength := loc.len;
  except on E : Exception do
    begin
      fp.Enabled := False;
      fn.Enabled := False;
      sp.Enabled := False;
      MessageDlg(E.Message,mtError,[mbOK],0);
    end;
  end;
end;

procedure TTestForm.spClick(Sender: TObject);
begin
  ParseText1.showPattern;
end;

procedure TTestForm.Edit1Change(Sender: TObject);
begin
  ParseText1.pattern := edit1.text;
  Label6.Caption := ''; 
  fp.Enabled := False;
  fn.Enabled := False;
  sp.Enabled := False;
end;
                                                      
procedure TTestForm.Memo1Change(Sender: TObject);   
begin
  ParseText1.text := memo1.Text;
  Label6.Caption := '';
  fp.Enabled := False;
  fn.Enabled := False;
  sp.Enabled := False;
end;

procedure TTestForm.ParseText1AfterFindFirst(actMatch: Integer);
begin
  Label6.Caption := intToStr(actMatch);
end;

procedure TTestForm.ParseText1AfterFindNext(actMatch: Integer);
begin
  Label6.Caption := intToStr(actMatch);
end;

procedure TTestForm.ParseText1AfterFindPrev(actMatch: Integer);
begin
  Label6.Caption := intToStr(actMatch);
end;

procedure TTestForm.CaseSensitiveClick(Sender: TObject);
begin
  ParseText1.casesensitive := CaseSensitive.Checked;
  Label6.Caption := '';
  fp.Enabled := False;
  fn.Enabled := False;
  sp.Enabled := False;
end;

end.
