unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons,
  GlyphControl, PanelButton;

type
  TForm1 = class(TForm)
    PanButDisable: TPanelButton;
    RadioGroup1: TRadioGroup;
    PanButEnable: TPanelButton;
    GlyphControl5: TGlyphControl;
    PanButExit: TPanelButton;
    Label8: TLabel;
    NewStyleLabel1: TLabel;
    NewStyleLabel2: TLabel;
    NewStyleLabel3: TLabel;
    ColorDialog1: TColorDialog;
    PanButColor: TPanelButton;
    GlyphControl2: TGlyphControl;
    NewStyleLabel6: TLabel;
    NewStyleLabel7: TLabel;
    GlyphControl1: TGlyphControl;
    Label11: TLabel;
    procedure PanButColorClick(Sender: TObject);
    procedure PanButDisableClick(Sender: TObject);
    procedure PanButExitClick(Sender: TObject);
    procedure Label1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PanButColorMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RadioGroup1Click(Sender: TObject);
    procedure PanButEnableClick(Sender: TObject);
  private
    { Private declarations }
    procedure SwitchOff(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(*
   This is demo for PanelButton. All Buttons are PanelButtons which have Labels
   and GlyphControls on. PanButColor sets colors for the form and all PanelButtons.
   PanButDisable shows disable effect for PanelButtons and ButConEnable enables
   again. Demo also demonstates techniques for two visual effects:
   HighLighted Labels and Stuck Buttons.

   HighLighted Labels:
     When mouse moves over the label its color becomes HighLighted, all other
     label's colors reset to form's color if neccesary.
     All labels involved have OnMouseMove events linked to  Label1MouseMove procedure.
     This procedure uses SwitchOff procedure to reset all other label's colors if nessesary,
     and sets Sender label color to HighLighted if it has not been set yet.
     OnMouseMove events for PanelButtons Linked to ButConColorMouseMove procedure.
     This procedure uses SwitchOff procedure to resets the colors for all the child
     Labels to Form color if nessesary.In other words label's color is set back to Form color
     if mouse moves outside of label area.

   Stuck Buttons:
     When mouse moves over the PanelButton it 'sticks' to the mouse - has
     more raised drawing effect. PanelButtons's Stuck properties are set to true.
     Form1 is parent for PanelButtons. It has FormMouseMove procedure linked
     to form's OnMouseMove event where PanelButton's method UnStick is called
     to 'unstick' PanelButtons when cursor is moving over the Form1.

*)

procedure TForm1.PanButColorClick(Sender: TObject);
var
  I: integer;
begin
   if ColorDialog1.Execute then
   begin
     color:=ColorDialog1.color;
     for i:= 0 to controlcount-1 do
       if Controls[i] is TPanelButton then
          TPanelButton(Controls[i]).color:=ColorDialog1.color;
     SwitchOff(nil);
  end;
end;

procedure TForm1.PanButDisableClick(Sender: TObject);
begin
  SwitchOff(nil);
  PanButColor.enabled:=false;
  PanButExit.enabled:=false;
  PanButDisable.enabled:=false;
end;

procedure TForm1.PanButExitClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.SwitchOff(Sender: TObject);
var
  I: integer;
begin
   for i:= 0 to ComponentCount-1 do
   begin
     if  Sender<>Components[i] then
      if Components[i] is TLabel then
       if  TLabel(Components[i]).color<>form1.color then
            TLabel(Components[i]).color:=form1.color;
   end;
end;

procedure TForm1.Label1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if RadioGroup1.ItemIndex=1 then
  begin
    if Sender is TLabel then
    begin
      SwitchOff(Sender);
      if TLabel(Sender).color<> GetHighlightColor(Form1.color) then
         TLabel(Sender).color:=GetHighlightColor(Form1.color);
    end;
  end;
end;

procedure TForm1.PanButColorMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if RadioGroup1.ItemIndex=1 then
    SwitchOff(nil);
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  I: integer;
begin
  if RadioGroup1.ItemIndex=2 then
   for i:= 0 to controlcount-1 do
    if Controls[i] is TPanelButton then
       (Controls[i] as TPanelButton).unstick;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
var
  i: integer;
begin
  SwitchOff(Sender);
  for i:= 0 to controlcount-1 do
    if Controls[i] is TPanelButton then
      if RadioGroup1.ItemIndex=2 then
        (Controls[i] as TPanelButton).Stuck:=true
    else
      (Controls[i] as TPanelButton).Stuck:=false;

end;

procedure TForm1.PanButEnableClick(Sender: TObject);
begin
  SwitchOff(nil);
  PanButColor.enabled:=true;
  PanButExit.enabled:=true;
  PanButDisable.enabled:=true;
end;

end.
