unit OXUPath;
{List for handling paths as strings separated by ;}
{Copyright 1997 Eric Maddox}

interface
Uses
  SysUtils, Classes;

Type
  TPathList= Class(TStringList)
  Protected
    Function GetString: String;
    Procedure SetString(NewString: String);
    Function GetAbbreviated: String;
  Public
    Function AddPaths(NewString: String): Integer;
    {Accept/ Return paths with ; between each}
    Property AsString: String Read GetString write SetString;
    {ignore duplicates}
    function Add(const S: string): Integer; override; {Validate and Add}
    Property Abbreviated: String Read GetAbbreviated;
  end;

implementation


Function TPathList.GetString: String;
{Return a string with paths separated by ;}
var
  Ctr: Integer;
begin
  Result := '';
  If Count > 1 then
    For Ctr := 0 to Count -2 do
      Result := Result + Strings[Ctr] + ';';
  If Count > 0 then
    Result := Result + Strings[Count -1];
end;

Procedure TPathList.SetString(NewString: String);
begin
  Clear;
  AddPaths(NewString);
end;

Function TPathList.AddPaths(NewString: String): Integer;
{Add paths in one string separated by ;}
Var
  SemiPos: Integer;
begin
  SemiPos := Pos(';',NewString);
  While SemiPos > 0 do
    begin
      Add(Copy(NewString,1, SemiPos -1));
      System.Delete(NewString, 1, SemiPos);
      SemiPos := Pos(';',NewString);
    end;
  Result := Add(NewString);
end;

function TPathList.Add(const S: string): Integer;
{Validate then Add}
{Return -1 if not added}
Var
  NewS: String;
begin
  Result := -1;
  if (S <> '') then  {No blank Strings}
    If Pos(';', S) > 0 then {No ;}
      Result := AddPaths(S)
    else
      begin
        NewS := S;
        {Trim any \ off the end except root dir}
        if (Length(S) > 1) and
           (S[Length(S)] = '\') and (S[Length(S)-1] <> ':') then
          begin
            SetLength(NewS, Length(NewS) -1);
          end;
        Result := IndexOf(NewS);
        If Result = -1 then {No Duplicates}
          Result := Inherited Add(NewS);
      end;
end;

Function TPathList.GetAbbreviated: String;
{Return paths separated by ;}
{Abbreviate by replacing longest base Path with Abbreviation}
Const
  Abbreviation = ' ...';

Var
  Ctr: integer;
  Curr: Integer;
  TestVer: String;
  LongVer: String; {The Long Version, or the string to be replaced}
  SlashPos: Integer;
  Score: Integer;
  HighScore: Integer;
  Replacing: Boolean;

  Function Abbreviate(S: String): String;
  begin
   Result := Abbreviation + Copy(S, Length(LongVer) + 1, Length(S));
  end;
begin {GetAbbreviated}
  HighScore := -1;
  If Count < 2 then {No abbreviation Possible}
    Result := GetString
  else
    Begin
      {Find the best abbreviation}
      For Curr := Count -1 downto 0 do
        begin
          TestVer := Strings[Curr];
          SlashPos := LastDelimiter('\',TestVer);
          While (SlashPos > 0) do
            begin
              Score := 0;
              SetLength(TestVer, SlashPos -1);
              SlashPos := LastDelimiter('\',TestVer);
              If Length(TestVer) > Length(Abbreviation) then
                begin
                  For Ctr := 0 to Count -1 do
                    If (Pos(TestVer, Strings[Ctr]) = 1) then
                      Inc(Score, Length(TestVer));
                  If Score > HighScore then
                    begin
                      HighScore := Score;
                      LongVer := TestVer;
                    end;
                end;
            end; {While}
        end; {For}

        If HighScore > 2 * Length(Abbreviation) then
          begin {Replace Strings}
            Result := '';
            Replacing := False;
            For Ctr := 0 to Count -2 do
              begin
                If Not Replacing then {Skip the first longver}
                  begin
                    Replacing := (Pos(LongVer, Strings[Ctr]) = 1);
                    Result := Result + Strings[Ctr] + ';';
                  end
                else
                  If (Pos(LongVer, Strings[Ctr]) = 1) then
                    Result := Result + Abbreviate(Strings[Ctr]) + ';'
                  else
                    Result := Result + Strings[Ctr] + ';';
              end; {For}
            {Add the last string}
            Ctr := Count -1;
            If (Pos(LongVer, Strings[Ctr]) = 1) then
              Result := Result + Abbreviate(Strings[Ctr])
            else
              Result := Result + Strings[Ctr];
          end
        else {No abbreviation Possible}
          Result := GetString;
    end;
end; {GetAbbreviated}

end.
