unit OXReg;

interface
Uses
  Classes;

Const
  RegKey = '\Software\OX\OXQopen';
  MaxHistory = 15;
  MaxPaths = 6;

Procedure FillPathItems(Names, Paths: TStrings);
{Reads the checkbox captions, and paths associated with each}

implementation
Uses
  Registry;

Procedure FillPathItems(Names, Paths: TStrings);
{Reads the checkbox captions, and paths associated with each}
  Procedure Defaults;
  begin
    Names.Add('&Library Path');
    Paths.Add('<DelphiRegKey \Library\SearchPath>');
    Names.Add('&VCL Source');
    Paths.Add('<DelphiDir>Source\VCL;' +
        '<DelphiDir>Source\RTL\SYS;' +
        '<DelphiDir>Source\RTL\Win;' +
        '<DelphiDir>Source\Samples;' +
        '<DelphiDir>Source\ToolsAPI');
  end;
var
  Reg: TRegistry;
  Val: Integer;
begin
  Names.Clear;
  Paths.Clear;
  Reg := TRegistry.Create;
  try
    If Reg.OpenKey(RegKey + '\PathItems', False) then
      begin
        Reg.GetValueNames(Names);
        For Val := 0 to Names.Count -1 do
          Paths.Add(Reg.ReadString(Names[Val]));
      end;
  finally
    Reg.Free;
  end;
  If Names.Count = 0 then
    Defaults;
end;

end.
