unit OXMacro;

interface
uses
  ToolIntf;
Const
  Macros: Array[0..2] of string = ('RegistryKey','DelphiRegKey','DelphiDir');
  StartMac='<';
  EndMac='>';

Function ExpandPath(Const Path: String): String;
{Expands the macros}

Procedure InitMacros(NewToolServices: TIToolServices);
{Sets up the toolservices}

implementation
Uses OXReg, Registry, SysUtils;
Var
  ToolServices: TIToolServices;
Procedure InitMacros(NewToolServices: TIToolServices);
begin
  ToolServices := NewToolServices;
end;

Function RegistryKey(Const Key: String): String;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    If Reg.OpenKey(Copy(Key,1, LastDelimiter('\', Key) -1), False) then
      Result := Reg.ReadString(Copy(Key,LastDelimiter('\', Key) + 1, LEngth(Key)))
    else
      Result := '';  
  finally
    Reg.Free;
  end;
end;

Function DelphiRegKey(Const Key: String): String;
Var
  BaseKey: String;
begin
  If ToolServices <> nil then
    BaseKey :=ToolServices.GetBaseRegistryKey
  else
    BaseKey := '\Software\Borland\Delphi\3.0';
  Result := RegistryKey(BaseKey+Key);
end;

Function DelphiDir: String;
begin
  Result := ExtractFilePath(ParamStr(0));
  SetLength(Result, Length(Result) -1);
  Result := ExtractFilePath(Result);
end;


Function ExpandPath(Const Path: String): String;
var
  MacPos: Integer;
  MacSPos: Integer;
  Macro: String;
  Param: String;
begin
  Result := Path;
  Repeat
  MacSPos := Pos(StartMac, Result);
  if MacSPos > 0 then
    begin
      Macro := Copy(Result, MacSPos + 1, Length(Result));
      MacPos := Pos(EndMac, Macro);
      If MacPos > 0 then
        begin
          Delete(Result, MacSPos, MacPos + 1);
          Macro := Copy(Macro, 1, MacPos -1);
        end
      else
        Delete(Result, MacSPos, Length(Result));
      MacPos := Pos(' ', Macro);
      If MacPos > 0 then
        begin
          Param := Copy(Macro, MacPos +1, Length(Macro));
          Macro := Copy(Macro, 1, MacPos -1);
        end;
      Macro := UpperCase(Macro);
      If Macro = UpperCase(Macros[0]) then  {RegistryKey}
        Insert(RegistryKey(Param),Result, MacSPos)
      else if Macro = UpperCase(Macros[1]) then {DelphiRegKey}
        Insert(DelphiRegKey(Param),Result, MacSPos)
      else if Macro = UpperCase(Macros[2]) then {DelphiDir}
        Insert(DelphiDir, Result, MacSPos)
    end;
  until MacSPos < 1;
end;

end.
