unit Info;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls;

type
  TfrmInfo = class(TForm)
    List: TListView;
    Image: TImageList;
    PBottom: TPanel;
    BOk: TButton;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmInfo: TfrmInfo;

procedure InitInfo;
procedure ShowInfo;
procedure Info_AddMessage(S: String);
procedure Info_AddWarning(S: String);
procedure Info_AddError(S: String);

implementation

{$R *.DFM}

var F: TfrmInfo;

procedure InitInfo;
begin
  if F <> nil then Exit;
  F := TfrmInfo.Create(nil);
end;

procedure ShowInfo;
begin
  if (F = nil) then Exit;
  if (F.List.Items.Count > 0) then F.ShowModal;
  F.Free;
  F := nil;
end;

procedure Info_AddDirect(S: String; Idx: Integer);
begin
  if F = nil then Exit;
  with F.List.Items.Add do
  begin
    Caption := S;
    ImageIndex := Idx;
  end;
end;

procedure Info_AddMessage(S: String);
begin
  Info_AddDirect(S, 0);
end;

procedure Info_AddWarning(S: String);
begin
  Info_AddDirect(S, 1);
end;

procedure Info_AddError(S: String);
begin
  Info_AddDirect(S, 2);
end;

end.
