unit ImgManScan;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, FileCtrl, ComCtrls, Buttons;

type
  TfrmScan = class(TForm)
    PBottom: TPanel;
    List: TListView;
    BOk: TBitBtn;
    PScan: TPanel;
    Label1: TLabel;
    Drives: TDriveComboBox;
    BSearch: TButton;
    Images: TImageList;
    LSearch: TLabel;
    BCancel: TBitBtn;
    procedure BSearchClick(Sender: TObject);
    procedure ListDblClick(Sender: TObject);
  private
    { Private declarations }
    procedure AddFolder(Folder: String);
    function HaveBitmaps(Folder: String): Boolean;
    procedure RecursiveScan(Folder: String);
  public
    { Public declarations }
    FExt: String;
  end;

var
  frmScan: TfrmScan;

function ScanForDirs: TStringList;
function ScanForIconDirs: TStringList;

implementation

Uses ShellApi;

{$R *.DFM}

function ScanForDirsExt(pExt, pCaption: String): TStringList;
var F: TfrmScan;
    I: Integer;
begin
  F := TfrmScan.Create(nil);
  Result := nil;
  try
    F.FExt := pExt;
    F.Caption := pCaption;
    if F.ShowModal = mrOk then
    begin
      Result := TStringList.Create;
      for I := 0 to F.List.Items.Count - 1 do
        if F.List.Items[I].Checked then Result.Add(F.List.Items[I].Caption);
    end;
  finally
    F.Free;
  end;
end;

function ScanForDirs: TStringList;
begin
  Result := ScanForDirsExt('bmp', 'Image Scaner');
end;

function ScanForIconDirs: TStringList;
begin
  Result := ScanForDirsExt('ico', 'Icon Scaner');
end;

procedure TfrmScan.AddFolder(Folder: String);
begin
  with List.Items.Add do
    Caption := AnsiLowerCase(Folder);
  List.Refresh;
end;

function TfrmScan.HaveBitmaps(Folder: String): Boolean;
var SR: TSearchRec;
begin
  Result := (FindFirst(Folder + '*.' + FExt, faAnyFile, SR) = 0);
  FindClose(SR);
end;

procedure TfrmScan.RecursiveScan(Folder: String);
var SR: TSearchRec;
    Found: Integer;
begin
  LSearch.Caption := AnsiLowerCase(Folder);
  LSearch.Refresh;
  if HaveBitmaps(Folder) then AddFolder(Folder);
  Found := FindFirst(Folder + '*.*', faDirectory, SR);
  while Found = 0 do
  begin
    if (SR.Name <> '.') and (SR.Name <> '..') and (SR.Attr and faDirectory <> 0) then
      RecursiveScan(Folder + SR.Name + '\');
    Found := FindNext(SR);
  end;
  FindClose(SR);
end;

procedure TfrmScan.BSearchClick(Sender: TObject);
var I: Integer;
begin
  PBottom.Enabled := False;
  List.Enabled := False;
  for I := List.Items.Count - 1 downto 0 do
    if not List.Items[I].Checked then List.Items.Delete(I);
  List.Refresh;
  LSearch.Caption := '';
  RecursiveScan(Drives.Drive + ':\');
  LSearch.Caption := '';
  List.Enabled := True;
  PBottom.Enabled := True;
  if List.Items.Count > 0 then
    List.Selected := List.Items[List.Items.Count - 1];
end;

procedure TfrmScan.ListDblClick(Sender: TObject);
begin
  if List.Selected <> nil then
    ShellExecute(Handle, nil, PChar(List.Selected.Caption), nil, nil, SW_SHOW);
end;

end.
