unit ImgManLoadFromIcon;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, RXCombos;

type
  TfrmFromIcon = class(TForm)
    PButtons: TPanel;
    Bevel1: TBevel;
    BOk: TBitBtn;
    BCancel: TBitBtn;
    PImage: TPanel;
    Image: TImage;
    Label1: TLabel;
    BackCol: TColorComboBox;
    PPreview: TPanel;
    PrevImage: TImage;
    BBrowse: TButton;
    GSize: TRadioGroup;
    procedure BBrowseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BackColChange(Sender: TObject);
    procedure GSizeClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdatePreview;
  public
    { Public declarations }
  end;

var
  frmFromIcon: TfrmFromIcon;

implementation

Uses IconManager;

{$R *.DFM}

procedure TfrmFromIcon.FormShow(Sender: TObject);
begin
  BBrowseClick(Self);
end;

procedure TfrmFromIcon.BBrowseClick(Sender: TObject);
var
  IconMan: TfrmIconManager;
  aIcon: TIcon;
begin
  IconMan := nil;
  try
    IconMan := TfrmIconManager.Create(nil);
    IconMan.SubCaption := 'Image Manager Automation';
    aIcon := TIcon.Create;
    IconMan.Picture := aIcon;
    if IconMan.ShowModal = mrOk then
    begin
      Image.Picture.Icon.Assign(IconMan.Picture);
      UpdatePreview;
    end;
    aIcon.Free;
  finally
    if IconMan <> nil then IconMan.Free;
  end;
end;

procedure TfrmFromIcon.UpdatePreview;
var Bmp, Bmp2: TBitmap;
begin
  Bmp := TBitmap.Create;
  Bmp.Width := 32;
  Bmp.Height := 32;
  Bmp.PixelFormat := pf4bit;
  with Bmp.Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := BackCol.ColorValue;
    FillRect(Rect(0, 0, 32, 32));
    DrawIcon(Handle, 0, 0, Image.Picture.Icon.Handle);
  end;
  if GSize.ItemIndex = 1 then
  begin
    Bmp2 := TBitmap.Create;
    Bmp2.Assign(Bmp);
    Bmp2.Width := 16;
    Bmp2.Height := 16;
    Bmp2.Canvas.StretchDraw(Rect(0, 0, 16, 16), Bmp);
    Bmp.Assign(Bmp2);
    Bmp2.Free;
  end;
  PrevImage.Picture.Bitmap.Assign(Bmp);
  Bmp.Free;
end; 

procedure TfrmFromIcon.BackColChange(Sender: TObject);
begin
  PPreview.Color := BackCol.ColorValue;
  UpdatePreview;
end;

procedure TfrmFromIcon.GSizeClick(Sender: TObject);
begin
  UpdatePreview;
end;

end.

