{
  TfrmIconManager
  (c) Ilya Vdovin, 1999
}

unit IconManager;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, Buttons, Spin, RXSplit, Menus, RXCtrls,
  ExtDlgs, OTMisc;

type
  TCompareMode = (cmName, cmSize, cmDate);

  TfrmIconManager = class(TForm)
    VertSplitter: TRxSplitter;
    PRight: TPanel;
    PUp: TPanel;
    Images: TImageList;
    FImages: TImageList;
    FImagesBig: TImageList;
    PListBtn: TPanel;
    BIcons: TRxSpeedButton;
    BSmallIcons: TRxSpeedButton;
    BList: TRxSpeedButton;
    BReport: TRxSpeedButton;
    BDelImg: TRxSpeedButton;
    BCopyMode: TRxSpeedButton;
    BMoveMode: TRxSpeedButton;
    BOptions: TRxSpeedButton;
    mOptions: TPopupMenu;
    N2: TMenuItem;
    mAutoSave: TMenuItem;
    mActions: TPopupMenu;
    mAbout: TMenuItem;
    mShowStatus: TMenuItem;
    PBottom: TPanel;
    PButtons: TPanel;
    BOk: TBitBtn;
    BCancel: TBitBtn;
    PProgress: TPanel;
    ProgressBar: TProgressBar;
    PLeft: TPanel;
    PTree: TPanel;
    Tree: TTreeView;
    PTreeBtns: TPanel;
    BAdd: TRxSpeedButton;
    BDel: TRxSpeedButton;
    BBrowse: TRxSpeedButton;
    BSave: TRxSpeedButton;
    BClear: TRxSpeedButton;
    BAction: TRxSpeedButton;
    PDown: TPanel;
    PImage: TPanel;
    Image: TImage;
    HorizSplitter: TRxSplitter;
    PClipbrd: TPanel;
    StatusBar: TStatusBar;
    BSaveImg: TRxSpeedButton;
    SaveDlg: TSavePictureDialog;
    mRestorePath: TMenuItem;
    BOpenBar: TRxSpeedButton;
    BvToolBarSep: TBevel;
    BCopyAgain: TRxSpeedButton;
    PFileList: TPanel;
    FileList: TListView;
    mHotTrack: TMenuItem;
    N4: TMenuItem;
    mGridLines: TMenuItem;
    mShowRoots: TMenuItem;
    mShowLines: TMenuItem;
    LProgressInfo: TLabel;
    OpenDlg: TOpenDialog;
    mSaveLast: TMenuItem;
    IconScaner1: TMenuItem;
    mScan: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TreeEdited(Sender: TObject; Node: TTreeNode; var S: String);
    procedure TreeEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure TreeKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure TreeChange(Sender: TObject; Node: TTreeNode);
    procedure BAddClick(Sender: TObject);
    procedure BDelClick(Sender: TObject);
    procedure BSaveClick(Sender: TObject);
    procedure BIconsClick(Sender: TObject);
    procedure FileListChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure FileListDblClick(Sender: TObject);
    procedure TreeDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FileListCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure FileListColumnClick(Sender: TObject; Column: TListColumn);
    procedure FileListEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure FileListEdited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure BBrowseClick(Sender: TObject);
    procedure FileListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BClearClick(Sender: TObject);
    procedure TreeDeletion(Sender: TObject; Node: TTreeNode);
    procedure TreeDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure BDelImgClick(Sender: TObject);
    procedure mAutoSaveClick(Sender: TObject);
    procedure PUpResize(Sender: TObject);
    procedure mAboutClick(Sender: TObject);
    procedure mShowStatusClick(Sender: TObject);
    procedure TreeDblClick(Sender: TObject);
    procedure TreeExit(Sender: TObject);
    procedure FileListExit(Sender: TObject);
    procedure BSaveImgClick(Sender: TObject);
    procedure mRestorePathClick(Sender: TObject);
    procedure BOpenBarClick(Sender: TObject);
    procedure BCopyAgainClick(Sender: TObject);
    procedure mHotTrackClick(Sender: TObject);
    procedure mGridLinesClick(Sender: TObject);
    procedure mShowRootsClick(Sender: TObject);
    procedure mShowLinesClick(Sender: TObject);
    procedure mSaveLastClick(Sender: TObject);
    procedure IconScaner1Click(Sender: TObject);
  private
    FDirRoot, FCatRoot, FLstRoot, FFilRoot, FSysRoot: TTreeNode;
    FChanges: Boolean;
    FComp: TCompareMode;
    FAscSort: Boolean;
    FStarting: Boolean;
    FReading: Boolean;
    FSelectedImageName: String;
    FStartDir: String;
    FLastTarget: TTreeNode;
    HSystem: THandle;
    FLastDir: String;
    FWasAutoAdd: Boolean;
    procedure SaveToRegistry(SaveTreeData: Boolean);
    procedure LoadFromRegistry;
    procedure SetIndexs(Node: TTreeNode; Idx: Integer);
    procedure HasChange;
    procedure AddFileToList(FileName: String);
    procedure SelectNewByName(FileName: String);
    function BrowseDir(S: String): String;
    function BrowseFile(S: String): String;
    procedure FillListForDir(S: String);
    procedure FillListForFile(S: String);
    procedure FillFromNodeList(Node: TTreeNode);
    procedure CommonFillEnd;
    function AddNameToNode(Node: TTreeNode; FileName: String): Boolean;
    function DeleteNameFromNode(Node: TTreeNode; FileName: String): Boolean;
    function AddDirNode(Folder: String): TTreeNode;
    function AddFileNode(FileName: String): TTreeNode;
    procedure UpdateImageMeasure;
    procedure AdjustToolBarHeight;
    procedure SetLastTarget(Node: TTreeNode);
    procedure CopyOrMoveToNode(TargetNode: TTreeNode);
    procedure SeparateNum(InName: String; var FileName: String; var IconNum: Integer);
    procedure FixLinks(OldPath, NewPath: String);
    function PackNum(pName: String; pIdx: Integer): String;
    procedure FillBySystemList(pIndex: Integer);
    procedure StartVisual(pText: String; pMax: Integer);
    procedure NextVisual(pValue: Integer);
    procedure DoneVisual;
  public
    Picture: TIcon;
    SubCaption: String;
  end;

var
  frmIconManager: TfrmIconManager;

implementation

uses ShellApi, Registry, CommCtrl, FileUtil, StrUtils, OTAbout, Info,
     Clipbrd, VclUtils, ImgManScan;

{$R *.DFM}

const CRegKey = '\Software\Viv\Delphi\OpenTools\IconManager\';
      CPathKey = '\Software\Borland\Delphi\3.0';

      IDX_DIR_ROOT = 0;
      IDX_CAT_ROOT = 1;
      IDX_LST_ROOT = 2;
      IDX_FIL_ROOT = 3;
      IDX_SYS_ROOT = 4;
      IDX_DIR_ITEM = 5;
      IDX_CAT_ITEM = 6;
      IDX_FIL_ITEM = 7;
      IDX_SYS_ITEM = 8;

      IDX_SEL_INC  = 4;

      IDX_DIR_OPEN = IDX_DIR_ITEM + IDX_SEL_INC;
      IDX_CAT_OPEN = IDX_CAT_ITEM + IDX_SEL_INC;
      IDX_FIL_OPEN = IDX_FIL_ITEM + IDX_SEL_INC;
      IDX_SYS_OPEN = IDX_SYS_ITEM + IDX_SEL_INC;


procedure Error(S: String);
begin
  Application.MessageBox(PChar(S), 'Error', MB_OK or MB_ICONERROR);
end;

procedure Warning(S: String);
begin
  Application.MessageBox(PChar(S), 'Warning', MB_OK or MB_ICONWARNING);
end;

function Confirm(S: String): Boolean;
begin
  Result := MessageDlg(S, mtConfirmation, [mbYes, mbNo], 0) = mrYes;
end;

procedure TfrmIconManager.FormCreate(Sender: TObject);

  function AddRoot(S: String; I: Integer): TTreeNode;
  begin
    Result := Tree.Items.AddChild(nil, S);
    SetIndexs(Result, I);
  end;

var Inf: TSHFileInfo;
    I, Cnt, N: Integer;
    S: String;
begin
  HSystem := SHGetFileInfo(PChar(ParamStr(0)), 0, Inf, SizeOf(Inf), SHGFI_ICON or SHGFI_SYSICONINDEX);
  if HSystem = 0 then ;
  GetDir(0, FStartDir);
  FDirRoot := AddRoot('Directories', IDX_DIR_ROOT);
  FCatRoot := AddRoot('Categories', IDX_CAT_ROOT);
  FLstRoot := AddRoot('Last used', IDX_LST_ROOT);
  FFilRoot := AddRoot('Files', IDX_FIL_ROOT);
  FSysRoot := AddRoot('System', IDX_SYS_ROOT);
  Cnt := ImageList_GetImageCount(HSystem);
  N := Cnt div 100;
  if Cnt mod 100 <> 0 then Inc(N);
  for I := 0 to N - 1 do
  begin
    S := Format('%.3d - ', [I * 100]);
    if I = N - 1 then S := S + Format('%.3d', [Cnt - 1]) else
                      S:= S + Format('%.3d', [(I + 1) * 100 - 1]);
    SetIndexs(Tree.Items.AddChild(FSysRoot, S), IDX_SYS_ITEM);
  end;
  FChanges := False;
  FStarting := True;
  FComp := cmName;
  FAscSort := True;
  FWasAutoAdd := False;
  LoadFromRegistry;
  FStarting := False;
  if FWasAutoAdd then HasChange;
  FReading := False;
  Tree.Selected := FLstRoot;
  FSelectedImageName := '';
  FLastTarget := nil;
end;

procedure TfrmIconManager.UpdateImageMeasure;
begin
  if (Image.Picture.Icon = nil) or (Image.Picture.Icon.Empty) then
    StatusBar.Panels[1].Text := '' else
    StatusBar.Panels[1].Text := IntToStr(Image.Picture.Icon.Width) + 'x' +
                                IntToStr(Image.Picture.Icon.Height);
end;

procedure TfrmIconManager.FormShow(Sender: TObject);
begin
  Image.Picture.Icon := Picture;
  StatusBar.Panels[2].Text := SubCaption;
  if SubCaption <> '' then Caption := Caption + ' - ' + SubCaption; 
end;

procedure TfrmIconManager.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  SaveToRegistry((ModalResult = mrOk) or
                 (FChanges and (mAutoSave.Checked or
                                Confirm('Save changes?'))));
  if mRestorePath.Checked then ChDir(FStartDir);
end;

procedure TfrmIconManager.SaveToRegistry(SaveTreeData: Boolean);
var Reg: TRegistry;
    I: Integer;
    SL: TStringList;

  procedure ClearValues;
  var I: Integer;
  begin
    SL := TStringList.Create;
    Reg.GetValueNames(SL);
    for I := 0 to SL.Count - 1 do Reg.DeleteValue(SL[I]);
    SL.Free;
  end;

  procedure SaveNodeList(Node: TTreeNode);
  var I: Integer;
      SL: TStringList;
  begin
    if Node.Data = nil then Exit;
    SL := TStringList(Node.Data);
    Reg.WriteInteger('Count', SL.Count);
    for I := 0 to SL.Count - 1 do
      Reg.WriteString(IntToStr(I), SL[I]);
  end;

begin
  Reg := TRegistry.Create;
  try
    if Reg.OpenKey(CRegKey + 'Directories', True) then
    begin
      if SaveTreeData then
      begin
        ClearValues;
        Reg.WriteString('', FDirRoot.Text);
        Reg.WriteBool('Expanded', FDirRoot.Expanded);
        Reg.WriteInteger('Count', FDirRoot.Count);
        for I := 0 to FDirRoot.Count - 1 do
          Reg.WriteString(IntToStr(I), FDirRoot.Item[I].Text);
      end else
        Reg.WriteBool('Expanded', FDirRoot.Expanded);
      Reg.CloseKey;
    end;
    if Reg.OpenKey(CRegKey + 'Categories', True) then
    begin
      if SaveTreeData then
      begin
        Reg.WriteString('', FCatRoot.Text);
        Reg.WriteBool('Expanded', FCatRoot.Expanded);
        SL := TStringList.Create;
        Reg.GetKeyNames(SL);
        for I := 0 to SL.Count - 1 do Reg.DeleteKey(SL[I]);
        SL.Free;
        Reg.CloseKey;
        for I := 0 to FCatRoot.Count - 1 do
          if Reg.OpenKey(CRegKey + 'Categories\' + FCatRoot.Item[I].Text, True) then
          begin
            SaveNodeList(FCatRoot.Item[I]);
            Reg.CloseKey;
          end;
      end else begin
        Reg.WriteBool('Expanded', FCatRoot.Expanded);
        Reg.CloseKey;
      end;
    end;
    if Reg.OpenKey(CRegKey + 'LastUsed', True) then
    begin
      if SaveTreeData then
      begin
        ClearValues;
        Reg.WriteString('', FLstRoot.Text);
        SaveNodeList(FLstRoot);
        Reg.CloseKey;
      end;
    end;
    if Reg.OpenKey(CRegKey + 'Files', True) then
    begin
      if SaveTreeData then
      begin
        Reg.WriteString('', FFilRoot.Text);
        Reg.WriteBool('Expanded', FFilRoot.Expanded);
        Reg.WriteInteger('Count', FFilRoot.Count);
        for I := 0 to FFilRoot.Count - 1 do
          Reg.WriteString(IntToStr(I), FFilRoot.Item[I].Text);
      end else
        Reg.WriteBool('Expanded', FFilRoot.Expanded);
      Reg.CloseKey;
    end;
    if Reg.OpenKey(CRegKey + 'System', True) then
    begin
      if SaveTreeData then
      begin
        ClearValues;
        Reg.WriteString('', FSysRoot.Text);
      end;
      Reg.WriteBool('Expanded', FSysRoot.Expanded);
      Reg.CloseKey;
    end;
    if Reg.OpenKey(CRegKey + 'Options', True) then
    begin
      Reg.WriteBool('AutoSave', mAutoSave.Checked);
      Reg.WriteInteger('ViewStyle', Integer(FileList.ViewStyle));
      Reg.WriteInteger('PLeft.Width', PLeft.Width);
      Reg.WriteInteger('PDown.Height', PDown.Height);
      Reg.WriteBool('CopyMode', BCopyMode.Down);
      Reg.WriteBool('ShowStatus', mShowStatus.Checked);
      Reg.WriteString('InitialDir', FLastDir);
      Reg.WriteBool('RestorePath', mRestorePath.Checked);
      Reg.WriteBool('OpenBar', BOpenBar.Down);
      for I := 0 to FileList.Columns.Count - 1 do
        Reg.WriteInteger(Format('Columns[%d].Width', [I]), FileList.Columns[I].Width);
      Reg.WriteInteger('CompareMode', Integer(FComp));
      Reg.WriteBool('AscSort', FAscSort);
      Reg.WriteBool('HotTrack', mHotTrack.Checked);
      Reg.WriteBool('GridLines', mGridLines.Checked);
      Reg.WriteBool('ShowRoots', mShowRoots.Checked);
      Reg.WriteBool('ShowLines', mShowLines.Checked);
      Reg.WriteBool('SaveLast', mSaveLast.Checked);
      Reg.CloseKey;
    end;
  finally
    Reg.Free;
  end;
end;

procedure TfrmIconManager.LoadFromRegistry;
var Reg: TRegistry;
    S: String;
    SL: TStringList;
    I, Num: Integer;
    Node: TTreeNode;
    Exp: Boolean;
    P: PChar;

  function ReadBool(Name: String; Def: Boolean): Boolean;
  begin
    try
      Result := Reg.ReadBool(Name);
    except
      Result := Def;
    end;
  end;

  function ReadStr(Name, Def: String): String;
  begin
    try
      Result := Reg.ReadString(Name);
    except
      Result := Def;
    end;
  end;

  function ReadInt(Name: String; Def: Integer): Integer;
  begin
    try
      Result := Reg.ReadInteger(Name);
    except
      Result := Def;
    end;
  end;

  procedure LoadNodeList(Node: TTreeNode);
  var I, Num: Integer;
      SL: TStringList;
      S: String;
  begin
    SL := TStringList.Create;
    Num := ReadInt('Count', 0);
    for I := 0 to Num - 1 do
    begin
      S := ReadStr(IntToStr(I), '');
      if S <> '' then SL.Add(S);
    end;
    Node.Data := SL;
  end;

begin
  Reg := TRegistry.Create;
  try
    if Reg.OpenKey(CRegKey + 'Directories', True) then
    begin
      S := ReadStr('', 'Directories');
      if S <> '' then FDirRoot.Text := S;
      Exp := ReadBool('Expanded', False);
      Num := ReadInt('Count', 0);
      for I := 0 to Num - 1 do
      begin
        S := ReadStr(IntToStr(I), '');
        if S = '' then Continue;
        Node := Tree.Items.AddChild(FDirRoot, AnsiLowerCase(S));
        SetIndexs(Node, IDX_DIR_ITEM);
      end;
      Reg.CloseKey;
      if FDirRoot.Count = 0 then
      begin
        Reg.RootKey := HKEY_LOCAL_MACHINE;
        if Reg.OpenKey(CPathKey, False) then
        begin
          S := ReadStr('RootDir', '');
          S := NormalizePath(S + '\Images\Icons');
          if AddDirNode(S) <> nil then Exp := True;
          Reg.CloseKey;
          FWasAutoAdd := True;
        end;
        Reg.RootKey := HKEY_CURRENT_USER;
      end;
      if Exp then FDirRoot.Expand(False);
    end;
    if Reg.OpenKey(CRegKey + 'Categories', True) then
    begin
      S := ReadStr('', 'Categories');
      if S <> '' then FCatRoot.Text := S;
      Exp := ReadBool('Expanded', False);
      SL := TStringList.Create;
      Reg.GetKeyNames(SL);
      Reg.CloseKey;
      for I := 0 to SL.Count - 1 do
        if Reg.OpenKey(CRegKey + 'Categories\' + SL[I], False) then
        begin
          Node := Tree.Items.AddChild(FCatRoot, SL[I]);
          SetIndexs(Node, IDX_CAT_ITEM);
          LoadNodeList(Node);
          Reg.CloseKey;
        end;
      SL.Free;
      if Exp then FCatRoot.Expand(False);
    end;
    if Reg.OpenKey(CRegKey + 'LastUsed', True) then
    begin
      S := ReadStr('', 'Last used');
      if S <> '' then FLstRoot.Text := S;
      LoadNodeList(FLstRoot);
      Reg.CloseKey;
    end;
    if Reg.OpenKey(CRegKey + 'Files', True) then
    begin
      S := ReadStr('', 'Files');
      if S <> '' then FFilRoot.Text := S;
      Exp := ReadBool('Expanded', False);
      Num := ReadInt('Count', 0);
      for I := 0 to Num - 1 do
      begin
        S := ReadStr(IntToStr(I), '');
        if S = '' then Continue;
        Node := Tree.Items.AddChild(FFilRoot, AnsiLowerCase(S));
        SetIndexs(Node, IDX_FIL_ITEM);
      end;
      Reg.CloseKey;
      if FFilRoot.Count = 0 then
      begin
        GetMem(P, 300);
        GetWindowsDirectory(P, 300);
        S := NormalizePath(StrPas(P));
        FreeMem(P, 300);
        AddFileNode(S + 'moricons.dll');
        AddFileNode(S + 'progman.exe');
        AddFileNode(S + '\SYSTEM\inetcpl.cpl');
        AddFileNode(S + '\SYSTEM\mailnews.dll');
        AddFileNode(S + '\SYSTEM\main.cpl');
        AddFileNode(S + '\SYSTEM\mshtml.dll');
        AddFileNode(S + '\SYSTEM\setupapi.dll');
        AddFileNode(S + '\SYSTEM\shdocvw.dll');
        AddFileNode(S + '\SYSTEM\shell32.dll');
        AddFileNode(S + '\SYSTEM\sysdm.cpl');
        AddFileNode(S + '\SYSTEM\user.exe');
        FWasAutoAdd := True;
      end;
      if Exp then FFilRoot.Expand(False);
    end;
    if Reg.OpenKey(CRegKey + 'System', True) then
    begin
      S := ReadStr('', 'System');
      if S <> '' then FSysRoot.Text := S;
      Exp := ReadBool('Expanded', False);
      Reg.CloseKey;
      if Exp then FSysRoot.Expand(False);
    end;
    if Reg.OpenKey(CRegKey + 'Options', True) then
    begin
      mAutoSave.Checked := ReadBool('AutoSave', True);
      FileList.ViewStyle := TViewStyle(ReadInt('ViewStyle', 0));
      case FileList.ViewStyle of
        vsIcon: BIcons.Down := True;
        vsSmallIcon: BSmallIcons.Down := True;
        vsList: BList.Down := True;
        vsReport: BReport.Down := True;
      end;
      PLeft.Width := ReadInt('PLeft.Width', 260);
      PDown.Height := ReadInt('PDown.Height', 86);
      if ReadBool('CopyMode', True) then
        BCopyMode.Down := True else BMoveMode.Down := True;
      mShowStatus.Checked := ReadBool('ShowStatus', True);
      FLastDir := ReadStr('InitialDir', '');
      StatusBar.Visible := mShowStatus.Checked;
      mRestorePath.Checked := ReadBool('RestorePath', True);
      BOpenBar.Down := ReadBool('OpenBar', False);
      AdjustToolBarHeight;
      FileList.Columns[0].Width := ReadInt('Columns[0].Width', 150);
      FileList.Columns[1].Width := ReadInt('Columns[1].Width', 80);
      FileList.Columns[2].Width := ReadInt('Columns[2].Width', 100);
      FComp := TCompareMode(ReadInt('CompareMode', 0));
      FAscSort := ReadBool('AscSort', True);
      mHotTrack.Checked := ReadBool('HotTrack', False);
      FileList.HotTrack := mHotTrack.Checked;
      mGridLines.Checked := ReadBool('GridLines', False);
      FileList.GridLines := mGridLines.Checked;
      mShowRoots.Checked := ReadBool('ShowRoots', True);
      Tree.ShowRoot := mShowRoots.Checked;
      mShowLines.Checked := ReadBool('ShowLines', True);
      Tree.ShowLines := mShowLines.Checked;
      mSaveLast.Checked := ReadBool('SaveLast', True);
      Reg.CloseKey;
    end;
  finally
    Reg.Free;
  end;
end;

procedure TfrmIconManager.SetIndexs(Node: TTreeNode; Idx: Integer);
begin
  Node.ImageIndex := Idx;
  if Idx in [IDX_DIR_ITEM..IDX_SYS_ITEM] then Inc(Idx, IDX_SEL_INC);
  Node.SelectedIndex := Idx;
end;

procedure TfrmIconManager.SeparateNum(InName: String; var FileName: String; var IconNum: Integer);
var S: String;
    P: Integer;
begin
  P := Pos('<', InName);
  if P = 0 then
  begin
    FileName := InName;
    IconNum := -1;
  end else
  begin
    FileName := Copy(InName, 1, P - 1);
    S := Copy(InName, P + 1, Length(InName) - P - 1);
    try
      IconNum := StrToInt(S);
    except
      IconNum := 0;
    end;
  end;
end;

function TfrmIconManager.PackNum(pName: String; pIdx: Integer): String;
begin
  Result := Format('%s<%.4d>', [NormalizePath(pName), pIdx]);
end;

procedure TfrmIconManager.AddFileToList(FileName: String);
var RealName: String;
    IconNum: Integer;
    aIcon: TIcon;
begin
  SeparateNum(FileName, RealName, IconNum);
  RealName := AnsiLowerCase(RealName);
  if (RealName <> 'system') and (not FileExists(RealName)) then Exit;
  with FileList.Items.Add do
  begin
    if RealName = 'system' then
      Caption := Format('%.4d', [IconNum]) else
    begin
      Caption := ExtractFileName(RealName);
      if IconNum <> -1 then Caption := PackNum(Caption, IconNum);
    end;
    if IconNum = -1 then
    begin
      SubItems.Add(IntToStr(GetFileSize(RealName)));
      SubItems.Add(DateTimeToStr(FileDateTime(RealName)));
    end else
    begin
      SubItems.Add('');
      SubItems.Add('');
    end;
    SubItems.Add(AnsiLowerCase(FileName));
    aIcon := TIcon.Create;
    if IconNum = -1 then aIcon.LoadFromFile(RealName) else
    begin
      if RealName = 'system' then
       aIcon.Handle := ImageList_GetIcon(HSystem, IconNum, ILD_NORMAL) else
       aIcon.Handle := ExtractIcon(hInstance, PChar(RealName), IconNum);
    end;
    ImageIndex := FImages.AddIcon(aIcon);
    FImagesBig.AddIcon(aIcon);
    aIcon.Free;   
  end;
end;

procedure TfrmIconManager.TreeEdited(Sender: TObject; Node: TTreeNode;
  var S: String);
begin
  if S = '' then S := Node.Text else
  if (Node.Parent = FDirRoot) and (not DirExists(S)) then
  begin
    Error('Invalid directory name');
    S := Node.Text
  end else
  begin
    HasChange;
    Node.Text := S;
    Node.EndEdit(False);
    if Node <> FSysRoot then Tree.OnChange(Self, Node);
  end;
  BCancel.Cancel := True;
end;

procedure TfrmIconManager.TreeEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  AllowEdit := (Node.Parent <> FSysRoot);
  BCancel.Cancel := not AllowEdit;
end;

procedure TfrmIconManager.TreeKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Shift <> []) or (Tree.Selected = nil) then Exit;
  case Key of
    VK_F2: Tree.Selected.EditText;
    VK_INSERT: if BAdd.Enabled then BAdd.OnClick(Self) else Exit;
    VK_DELETE: if (not Tree.IsEditing) and BDel.Enabled then BDel.OnClick(Self) else Exit;
    VK_F3: if BBrowse.Enabled then BBrowse.OnClick(Self) else Exit;
    VK_ESCAPE: if (not Tree.IsEditing) and (not BCancel.Cancel) then
               begin
                 BCancel.Cancel := True;
                 BCancel.Click;
                 Exit;
               end;
    else Exit;
  end;
  Key := 0;
end;

procedure TfrmIconManager.TreeChange(Sender: TObject; Node: TTreeNode);
begin
  FileList.Visible := False;
  FReading := True;
  FileList.Items.Clear;
  Image.Picture.Bitmap := nil;
  SelectNewByName('');
  FImages.Clear;
  FImagesBig.Clear;
  FileList.ReadOnly := True; 
  if (Tree.Selected = nil) or (Tree.Selected = FLstRoot) then
  begin
    BAdd.Enabled := False;
    BDel.Enabled := False;
    BBrowse.Enabled := False;
    BDelImg.Enabled := (Tree.Selected = FLstRoot);
    if Tree.Selected = FLstRoot then FillFromNodeList(FLstRoot);
  end else
  if (Tree.Selected = FDirRoot) or (Tree.Selected.Parent = FDirRoot) then
  begin
    BAdd.Enabled := True;
    BDel.Enabled := (Tree.Selected <> FDirRoot);
    BBrowse.Enabled := (Tree.Selected <> FDirRoot);
    BDelImg.Enabled := (Tree.Selected <> FDirRoot);
    FileList.ReadOnly := False;
    if (Tree.Selected <> FDirRoot) then
       FillListForDir(Tree.Selected.Text);
  end else
  if (Tree.Selected = FCatRoot) or (Tree.Selected.Parent = FCatRoot) then
  begin
    BAdd.Enabled := True;
    BDel.Enabled := (Tree.Selected <> FCatRoot);
    BBrowse.Enabled := False;
    BDelImg.Enabled := (Tree.Selected <> FCatRoot);
    if (Tree.Selected <> FCatRoot) then
      FillFromNodeList(Tree.Selected);
  end else
  if (Tree.Selected.Parent = FSysRoot) or (Tree.Selected = FSysRoot) then
  begin
    BAdd.Enabled := False;
    BDel.Enabled := False;
    BBrowse.Enabled := False;
    BDelImg.Enabled := False;
    if (Tree.Selected <> FSysRoot) then
      FillBySystemList(Tree.Selected.Index);
  end else
  if (Tree.Selected = FFilRoot) or (Tree.Selected.Parent = FFilRoot) then
  begin
    BAdd.Enabled := True;
    BDel.Enabled := (Tree.Selected <> FFilRoot);
    BBrowse.Enabled := False;
    BDelImg.Enabled := False;
    if (Tree.Selected <> FFilRoot) then
      FillListForFile(Tree.Selected.Text);
  end;
  FReading := False;
  BCopyAgain.Enabled := (FLastTarget <> nil) and (FLastTarget <> Tree.Selected);
end;

function TfrmIconManager.BrowseDir(S: String): String;
var S2: String;
begin
  Result := '';
  if S = '' then S2 := 'Select new directory...' else
                 S2 := 'Current: ' + AnsiLowerCase(S) + #13 + 'Select other directory...';
  if BrowseDirectory(S, S2, 0) then
    Result := S;
end;

function TfrmIconManager.BrowseFile(S: String): String;
begin
  Result := '';
  OpenDlg.InitialDir := FLastDir;
  if OpenDlg.Execute then
  begin
    Result := OpenDlg.FileName;
    FLastDir := ExtractFilePath(Result);
  end;
end;

function TfrmIconManager.AddFileNode(FileName: String): TTreeNode;
var I: Integer;
begin
  FileName := NormalizePath(FileName);
  Result := nil;
  if not FileExists(FileName) then Exit;
  for I := 0 to FFilRoot.Count - 1 do
    if NormalizePath(FFilRoot.Item[I].Text) = FileName then Exit;
  Result := Tree.Items.AddChild(FFilRoot, AnsiLowerCase(FileName));
  SetIndexs(Result, IDX_FIL_ITEM);
end;

function TfrmIconManager.AddDirNode(Folder: String): TTreeNode;
var I: Integer;
begin
  Folder := NormalizePath(Folder);
  Result := nil;
  if not DirExists(Folder) then Exit;
  for I := 0 to FDirRoot.Count - 1 do
    if NormalizePath(FDirRoot.Item[I].Text) = Folder then Exit;
  Result := Tree.Items.AddChild(FDirRoot, AnsiLowerCase(Folder));
  SetIndexs(Result, IDX_DIR_ITEM);
end;

procedure TfrmIconManager.BAddClick(Sender: TObject);
var Node: TTreeNode;
    S: String;
begin
  if Tree.Selected = nil then Exit else
  if (Tree.Selected = FDirRoot) or (Tree.Selected.Parent = FDirRoot) then
  begin
    S := BrowseDir('');
    if S <> '' then
    begin
      Node := AddDirNode(S);
      if Node <> nil then Tree.Selected := Node;
      HasChange;
    end;
  end else
  if (Tree.Selected = FCatRoot) or (Tree.Selected.Parent = FCatRoot) then
  begin
    Node := Tree.Items.AddChild(FCatRoot, 'New Category');
    SetIndexs(Node, IDX_CAT_ITEM);
    Node.Data := TStringList.Create;
    Tree.Selected := Node;
    Node.EditText;
    HasChange;
  end else
  if (Tree.Selected = FFilRoot) or (Tree.Selected.Parent = FFilRoot) then
  begin
    S := BrowseFile('');
    if S <> '' then
    begin
      Node := AddFileNode(S);
      if Node <> nil then Tree.Selected := Node;
      HasChange;
    end;
  end
end;

procedure TfrmIconManager.BDelClick(Sender: TObject);
begin
  if Tree.Selected = nil then Exit else
  if (Tree.Selected.Parent = FDirRoot) then
  begin
    if Confirm('Delete link to directory?') then
    begin
      Tree.Items.Delete(Tree.Selected);
      HasChange;
    end;
  end else
  if (Tree.Selected.Parent = FFilRoot) then
  begin
    if Confirm('Delete link to file?') then
    begin
      Tree.Items.Delete(Tree.Selected);
      HasChange;
    end;
  end else
  if (Tree.Selected.Parent = FCatRoot) then
  begin
    if Confirm('Delete category?') then
    begin
      Tree.Items.Delete(Tree.Selected);
      HasChange;
    end;
  end;
end;

procedure TfrmIconManager.HasChange;
begin
  if FStarting then Exit;
  BSave.Enabled := True;
  FChanges := True;
end;

procedure TfrmIconManager.BSaveClick(Sender: TObject);
begin
  SaveToRegistry(True);
  BSave.Enabled := False;
  FChanges := False;
end;

procedure TfrmIconManager.BIconsClick(Sender: TObject);
begin
  FileList.ViewStyle := TViewStyle(TSpeedButton(Sender).Tag - 1);
end;

procedure TfrmIconManager.SelectNewByName(FileName: String);
var RealName: String;
    IconNum: Integer;
    aIcon: TIcon;
begin
  FSelectedImageName := AnsiLowerCase(FileName);
  if FileName = '' then
  begin
    Image.Picture.Icon := nil;
    StatusBar.Panels[0].Text := '';
    StatusBar.Panels[2].Text := '';
  end else
  begin
    try
      SeparateNum(FileName, RealName, IconNum);
      if AnsiUpperCase(RealName) = 'SYSTEM' then
      begin
        aIcon := TIcon.Create;
        aIcon.Handle := ImageList_GetIcon(HSystem, IconNum, ILD_NORMAL);
        Image.Picture.Icon.Assign(aIcon);
        aIcon.Free;
        StatusBar.Panels[0].Text := '';
        StatusBar.Panels[2].Text := RealName + ', ' + IntToStr(IconNum);
      end else
      begin
        aIcon := TIcon.Create;
        if IconNum = -1 then aIcon.LoadFromFile(RealName) else
          aIcon.Handle := ExtractIcon(hInstance, PChar(RealName), IconNum);
        Image.Picture.Icon.Assign(aIcon);
        if IconNum = -1 then
        begin
          StatusBar.Panels[0].Text := IntToStr(GetFileSize(RealName)) + ' bytes(s)';
          StatusBar.Panels[2].Text := RealName;
        end else begin
          StatusBar.Panels[0].Text := '';
          StatusBar.Panels[2].Text := RealName + ', ' + IntToStr(IconNum);
        end;
        aIcon.Free;
      end;
    except
      Image.Picture.Icon := nil;
      StatusBar.Panels[0].Text := 'Invalid';
      StatusBar.Panels[2].Text := FileName;
    end;
  end;
  UpdateImageMeasure;
end;

procedure TfrmIconManager.FileListChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if FReading then Exit;
  if (Item = nil) or (Item.SubItems.Count < 3) then
    SelectNewByName('') else
      SelectNewByName(Item.SubItems[2]);
end;

procedure TfrmIconManager.FileListDblClick(Sender: TObject);
begin
  if FileList.Selected <> nil then ModalResult := mrOk;
end;

procedure TfrmIconManager.FileListCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var Sz1, Sz2: Integer;
    Dt1, Dt2: TDateTime;
    S1, S2: String;

 function SortByName: Integer;
 begin
   S1 := AnsiUpperCase(Item1.Caption);
   S2 := AnsiUpperCase(Item2.Caption);
   if S1 > S2 then Result := 1 else
   if S1 < S2 then Result := -1 else Result := 0;
 end;

begin
  case FComp of
    cmName: Compare := SortByName;
    cmSize:
      begin
        if (Item1.SubItems.Count >= 1) or
           (Item2.SubItems.Count >= 1) then
        begin
          Sz1 := StrToInt(Item1.SubItems[0]);
          Sz2 := StrToInt(Item2.SubItems[0]);
          if Sz1 > Sz2 then Compare := 1 else
          if Sz1 < Sz2 then Compare := -1 else Compare := SortByName;
        end;
      end;
    cmDate:
      begin
        if (Item1.SubItems.Count >= 2) or
           (Item2.SubItems.Count >= 2) then
        begin
          Dt1 := StrToDateTime(Item1.SubItems[1]);
          Dt2 := StrToDateTime(Item2.SubItems[1]);
          if Dt1 > Dt2 then Compare := 1 else
          if Dt1 < Dt2 then Compare := -1 else Compare := SortByName;
        end;
      end;
    else Exit;
  end;
  if not FAscSort then Compare := -Compare;
end;

procedure TfrmIconManager.FileListColumnClick(Sender: TObject;
  Column: TListColumn);
var NewSort: TCompareMode;
begin
  case Column.Index of
    0: NewSort := cmName;
    1: NewSort := cmSize;
    2: NewSort := cmDate;
    else Exit;
  end;
  if NewSort = FComp then FAscSort := not FAscSort else
  begin
    FComp := NewSort;
    FAscSort := True;
  end;
  FileList.AlphaSort;
end;

procedure TfrmIconManager.FileListEditing(Sender: TObject;
  Item: TListItem; var AllowEdit: Boolean);
begin
  BCancel.Cancel := False;
end;

procedure TfrmIconManager.FixLinks(OldPath, NewPath: String);

  procedure FixLinkForNode(Node: TTreeNode);
  var SL: TStringList;
      I, Idx: Integer;
      S: String;
  begin
    if Node.Data = nil then Exit;
    SL := Node.Data;
    for I := 0 to SL.Count - 1 do
    begin
      SeparateNum(SL[I], S, Idx);
      if NormalizePath(S) = OldPath then
        SL[I] := PackNum(NewPath, Idx);
    end;
  end;

var I: Integer;
begin
  OldPath := NormalizePath(OldPath);
  NewPath := NormalizePath(NewPath);
  FixLinkForNode(FLstRoot);
  for I := 0 to FCatRoot.Count - 1 do
    FixLinkForNode(FCatRoot.Item[I]);
end;

procedure TfrmIconManager.FileListEdited(Sender: TObject; Item: TListItem;
  var S: String);
var OldName, NewName: String;
    Idx: Integer;
begin
  if S = '' then S := Item.Caption else
  if Pos('.ICO', AnsiUpperCase(S)) = 0 then
  begin
    Warning('File name should have a "ico" extension');
    S := Item.Caption;
  end else
  begin
    OldName := Item.SubItems[2];
    NewName := NormalizePath(ExtractFilePath(OldName) + '\' + S);
    if not RenameFile(OldName, NewName) then
    begin
      Error('Can''t rename file');
      S := Item.Caption;
    end else
    begin
      Item.SubItems[2] := NewName;
      if (Tree.Selected <> nil) and (Tree.Selected.Data <> nil) then
      begin
        Idx := TStringList(Tree.Selected.Data).IndexOf(OldName);
        if Idx <> -1 then TStringList(Tree.Selected.Data)[Idx] := NewName;
      end;
      HasChange;
    end;
    FixLinks(OldName, NewName);
  end;
  BCancel.Cancel := True;
end;

procedure TfrmIconManager.BBrowseClick(Sender: TObject);
var S: String;
begin
  if Tree.Selected = nil then Exit else
  if (Tree.Selected.Parent = FDirRoot) then
  begin
    S := BrowseDir(Tree.Selected.Text);
    if DirExists(S) then
    begin
      Tree.Selected.Text := AnsiLowerCase(S);
      HasChange;
      TreeChange(Self, Tree.Selected);
    end;
  end;
end;

procedure TfrmIconManager.CommonFillEnd;
begin
  FileList.AlphaSort;
  FileList.Visible := True;
  StatusBar.Panels[0].Text := IntToStr(FileList.Items.Count) + ' icon(s)';
  if FileList.Items.Count > 0 then FileList.Selected := FileList.Items[0];
end;

procedure TfrmIconManager.StartVisual(pText: String; pMax: Integer);
begin
  LProgressInfo.Caption := pText;
  ProgressBar.Max := pMax;
  ProgressBar.Position := 0;
  LProgressInfo.Visible := True;
  ProgressBar.Visible := True;
  LProgressInfo.Refresh;
  ProgressBar.Refresh;
end;

procedure TfrmIconManager.NextVisual(pValue: Integer);
begin
  ProgressBar.Position := pValue;
  ProgressBar.Refresh;
end;

procedure TfrmIconManager.DoneVisual;
begin
  LProgressInfo.Visible := False;
  ProgressBar.Visible := False;
end;

procedure TfrmIconManager.FillListForDir(S: String);
var SR: TSearchRec;
    Found: Integer;
begin
  StatusBar.Panels[0].Text := 'Reading...';
  Found := FindFirst(NormalizePath(S + '\*.ico'), faAnyFile, SR);
  while Found = 0 do
  begin
    AddFileToList(NormalizePath(S + '\' + SR.Name));
    Found := FindNext(SR);
  end;
  FindClose(SR);
  CommonFillEnd;
  StatusBar.Panels[2].Text := NormalizePath(S);
end;

procedure TfrmIconManager.FillListForFile(S: String);
var I, Num: Integer;
begin
  S := NormalizePath(S);
  Num := ExtractIcon(hInstance, PChar(S), -1);
  for I := 0 to Num - 1 do
    AddFileToList(PackNum(S, I));
  CommonFillEnd;
  StatusBar.Panels[2].Text := NormalizePath(S);
end;

procedure TfrmIconManager.FillBySystemList(pIndex: Integer);
var I, Cnt, N1, N2: Integer;
begin
  Cnt := ImageList_GetImageCount(HSystem);
  N1 := pIndex * 100;
  N2 := N1 + 99;
  if N2 > Cnt - 1 then N2 := Cnt - 1;
  StartVisual('Loading system icons...', N2 - N1 + 1);
  for I := N1 to N2 do
  begin
    AddFileToList(PackNum('System', I));
    if (I mod 10) = 0 then NextVisual(I - N1);
  end;
  DoneVisual;
  CommonFillEnd;
end;

procedure TfrmIconManager.FillFromNodeList(Node: TTreeNode);
var I: Integer;
    SL: TStringList;
begin
  if Node.Data = nil then Exit;
  SL := TStringList(Node.Data);
  for I := 0 to SL.Count - 1 do AddFileToList(SL[I]);
  CommonFillEnd;
end;

procedure TfrmIconManager.FileListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var I: Integer;
begin
  if (Shift = []) then
  begin
    case Key of
      VK_F2: if FileList.Selected <> nil then FileList.Selected.EditCaption else Exit;
      VK_DELETE: if (not FileList.IsEditing) and (FileList.Selected <> nil) then BDelImg.OnClick(Self) else Exit;
      VK_ESCAPE: if (not FileList.IsEditing) and (not BCancel.Cancel) then
                 begin
                   BCancel.Cancel := True;
                   BCancel.Click;
                   Exit;
                 end;
      else Exit;
    end;
    Key := 0;
  end else
  if (Key = Byte('A')) and (Shift = [ssCtrl]) then
  begin
    for I := 0 to FileList.Items.Count - 1 do
      FileList.Items[I].Selected := True;
    Key := 0;
  end;
end;

function TfrmIconManager.AddNameToNode(Node: TTreeNode; FileName: String): Boolean;
var I: Integer;
    SL: TStringList;
begin
  Result := False;
  if Node.Data = nil then Exit;
  FileName := AnsiLowerCase(FileName);
  SL := TStringList(Node.Data);
  for I := 0 to SL.Count - 1 do
    if AnsiLowerCase(SL[I]) = FileName then Exit; 
  SL.Add(FileName);
  Result := True;
end;

function TfrmIconManager.DeleteNameFromNode(Node: TTreeNode; FileName: String): Boolean;
var I: Integer;
    SL: TStringList;
begin
  Result := False;
  if Node.Data = nil then Exit;
  FileName := AnsiLowerCase(FileName);
  SL := TStringList(Node.Data);
  for I := 0 to SL.Count - 1 do
    if AnsiLowerCase(SL[I]) = FileName then
    begin
      SL.Delete(I);
      Result := True;
      Break;
    end;
end;

procedure TfrmIconManager.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := True;
  if ModalResult <> mrOk then Exit;
  Picture := Image.Picture.Icon;
  if (Image.Picture.Icon <> nil) and (not Image.Picture.Icon.Empty) and
     (mSaveLast.Checked) and (FSelectedImageName <> '') then
     AddNameToNode(FLstRoot, FSelectedImageName);
  HasChange;
  CanClose := True;
end;

procedure TfrmIconManager.BClearClick(Sender: TObject);
begin
  Image.Picture.Icon := nil;
  ModalResult := mrOk;
end;

procedure TfrmIconManager.TreeDeletion(Sender: TObject; Node: TTreeNode);
begin
  if Node.Data <> nil then
  begin
    TStringList(Node.Data).Free;
    Node.Data := nil;
    if Node = FLastTarget then SetLastTarget(nil);
  end;
end;

procedure TfrmIconManager.TreeDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var Node: TTreeNode;
begin
  Node := Tree.GetNodeAt(X, Y);
  Accept := False;
  if (Node = nil) or (Node = Tree.Selected) or (Node.Level = 0) then Exit;
  Accept := ((Tree.Selected.Parent = Node.Parent) and ((Node.Parent = FDirRoot) or (Node.Parent = FCatRoot))) or
            (Node.Parent = FCatRoot);
end;

procedure TfrmIconManager.CopyOrMoveToNode(TargetNode: TTreeNode);
var Num, Idx: Integer;
    Item: TListItem;
    Succ: Boolean;
    NewName: String;
begin
  Num := FileList.SelCount;
  Idx := FileList.Selected.Index;
  InitInfo;
  while (Idx < FileList.Items.Count) and (Num > 0) do
  begin
    Item := FileList.Items[Idx];
    Succ := False;
    if Item.Selected then
    begin
      if (Tree.Selected.Parent = FDirRoot) and (TargetNode.Parent = FDirRoot) then
      begin
        NewName := NormalizePath(TargetNode.Text + '\' + Item.Caption);
        if not Windows.CopyFile(PChar(Item.SubItems[2]), PChar(NewName), True) then
          Info_AddError('Can''t copy file "' + Item.Caption + '". Another file with same name exists.') else
          if BMoveMode.Down then
          begin
            Succ := DeleteFile(Item.SubItems[2]);
            if not Succ then Info_AddError('Can''t delete file "' + Item.Caption + '". Moving operation incomplete.');
          end;
      end else
      if (TargetNode.Parent = FCatRoot) then
      begin
        if not AddNameToNode(TargetNode, Item.SubItems[2]) then
          Info_AddError('Can''t copy link for "' + Item.Caption + '". Such link already exists.') else
          if BMoveMode.Down and (Tree.Selected.Parent = FCatRoot) then
          begin
            Succ := DeleteNameFromNode(Tree.Selected, Item.SubItems[2]);
            if not Succ then Info_AddError('Can''t delete link for "' + Item.Caption + '". Moving operation incomplete.');
          end;
      end;
      Dec(Num);
    end;
    if Succ then FileList.Items.Delete(Item.Index) else Inc(Idx);
  end;
  if BMoveMode.Down then FileList.Arrange(arDefault);
  ShowInfo;
  StatusBar.Panels[2].Text := 'Copy/Move operation complete';
  HasChange;
end;

procedure TfrmIconManager.TreeDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  if (FileList.Selected = nil) or (Tree.DropTarget = Nil) or
     (Tree.DropTarget.Level <> 1) then Exit;
  CopyOrMoveToNode(Tree.DropTarget);
  SetLastTarget(Tree.DropTarget);
end;

procedure TfrmIconManager.BDelImgClick(Sender: TObject);
var Num, Idx: Integer;
    Item: TListItem;
begin
  if (Tree.Selected = nil) or (FileList.Selected = nil) then Exit else
  if (Tree.Selected.Parent = FDirRoot) then
  begin
    if Confirm('Delete files(s)?') then
    begin
      Num := FileList.SelCount;
      Idx := FileList.Selected.Index;
      InitInfo;
      while (Idx < FileList.Items.Count) and (Num > 0) do
      begin
        Item := FileList.Items[Idx];
        if Item.Selected then
        begin
          if DeleteFile(Item.SubItems[2]) then
             FileList.Items.Delete(Idx) else
             begin
               Info_AddError('Can''t delete file "' + Item.Caption + '"');
               Inc(Idx);
             end;
          Dec(Num);
        end else
          Inc(Idx);
      end;
      ShowInfo;
      HasChange;
      FileList.Arrange(arDefault);
    end;
  end else
  if (Tree.Selected.Parent = FCatRoot) or (Tree.Selected = FLstRoot) then
  begin
    if Confirm('Delete link(s)?') then
    begin
      Num := FileList.SelCount;
      Idx := FileList.Selected.Index;
      InitInfo;
      while (Idx < FileList.Items.Count) and (Num > 0) do
      begin
        Item := FileList.Items[Idx];
        if Item.Selected then
        begin
          if DeleteNameFromNode(Tree.Selected, Item.SubItems[2]) then
            FileList.Items.Delete(Idx) else
            begin
              Info_AddError('Can''t delete link for "' + Item.Caption + '"');
              Inc(Idx);
            end;
          Dec(Num);
        end else
          Inc(Idx);
      end;
      ShowInfo;
      HasChange;
      FileList.Arrange(arDefault);
    end;
  end;
end;

procedure TfrmIconManager.mAutoSaveClick(Sender: TObject);
begin
  mAutoSave.Checked := not mAutoSave.Checked;
end;

procedure TfrmIconManager.PUpResize(Sender: TObject);
begin
  FileList.Arrange(arDefault);
end;

procedure TfrmIconManager.mAboutClick(Sender: TObject);
begin
  ShowOtAbout('Icon Manager');
end;

procedure TfrmIconManager.mShowStatusClick(Sender: TObject);
begin
  mShowStatus.Checked := not mShowStatus.Checked;
  StatusBar.Visible := mShowStatus.Checked;
end;

procedure TfrmIconManager.TreeDblClick(Sender: TObject);
begin
  if (Tree.Selected <> nil) and (Tree.Selected.Parent = FDirRoot) then
    ShellExecute(Handle, nil, PChar(Tree.Selected.Text), nil, nil, SW_SHOW);
end;

procedure TfrmIconManager.TreeExit(Sender: TObject);
begin
  if not BCancel.Cancel then BCancel.Cancel := True;
end;

procedure TfrmIconManager.FileListExit(Sender: TObject);
begin
  if not BCancel.Cancel then BCancel.Cancel := True;
end;

procedure TfrmIconManager.BSaveImgClick(Sender: TObject);
begin
  if Image.Picture.Icon.Empty then Exit;
  SaveDlg.InitialDir := FLastDir;
  if SaveDlg.Execute then
  begin
    Image.Picture.Icon.SaveToFile(SaveDlg.FileName);
    FLastDir := ExtractFilePath(SaveDlg.FileName);
  end;
end;

procedure TfrmIconManager.mRestorePathClick(Sender: TObject);
begin
  mRestorePath.Checked := not mRestorePath.Checked;
end;

procedure TfrmIconManager.AdjustToolBarHeight;
const CHeights: array[false..true] of Integer = (32, 64);
begin
  PListBtn.Height := CHeights[BOpenBar.Down];
  BvToolBarSep.Visible := BOpenBar.Down;
end;

procedure TfrmIconManager.BOpenBarClick(Sender: TObject);
begin
  AdjustToolBarHeight;
end;

procedure TfrmIconManager.SetLastTarget(Node: TTreeNode);
begin
  FLastTarget := Node;
  if Node = nil then
  begin
    BCopyAgain.Enabled := False;
    BCopyAgain.Hint := 'Copy/Move to last target';
  end else begin
    BCopyAgain.Enabled := True;
    BCopyAgain.Hint := 'Copy/Move to "' + Node.Text + '"';
  end;
end;

procedure TfrmIconManager.BCopyAgainClick(Sender: TObject);
begin
  if FLastTarget <> nil then CopyOrMoveToNode(FLastTarget);
end;

procedure TfrmIconManager.mHotTrackClick(Sender: TObject);
begin
  mHotTrack.Checked := not mHotTrack.Checked;
  FileList.HotTrack := mHotTrack.Checked;
end;

procedure TfrmIconManager.mGridLinesClick(Sender: TObject);
begin
  mGridLines.Checked := not mGridLines.Checked;
  FileList.GridLines := mGridLines.Checked;
end;

procedure TfrmIconManager.mShowRootsClick(Sender: TObject);
begin
  mShowRoots.Checked := not mShowRoots.Checked;
  Tree.ShowRoot := mShowRoots.Checked;
end;

procedure TfrmIconManager.mShowLinesClick(Sender: TObject);
begin
  mShowLines.Checked := not mShowLines.Checked;
  Tree.ShowLines := mShowLines.Checked;
end;

procedure TfrmIconManager.mSaveLastClick(Sender: TObject);
begin
  mSaveLast.Checked := not mSaveLast.Checked;
end;

procedure TfrmIconManager.IconScaner1Click(Sender: TObject);
var SL: TStringList;
    I: Integer;
begin
  SL := ScanForIconDirs;
  if SL <> nil then
  begin
    for I := 0 to SL.Count - 1 do AddDirNode(SL[I]);
    SL.Free;
    HasChange;
  end;
end;

end.
