{----------------------------------------------------------}
{---                                                    ---}
{---  OpenTools Solutions                               ---}
{---                                                    ---}
{---  (c), (p) Ilya Vdovin, 1999                        ---}
{---                                                    ---}
{---  http://www.chat.ru/~opentools                     ---}
{---  opentools@chat.ru                                 ---}
{---                                                    ---}
{----------------------------------------------------------}

unit OTAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Animate, ExtCtrls, StdCtrls, ShellApi;

const CVer = 'Version 1.41, Freeware';

type
  TfrmOTAbout = class(TForm)
    Image: TAnimatedImage;
    PVersion: TPanel;
    LHomePage: TLabel;
    LMail: TLabel;
    BOk: TButton;
    LVerInfo: TLabel;
    procedure LMailClick(Sender: TObject);
    procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    FDrag: Boolean;
    FDrgPnt: TPoint;
  public
  end;

var
  frmOTAbout: TfrmOTAbout;

procedure ShowOtAbout(pVersion: String);

implementation

{$R *.DFM}

procedure ShowOtAbout(pVersion: String);
var F: TfrmOTAbout;
begin
  F := TfrmOTAbout.Create(nil);
  try
    if pVersion <> '' then pVersion := pVersion + ', ';
    F.LVerInfo.Caption := pVersion + CVer;
    F.Image.GlyphNum := 1;
    F.ShowModal;
  finally
    F.Free;
  end;
end;

procedure TfrmOTAbout.LMailClick(Sender: TObject);
begin
  ShellExecute(Handle, nil, PChar(TLabel(Sender).Hint), nil, nil, SW_SHOW);
end;

procedure TfrmOTAbout.ImageMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    FDrag := True;
    FDrgPnt := Point(X, Y);
  end;
end;

procedure TfrmOTAbout.ImageMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and FDrag then FDrag := False;
end;

procedure TfrmOTAbout.ImageMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if FDrag then
  begin
    Left := Left + (X - FDrgPnt.X);
    Top := Top + (Y - FDrgPnt.Y);
  end;
end;

end.
