{----------------------------------------------------------}
{---                                                    ---}
{---  OpenTools Solutions                               ---}
{---                                                    ---}
{---  (c), (p) Ilya Vdovin, 1999                        ---}
{---                                                    ---}
{---  http://www.chat.ru/~opentools                     ---}
{---  opentools@chat.ru                                 ---}
{---                                                    ---}
{----------------------------------------------------------}

unit ImageManProp;

interface

uses Windows, Classes, Graphics, Controls, Consts, DsgnIntf;

type

  {TImgManProperty}

  TImgManProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

implementation

Uses ImageManager;

{TImgManProperty}

procedure TImgManProperty.Edit;
var
  ImgMan: TfrmImageManager;
  Comp: TPersistent;
begin
  ImgMan := nil;
  try
    ImgMan := TfrmImageManager.Create(nil);
    Comp := GetComponent(0);
    if Comp is TComponent then
      ImgMan.SubCaption := TComponent(Comp).Name + '.' + GetName;
    ImgMan.Picture := TBitmap(Pointer(GetOrdValue));
    if ImgMan.ShowModal = mrOk then SetOrdValue(Longint(ImgMan.Picture));
  finally
    if ImgMan <> nil then ImgMan.Free;
  end;
end;

function TImgManProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TImgManProperty.GetValue: string;
var
  Bmp: TBitmap;
begin
  Bmp := TBitmap(GetOrdValue);
  if Bmp = nil then Result := srNone
    else Result := '(' + Bmp.ClassName + ')';
end;

procedure TImgManProperty.SetValue(const Value: string);
begin
  if Value = '' then SetOrdValue(0);
end;

end.
