{----------------------------------------------------------}
{---                                                    ---}
{---  OpenTools Solutions                               ---}
{---                                                    ---}
{---  (c), (p) Ilya Vdovin, 1999                        ---}
{---                                                    ---}
{---  http://www.chat.ru/~opentools                     ---}
{---  opentools@chat.ru                                 ---}
{---                                                    ---}
{----------------------------------------------------------}

unit IconManProp;

interface

uses Windows, Classes, Graphics, Controls, Consts, DsgnIntf;

type

  {TIconManProperty}

  TIconManProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

implementation

Uses IconManager;

{TIconManProperty}

procedure TIconManProperty.Edit;
var
  IconMan: TfrmIconManager;
  Comp: TPersistent;
begin
  IconMan := nil;
  try
    IconMan := TfrmIconManager.Create(nil);
    Comp := GetComponent(0);
    if Comp is TComponent then
      IconMan.SubCaption := TComponent(Comp).Name + '.' + GetName;
    IconMan.Picture := TIcon(Pointer(GetOrdValue));
    if IconMan.ShowModal = mrOk then SetOrdValue(Longint(IconMan.Picture));
  finally
    if IconMan <> nil then IconMan.Free;
  end;
end;

function TIconManProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TIconManProperty.GetValue: string;
var
  Icn: TIcon;
begin
  Icn := TIcon(GetOrdValue);
  if Icn = nil then Result := srNone
    else Result := '(' + Icn.ClassName + ')';
end;

procedure TIconManProperty.SetValue(const Value: string);
begin
  if Value = '' then SetOrdValue(0);
end;

end.
