{-------------------------------------------------------------}
{---                                                       ---}
{---  Viv's Components for Delphi                          ---}
{---                                                       ---}
{---  (c), (p) Ilya Vdovin, 1999                           ---}
{---                                                       ---}
{-------------------------------------------------------------}

unit IconDlg;

{$R-}

interface

uses Messages, Windows, SysUtils, Classes, Controls, StdCtrls, Graphics,
  ExtCtrls, Buttons, Dialogs, ShellApi;

type

{ TOpenIconDialog }

  TOpenIconDialog = class(TOpenDialog)
  private
    FListBoxPanel: TPanel;
    FViewLabel: TLabel;
    FPaintPanel: TPanel;
    FListBox: TListBox;
  protected
    procedure DoClose; override;
    procedure DoSelectionChange; override;
    procedure DoShow; override;
    procedure LBDrawItem(Control: TWinControl; Index: Integer;
                         Rect: TRect; State: TOwnerDrawState);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute: Boolean; override;
  end;

implementation

uses Consts, Forms, CommDlg, Dlgs;

const
  SViewLabel = 'Icons count: ';
  CIconSize = 36;

{ TOpenIconDialog }

constructor TOpenIconDialog.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Filter := GraphicFilter(TGraphic);
  FListBoxPanel := TPanel.Create(Self);
  with FListBoxPanel do
  begin
    Name := 'PicturePanel';
    Caption := '';
    SetBounds(204, 5, 169, 200);
    BevelOuter := bvNone;
    BorderWidth := 6;
    TabOrder := 1;
    FViewLabel := TLabel.Create(Self);
    with FViewLabel do
    begin
      Name := 'ViewLabel';
      Caption := '';
      SetBounds(6, 6, 157, 23);
      Align := alTop;
      AutoSize := False;
      Parent := FListBoxPanel;
    end;
    FPaintPanel := TPanel.Create(Self);
    with FPaintPanel do
    begin
      Name := 'PaintPanel';
      Caption := '';
      SetBounds(6, 29, 157, 145);
      Align := alClient;
      BevelInner := bvRaised;
      BevelOuter := bvLowered;
      TabOrder := 0;
      FListBox := TListBox.Create(Self);
      Parent := FListBoxPanel;
      with FListBox do
      begin
        Name := 'PaintBox';
        SetBounds(0, 0, 153, 141);
        Align := alClient;
        Parent := FPaintPanel;
        Style := lbOwnerDrawFixed;
        ItemHeight := CIconSize;
        OnDrawItem := LBDrawItem;
      end;
    end;
  end;
end;

destructor TOpenIconDialog.Destroy;
begin
  FListBox.Free;
  FPaintPanel.Free;
  FViewLabel.Free;
  FListBoxPanel.Free;
  inherited Destroy;
end;

procedure TOpenIconDialog.DoSelectionChange;
var
  HasIcons: Boolean;
  IconsNum, I: Integer;

  function ValidFile(const FileName: string): Boolean;
  begin
    Result := GetFileAttributes(PChar(FileName)) <> $FFFFFFFF;
  end;

begin
  FListBox.Items.Clear;
  IconsNum := 0;
  HasIcons := FileExists(FileName) and ValidFile(FileName);
  if HasIcons then
  begin
    IconsNum := ExtractIcon(hInstance, PChar(FileName), UINT(-1));
    FViewLabel.Caption := Format(SViewLabel + '%d', [IconsNum]);
    HasIcons := IconsNum > 0;
  end;
  if HasIcons then
  begin
    for I := 0 to IconsNum - 1 do
       FListBox.Items.Add(IntToStr(I));
  end else
    FViewLabel.Caption := SViewLabel + '0';
  FListBox.Visible := HasIcons;
  if HasIcons then FListBox.Invalidate;
  inherited DoSelectionChange;
end;

procedure TOpenIconDialog.DoClose;
begin
  inherited DoClose;
  { Hide any hint windows left behind }
  Application.HideHint;
end;

procedure TOpenIconDialog.DoShow;
var
  PreviewRect: TRect;
begin
  { Set preview area to entire dialog }
  GetClientRect(Handle, PreviewRect);
  { Move preview area to right of static area }
  PreviewRect.Left := GetStaticRect.Right;
  Inc(PreviewRect.Top, 4);
  FListBoxPanel.BoundsRect := PreviewRect;
  FListBox.Columns := (FListBox.Width - 4) div CIconSize;
  FListBoxPanel.ParentWindow := Handle;
  inherited DoShow;
end;

function TOpenIconDialog.Execute;
begin
  if NewStyleControls and not (ofOldStyleDialog in Options) then
    Template := 'DLGTEMPLATE' else
    Template := nil;
  Result := inherited Execute;
end;

procedure TOpenIconDialog.LBDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var X, Y: Integer;
    Icn: HIcon;
begin
  X := Rect.Left + (CIconSize - 32) div 2;
  Y := Rect.Top + (CIconSize - 32) div 2;
  Icn := ExtractIcon(hInstance, PChar(FileName), Index);
  with FListBox.Canvas do
  begin
    Brush.Color := clWindow;
    FillRect(Rect);
    DrawIcon(Handle, X, Y, Icn);
  end;
  DestroyIcon(Icn);
end;

end.
