unit MGraph;

{$OPTIMIZATION OFF}

  interface

    uses Windows, Classes, SysUtils;

    const MarginDelta : Integer = 2;

    function Distance(const p1,p2 : TPoint) : Cardinal;
    function NormalizeRect(const x1,y1,x2,y2 : Integer) : TRect;
    function ScreenToDecart(const p : TPoint; const ScrHeight : Integer) : TPoint;
    function DecartToScreen(const p : TPoint; const ScrHeight : Integer) : TPoint;
    function PointOnLine(const p : TPoint; const m1,m2 : TPoint; const PenWidth : Integer) : Boolean;
    function PointInRect(const p : TPoint; const R : TRect) : Boolean;
    function PointInPolyRgn(const p : TPoint; const Points: array of TPoint) : Boolean;
    function Hex2Dec(const S : String) : Longint;
    function MakeStr(C : Char; N : Integer) : String;
    function Min(A, B: Longint): Longint;
    function Max(A, B: Longint): Longint;

implementation

function Distance(const p1,p2 : TPoint) : Cardinal;
begin
  Result:=Trunc(Sqrt(Sqr(p1.X - p2.X) + Sqr(p1.Y - p2.Y)));
end;

function NormalizeRect(const x1,y1,x2,y2 : Integer) : TRect;
begin
  Result := Rect(x1,y1,x2,y2);
  if (x1 > x2) then if (y1 > y2) then Result := Rect(x2,y2,x1,y1) else Result:=Rect(x2,y1,x1,y2)
               else if (y1 > y2) then Result := Rect(x1,y2,x2,y1);
  Result := Rect(Result.Left - MarginDelta, Result.Top - MarginDelta, Result.Right + MarginDelta, Result.Bottom + MarginDelta);
end;

function ScreenToDecart(const p:TPoint; const ScrHeight:Integer):TPoint;
begin
  Result := Point(p.X,ScrHeight - p.Y);
end;

function DecartToScreen(const p:TPoint; const ScrHeight:Integer):TPoint;
begin
  Result := Point(p.X,ScrHeight-p.Y);
end;

function PointOnLine(const p : TPoint; const m1,m2 : TPoint; const PenWidth : Integer) : Boolean;
  var l2,d12,d22 : {$IFNDEF VER100} Int64 {$ELSE} Integer {$ENDIF};
      dist2 : Extended;
begin
  l2 := (m1.X - m2.X)*(m1.X - m2.X) + (m1.Y - m2.Y)*(m1.Y - m2.Y);
  d12 := (m1.X - p.X)*(m1.X - p.X) + (m1.Y - p.Y)*(m1.Y - p.Y);
  d22 := (m2.X - p.X)*(m2.X - p.X) + (m2.Y - p.Y)*(m2.Y - p.Y);
  dist2 := Abs(4*d12*d22 - (l2 - d12 - d22)*(l2 - d12 - d22)) / (4*l2);
  Result := (dist2 <= (MarginDelta + PenWidth)*(MarginDelta + PenWidth));
end;

function PointInRect(const P: TPoint; const R: TRect): Boolean;
begin
  with R do
    Result := (Left <= P.X) and (Top <= P.Y) and
      (Right >= P.X) and (Bottom >= P.Y);
end;

function PointInPolyRgn(const P: TPoint; const Points: array of TPoint): Boolean;
type
  PPoints = ^TPoints;
  TPoints = array[0..0] of TPoint;
var
  Rgn: HRgn;
begin
  Rgn := CreatePolygonRgn(PPoints(@Points)^, High(Points) + 1, WINDING);
  try
    Result := PtInRegion(Rgn, P.X, P.Y);
  finally
    DeleteObject(Rgn);
  end;
end;

function Hex2Dec(const S: string): Longint;
var
  HexStr: string;
begin
  if Pos('$', S) = 0 then HexStr := '$' + S
  else HexStr := S;
  Result := StrToIntDef(HexStr, 0);
end;

function MakeStr(C: Char; N: Integer): string;
begin
  if N < 1 then Result := ''
  else begin
    SetLength(Result, N);
    FillChar(Result[1], Length(Result), C);
  end;
end;

function Min(A, B: Longint): Longint;
begin
  if A < B then Result := A else Result := B;
end;

function Max(A, B: Longint): Longint;
begin
  if A > B then Result := A else Result := B;
end;

end.