unit FindObject;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, Buttons, RXSpin, PEConsts, O2Plan;

type
  TFindObjectForm = class(TForm)
    FindObjectGroupBox: TGroupBox;
    Label1: TLabel;
    TypeCombo: TComboBox;
    NameEdit: TEdit;
    IDEdit: TRxSpinEdit;
    FindButton: TBitBtn;
    CancelButton: TBitBtn;
    HelpButton: TBitBtn;
    NameCheck: TCheckBox;
    IDCheck: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure NameCheckClick(Sender: TObject);
    procedure IDCheckClick(Sender: TObject);
    procedure FindButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    FoundObject : TPlanObject;
  end;

var
  FindObjectForm: TFindObjectForm;

implementation

{$R *.DFM}

  uses Main;

procedure TFindObjectForm.FormCreate(Sender: TObject);
begin
  TypeCombo.ItemIndex := 0;
  FoundObject := nil;
end;

procedure TFindObjectForm.NameCheckClick(Sender: TObject);
begin
  NameEdit.Visible := NameCheck.Checked;
end;

procedure TFindObjectForm.IDCheckClick(Sender: TObject);
begin
  IDEdit.Visible := IDCheck.Checked;
end;

procedure TFindObjectForm.FindButtonClick(Sender: TObject);
  var po : TPlanObject;
      oName : String;
      oID : Integer;
      oc : TPlanObjectClass;
begin
  if not (NameCheck.Checked or IDCheck.Checked) then Exit;
  po := nil;
  oc := TPlanObject;
  case TypeCombo.ItemIndex of
    1 : oc := TPlanLine;
    2 : oc := TPlanBox;
    3 : oc := TPlanCircle;
    4 : oc := TPlanText;
    5 : oc := TPlanPolygon;
    6 : oc := TPlanPicture;
    7 : oc := TPlanAniPicture;
    8 : oc := TPlanAniGif;
  end;

  if NameEdit.Visible then oName := Trim(NameEdit.Text) else oName := '';
  if IDEdit.Visible then oID := IDEdit.AsInteger else oID := 0;

  if NameCheck.Checked then begin
    if (oName = '') then begin
      if IDCheck.Checked then begin
        if (oID = 0) then begin // oName = '', oID = 0
          MessageDlg(sFindIDIsZero,mtError,[mbOk],0);
          Exit;
        end
        else po := MainForm.Plan.ObjectByID(oc,oID); // oName = '', oID <> 0
      end
      else begin
        MessageDlg(sFindNameIsEmpty,mtError,[mbOk],0);
        Exit;
      end;
    end
    else begin // oName <> ''
      if IDCheck.Checked then begin
        oID := IDEdit.AsInteger;
        if (oID = 0) then po := MainForm.Plan.ObjectByName(oc,oName) else po := MainForm.Plan.FindObject(oc,oName,oID);
      end
      else po := MainForm.Plan.ObjectByName(oc,oName);
    end;
  end
  else if IDCheck.Checked then begin // oName = ''
    if (oID = 0) then begin
      MessageDlg(sFindIDIsZero,mtError,[mbOk],0);
      Exit;
    end
    else po := MainForm.Plan.ObjectByID(oc,oID);
  end;
  if (po = nil) then begin
    MessageDlg(sCantFindObject,mtInformation,[mbOk],0);
    ModalResult := mrCancel;
  end
  else begin
    FoundObject := po;
    ModalResult := mrOk;
  end;
end;

end.
