// ----------------------------------
// Author	: Rob de Veij
// date		: 03 oct 1997
// Version	: 1.0
// Email	: rdv@homemail.com
// ----------------------------------

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

const
  CM_RESTORE = WM_USER + $1000;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure CreateParams(var Params: TCreateParams); override;
    Procedure RestoreRequest(var message: TMessage); message CM_RESTORE;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// =========================================
// Override Default RegisterClass Parameters
// =========================================
procedure TForm1.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.WinClassName := 'My Delphi Program!';
end;

// ===============================================
// Handle CM_RESTORE Message (Restore Application)
// ===============================================
procedure TForm1.RestoreRequest(var message: TMessage);
begin
  if IsIconic(Application.Handle) = TRUE then
    Application.Restore
  else
    Application.BringToFront;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Label2.Caption := inttohex(Application.Handle, 8);
end;

end.
