unit NumConv;
{
		"Product of my Spare Time"
				UNIT NAME: NumConv
	 COMPONENT NAME: TNumConv
	REGISTERED INTO: LK
					 AUTHOR: L.Kovri E-mail: lkovari@freemail.c3.hu
									(If You found some bug send a mail for me please.)
			DESCRIPTION: This conponent Convert the Value to another Numerical System.

							 You Must specify:
								 the value, in the Value property
								 the value of Numerical System of Value in ConvertFrom property
								 the value of Numerical System, (which You want to Convert)
									in ConvertTo property

							 Execute the Conversion:
								 Call the NumConv1.Conversion function
								 betven IF THEN ELSE structure, like as follows:

								 if NumConv1.Conversion then
										Label1.Caption:7NumConv1.Result
								 else
										MessageDlg(NumConv1.ErrorMessage,mtError,[mboK],0);

							 You Reply the result in the Result property

}

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type


	TNumConv = class(TComponent)
	private
		{ Private declarations }
		fErrStr,
		fError: String;
		fConvNotExecuted,
		fInNumSystemEntered,
		fInNumberEntered,
		fOutNumSystemEntered: Boolean;
		function Ex(Bs,x: real): extended;
		function ValueCheck(Value: string;NumSys:integer): Boolean;
		function Aligner(ss: string):string;
	protected
		{ Protected declarations }
		fNumSysIn,
		fNumSysout: integer;
		fDummyStr,
		fNumberIn,
		fNumberOut: string;
		fBeforeExecute: TNotifyEvent;
		fAfterExecute: TNotifyEvent;
		procedure SetNumSysIn(Ns: integer);
		procedure SetNumSysOut(Ns: integer);
		procedure SetNumberIn(Nv: string);
		function GetConversionResult: String;
		function GetErrorMessage: string;
		function GetNumSysIn: integer;
		function GetNumSysout: integer;
	public
		{ Public declarations }
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		function Conversion: Boolean;
	published
		{ Published declarations }
		property ConvertFrom: integer read GetNumSysIn write SetNumSysIn;
		property ConvertTo: integer read GetNumSysOut write SetNumSysOut;
		property Value: string read fNumberIn write SetNumberIn;
		property Result: string read GetConversionResult write fDummyStr;
		Property ErrorMessage: string read GetErrorMessage write fDummyStr;
		Property BeforeExecute: TNotifyEvent read fBeforeExecute write fBeforeExecute;
		Property AfterExecute: TNotifyEvent read fAfterExecute write fAfterExecute;
	end;


procedure Register;

implementation


constructor TNumConv.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	fConvNotExecuted:=True;
	fInNumSystemEntered:=False;
	fInNumberEntered:=False;
	fOutNumSystemEntered:=False;
	fNumSysIn:=0;
	fNumSysout:=0;
	fNumberIn:='';
	fNumberOut:='';
	fError:='';
end;

destructor TNumConv.Destroy;
begin
	inherited Destroy;
end;

// Set up the value of Input Numerical System
procedure TNumConv.SetNumSysIn(Ns: integer);
begin
	if (Not fInNumSystemEntered) and (Not fOutNumSystemEntered) and (Not fInNumberEntered) then
		fError:='';
	if ((Ns>1) and (Ns<=36)) then begin
		fNumSysIn:=Ns;
		fConvNotExecuted:=True;
		fInNumSystemEntered:=True;
	end
	else
		fError:=fError+'1';
end;

// Set up the value of Output Numerical System
procedure TNumConv.SetNumSysOut(Ns: integer);
begin
	if (Not fInNumSystemEntered) and (Not fOutNumSystemEntered) and (Not fInNumberEntered) then
		fError:='';
	if ((Ns>1) and (Ns<=36)) then begin
		fNumSysOut:=Ns;
		fConvNotExecuted:=True;
		fOutNumSystemEntered:=True;
	end
	else
		fError:=fError+'2';
end;

// Set the Input value for Convert
procedure TNumConv.SetNumberIn(Nv: string);
begin
	if (Not fInNumSystemEntered) and (Not fOutNumSystemEntered) and (Not fInNumberEntered) then
		fError:='';
	if (Nv<>'') and (Length(Nv)<=28) then begin
		fConvNotExecuted:=True;
		fNumberIn:=Uppercase(Nv);
		fInNumberEntered:=True;
	end
	else
		fError:=fError+'3';
end;

// Get the value of Input Numerical System
function TNumConv.GetNumSysIn: integer;
begin
	Result:=fNumSysIn;
end;

// Get the value of Ouput Numerical System
function TNumConv.GetNumSysout: integer;
begin
	Result:=fNumSysOut;
end;


// Get the value of Conversion Result
function TNumConv.GetConversionResult: String;
var
	n2: string;
	nc: char;
	i,n,m,k: integer;
	v: Comp;
begin
	if fConvNotExecuted then begin
		fNumberOut:='';
		fConvNotExecuted:=False;
		Result:='';
		if Not fInNumberEntered then
			fError:=fError+'6';
		if Not fOutNumSystemEntered then
			fError:=fError+'5';
		if Not fInNumSystemEntered then
			fError:=fError+'4';
		if fError='' then
			if ValueCheck(fNumberIn,fNumSysIn) then begin
				fNumberout:='';
				n:=0;
				(* Convert to Decimal *)
				i:=length(fNumberIn);
				k:=0;
				v:=0;
				repeat
					nc:=fNumberIn[i];
					nc:=upcase(nc);
					if ((nc>='0') and (nc<='9')) then	begin
							n:=ord(nc);
							n:=n-48;
					end
					else
						if ((nc>='A') and (nc<='Z')) then	begin
								n:=ord(nc);
								n:=n-55;
						end;
					{$Q+}
					try
						v:=v+(n*round(Ex(fNumsysIn,k)));
					except
						on EIntOverflow do begin
							fError:=fError+'8';
							fErrStr:='Integer Overflow!';
							i:=-1
						end;
					end;
					{$Q+}
					i:=i-1;
					k:=k+1;
				until i<1;
				if fError='' then begin
					// Convert to the Out Num. Sys.
					n2:='                                                            ';
					i:=60;
					repeat
						m:=trunc(v) mod fNumSysOut;
						v:=trunc(v/fNumSysOut);
						if ((m>=0) and (m<=9)) then	begin
								n2[i]:=chr(m+48);
								i:=i-1;
						end
						else begin
							m:=m-9;
							n:=64;
							n:=n+m;
							n2[i]:=chr(trunc(n));
							i:=i-1;
						end;
					until v<=0;
					fNumberout:=Aligner(n2);
				end;
				Result:=fNumberOut;
				fInNumberEntered:=False;
				fOutNumSystemEntered:=False;
				fInNumSystemEntered:=False;
			end
			else
				fError:=fError+'7';
	end
	else
		Result:=fNumberOut;
end;

// Calculate the x. exponent of Bs
function TNumConv.Ex(Bs,x: real): extended;
var
	 a,k: extended;
begin
	a:=Bs;
	k:=x;
	Result:=exp(ln(a)*k);
end;

// Align the the value in the string (space guzzler)
function TNumConv.Aligner(ss: string):string;
var
	i,j:integer;
	V: string;
begin
	v:='                                                                                                    ';
	i:=1;
	j:=1;
	repeat
		if ss[i]=' ' then
			i:=i+1
		else begin
			v[j]:=ss[i];
			j:=j+1;
			i:=i+1;
		end;
	until i>length(ss);
	Result:=v;
end;

// Check the Value of Input Number
function TNumConv.ValueCheck(Value: string;NumSys:integer): Boolean;
var
				i: integer;
				c: char;
				a: string[1];

begin
	Result:=True;
	i:=1;
	repeat
		c:=upcase(Value[i]);
		if NumSys<=10 then begin
			str(NumSys-1,a);
			if c>a then
				Result:=False;
		end
		else
			if NumSys>10 then
				if c>chr(NumSys+54) then
					Result:=False;
		i:=i+1;
	until i>length(Value);
end;

// Get the Messages wich occured under Conversion
function TNumConv.GetErrorMessage: string;
var
	t: integer;
	Estr: string;
begin
	t:=1;
	Estr:='';
	if fError<>'' then
		repeat
			case fError[t] of
				'1':Estr:=Estr+'Input Numerical System Number Error!'+#13;
				'2':Estr:=Estr+'Output Numerical System Number Error!'+#13;
				'3':Estr:=Estr+'Input Value Error!'+#13;
				'4':Estr:=Estr+'Input Numerical System Not Defined!'+#13;
				'5':Estr:=Estr+'Output Numerical System Not Defined!!'+#13;
				'6':Estr:=Estr+'Input Value for Conversion Not Defined!'+#13;
				'7':Estr:=Estr+fNumberIn+' Not a Real Value of '+inttostr(fNumSysIn)+'. Numerical System!'+#13;
				'8':Estr:=Estr+fErrStr+' Input Value Too Large!'+#13;
				'9':Estr:=Estr+'Range Error! Input Value Too Large!'+#13;
				else
					Estr:=Estr+'Undefined Error!'+#13;
			end;
			t:=t+1;
		until t>length(fError)
	else
		Estr:='Sucess!';
	Result:=Estr;
	fError:='';
end;

// Function of Conversion
function TNumConv.Conversion: Boolean;
var
	s:string;
begin
	s:=GetConversionResult;
	if fError<>'' then
		Result:=False
	else
		Result:=True;
end;

// Registering component into the Component Palette
procedure Register;
begin
	RegisterComponents('LK', [TNumConv]);
end;



end.
