Unit uTestClock;
{
   Demonstration Of TNuClock component
}

   
Interface
   
Uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   StdCtrls, Buttons,NuClock, ExtCtrls, ComCtrls, Mask;
   
Type
   TForm1 = class(TForm)
      ColorDialog1: TColorDialog;
      FontDialog1: TFontDialog;
      PageControl1: TPageControl;
      Welcome: TTabSheet;
      Label1: TLabel;
      Label2: TLabel;
      Label3: TLabel;
      Image1: TImage;
      Memo1: TMemo;
      StaticText3: TStaticText;
      SimpleClocks: TTabSheet;
      StaticText2: TStaticText;
      Clockwithcontrols: TTabSheet;
      StaticText4: TStaticText;
      Clock6FaceColor: TBitBtn;
      Clock6SecondColor: TBitBtn;
      Clock6MinuteColor: TBitBtn;
      Clock6HourColor: TBitBtn;
      Clock6BezelColor: TBitBtn;
      Clock6AllPensColor: TBitBtn;
      Clock6HoursLength: TTrackBar;
      Clock6MinutesLength: TTrackBar;
      Clock6SecondsLength: TTrackBar;
      StaticText9: TStaticText;
      StaticText10: TStaticText;
      StaticText11: TStaticText;
      Clock6ShowNumerals: TCheckBox;
      Clock6FaceFont: TBitBtn;
      Clock6Tick: TCheckBox;
      AphotographicTimer: TTabSheet;
      StaticText5: TStaticText;
      Clock7Go: TBitBtn;
      Clock7Stop: TBitBtn;
      Clock7Reset: TBitBtn;
      StaticText12: TStaticText;
      Chessclock: TTabSheet;
      StaticText6: TStaticText;
      StaticText13: TStaticText;
      StaticText14: TStaticText;
      Clock89Switch: TBitBtn;
      PicturesPanelsandBevels: TTabSheet;
      StaticText7: TStaticText;
      Sillyclocks: TTabSheet;
      StaticText8: TStaticText;
      BitBtn1: TBitBtn;
      StaticText1: TStaticText;
      NuClock1: TNuClock;
      NuClock2: TNuClock;
      NuClock3: TNuClock;
      NuClock4: TNuClock;
      NuClock5: TNuClock;
      NuClock6: TNuClock;
      NuClock7: TNuClock;
      NuClock8: TNuClock;
      NuClock9: TNuClock;
      Clock7AlarmMode: TCheckBox;
      DateTimePicker1: TDateTimePicker;
      Clock89Reset: TBitBtn;
      Panel1: TPanel;
      NuClock10: TNuClock;
      Panel2: TPanel;
      NuClock11: TNuClock;
      NuClock13: TNuClock;
      NuClock12: TNuClock;
      Panel3: TPanel;
      NuClock14: TNuClock;
      NuClock15: TNuClock;
      StaticText15: TStaticText;
      Procedure FormCreate(Sender: TObject);
      Procedure Clock6FaceColorClick(Sender: TObject);
      Procedure Clock6SecondColorClick(Sender: TObject);
      Procedure Clock6MinuteColorClick(Sender: TObject);
      Procedure Clock6HourColorClick(Sender: TObject);
      Procedure Clock6BezelColorClick(Sender: TObject);
      Procedure Clock6AllPensColorClick(Sender: TObject);
      Procedure Clock6HoursLengthChange(Sender: TObject);
      Procedure Clock6MinutesLengthChange(Sender: TObject);
      Procedure Clock6SecondsLengthChange(Sender: TObject);
      Procedure Clock6FaceFontClick(Sender: TObject);
      Procedure Clock6ShowNumeralsClick(Sender: TObject);
      Procedure Clock6TickClick(Sender: TObject);
      Procedure Clock7ResetClick(Sender: TObject);
      Procedure Clock7GoClick(Sender: TObject);
      Procedure Clock7StopClick(Sender: TObject);
      Procedure NuClock7ClockTick(Sender: TObject);
      Procedure DateTimePicker1Change(Sender: TObject);
      Procedure Clock89SwitchClick(Sender: TObject);
      Procedure Clock89ResetClick(Sender: TObject);
      Procedure NuClock14ClockTick(Sender: TObject);
   Private
{ Private declarations }
   Public
      
      Clock7AlarmIncrement:TDateTime;
      Clock7WasReset:Boolean;
      
      Clock8WasReset:Boolean;
      Clock9WasReset:Boolean;
      
      Procedure DoClock6Tick(Sender:Tobject);
      Function TimeOf(ATime:TDateTime):TDateTime;
{ Public declarations }
   End;

Var
   Form1: TForm1;

Implementation

{$R *.DFM}

Procedure TForm1.FormCreate(Sender: TObject);
Var
   ReadmePath:string;
Begin
   ReadmePath:=ExtractFilePath(ParamStr(0))+'ReadMe.txt';
   Label2.Caption:=ReadmePath+':';
   Memo1.Lines.LoadFromFile(ReadmePath);
   Clock6Hourslength.Position:=8;
   Clock6Minuteslength.Position:=9;
   Clock6Secondslength.Position:=10;
   Clock6ShowNumerals.Checked:=false;
   Clock7ResetClick(Self);
   Clock89ResetClick(Self);
End;


//clock 6 is the clock with on form controls for properties
Procedure TForm1.Clock6FaceColorClick(Sender: TObject);
Begin
   If ColorDialog1.Execute Then
      NuClock6.Face_Color := ColorDialog1.Color;
End;

Procedure TForm1.Clock6SecondColorClick(Sender: TObject);
Begin
   If ColorDialog1.Execute Then
      NuClock6.SecondHand.Brush_Color := ColorDialog1.Color;
End;

Procedure TForm1.Clock6MinuteColorClick(Sender: TObject);
Begin
   If ColorDialog1.Execute Then
      NuClock6.MinuteHand.Brush_Color := ColorDialog1.Color;
End;



Procedure TForm1.Clock6HourColorClick(Sender: TObject);
Begin
   If ColorDialog1.Execute Then
      NuClock6.HourHand.Brush_Color := ColorDialog1.Color;
End;

Procedure TForm1.Clock6BezelColorClick(Sender: TObject);
Begin
   If ColorDialog1.Execute Then
      NuClock6.Bezel.Brush_Color := ColorDialog1.Color;
End;

Procedure TForm1.Clock6AllPensColorClick(Sender: TObject);
//the pens can be individually set if required
Begin
   If ColorDialog1.Execute Then
      With NuClock6 Do
      Begin
         Bezel.Pen_Color := ColorDialog1.Color;
         HourHand.Pen_Color := ColorDialog1.Color;
         MinuteHand.Pen_Color := ColorDialog1.Color;
         SecondHand.Pen_Color := ColorDialog1.Color;
      End
   End;


Procedure TForm1.Clock6HoursLengthChange(Sender: TObject);
Begin
   With Sender As TTrackBar Do
      NuClock6.HourHand.Size:=(Position * 10);
End;

Procedure TForm1.Clock6MinutesLengthChange(Sender: TObject);
Begin
   With Sender As TTrackBar Do
      NuClock6.MinuteHand.Size:=(Position * 10);
End;

Procedure TForm1.Clock6SecondsLengthChange(Sender: TObject);
Begin
   With Sender As TTrackBar Do
      NuClock6.SecondHand.Size:=(Position * 10);
End;

Procedure TForm1.Clock6FaceFontClick(Sender: TObject);
Begin
   If FontDialog1.Execute Then
      NuClock6.Face_Font := FontDialog1.Font;
End;

Procedure TForm1.Clock6ShowNumeralsClick(Sender: TObject);
Begin
   With Sender As TCheckBox Do
      If checked Then NuClock6.Bezel.Style:=bnArabic Else NuClock6.Bezel.Style:=bnNone;
End;

Procedure TForm1.Clock6TickClick(Sender: TObject);
Begin
   With Sender As TCheckBox Do
      If checked Then NuClock6.OnClockTick:=DoClock6Tick Else NuClock6.OnClockTick:=nil;
End;

Procedure TForm1.DoClock6Tick(Sender:TObject);
//a tnotify event to tick the clock

Begin
   messagebeep(0)
End;





//clock7 is the photographic timer
Procedure TForm1.Clock7ResetClick(Sender: TObject);

Begin
   With NuClock7 Do
   Begin
      ClockMode:=cmSlave;//enable clock If disabled
      Offset:=-Now;
      UpdateClock;//zero display by setting time To 0, displayed As 00:00
      ClockMode:=cmManual;
   End;
   Clock7WasReset:=True;
   Clock7Reset.Enabled:=false;
   Clock7Stop.Enabled:=false;
   Clock7Go.Enabled:=true;
   DateTimePicker1.Time:=0;
End;

Procedure TForm1.Clock7GoClick(Sender: TObject);
//start the photographic timer

Begin
   With NuClock7 Do
   Begin
      ClockMode:=cmSlave;
      With NuClock7 Do
         If Clock7WasReset Then
         Offset:= -Now//start display...time=0 equivalent To 00:00
      Else
         Offset:=//start display....time=(time when stopped)
      encodeTime(HandPosition.Hour,HandPosition.Minute,HandPosition.second,0)-now;
      Clock7Reset.Enabled:=true;
      Clock7Stop.Enabled:=true;
      Clock7Go.Enabled:=false;
   End
End;

Procedure TForm1.Clock7StopClick(Sender: TObject);
//freeze the clock at time stopped
Begin
   Clock7WasReset:=False;
   NuClock7.ClockMode:=cmManual;
   Clock7Reset.Enabled:=true;
   Clock7Stop.Enabled:=false;
   Clock7Go.Enabled:=true;
End;

Function TForm1.TimeOf(ATime:TDateTime):TDateTime;
//strip off date info from a TDateTime
Begin
   Result:=Atime-Trunc(Atime)
End;



Procedure TForm1.NuClock7ClockTick(Sender: TObject);

Procedure SoundAlarm;
Var
   i:integer;
Begin
   For i:=0 To 20 Do messagebeep(0);
End;

Begin
   With Sender As TNuClock Do
      If encodeTime(HandPosition.Hour,HandPosition.Minute,HandPosition.second,0)
   >=(TimeOf(DateTimePicker1.Time)-encodetime(0,0,1,0))
   //sound the alarm as second hand moves *onto* alarmed time
   Then
   Begin
      SoundAlarm;
      If Clock7AlarmMode.Checked
      Then
         //for next alarm
         DateTimePicker1.Time:=DateTimePicker1.Time+Clock7AlarmIncrement
      Else
      Begin
         //unset the alarm
         DateTimePicker1.Time:=0;
         OnClockTick:=nil
      End
   End
End;

Procedure TForm1.DateTimePicker1Change(Sender: TObject);
Begin
   With Sender As TDateTimePicker Do
   Begin
      If Time<>0
      Then
         NuClock7.OnClockTick:=NuClock7ClockTick Else NuClock7.OnClockTick:=nil;
      Clock7AlarmIncrement:=TimeOf(DateTimePicker1.Time)
   End
End;





Procedure TForm1.Clock89SwitchClick(Sender: TObject);
//the chess clock is clocks 8 and 9

Procedure ClockGo(AClock:TNuClock;WasReset:boolean);

Begin
   With AClock Do
   Begin
      ClockMode:=cmSlave;
      If WasReset Then
         Offset:= -Now//start display...time=0 equivalent To 00:00
      Else
         Offset:=//start display....time=(time when stopped)
      encodeTime(HandPosition.Hour,HandPosition.Minute,HandPosition.second,0)-now;
   End;
End;

Begin
//NuClock8 is white
   If NuClock8.ClockMode=cmManual
   Then
   Begin
      ClockGo(NuClock8,Clock8WasReset);
      NuClock9.ClockMode:=cmManual;
      Clock9WasReset:=false;
   End
   Else
   Begin
      ClockGo(NuClock9,Clock9WasReset);
      NuClock8.ClockMode:=cmManual;
      Clock8WasReset:=false;
   End
End;




Procedure TForm1.Clock89ResetClick(Sender: TObject);




Procedure ClockReset(AClock:TNuClock);

Begin
   With AClock Do
   Begin
      ClockMode:=cmSlave;//enable clock If disabled
      Offset:=-Now;
      UpdateClock;//zero display by setting time To 0, displayed As 00:00
      ClockMode:=cmManual;
   End;
End;




Begin
   ClockReset(NuClock8);
   ClockReset(NuClock9);
   Clock8WasReset:=True;
   Clock9WasReset:=True;
End;

//clock14 is the one with random color changes
Procedure TForm1.NuClock14ClockTick(Sender: TObject);

Function RandomColor:TColor;

Begin
   result:=RGB(random(255),random(255),random(255))
End;

Var
   NuClock15Position:THandPosition;
Begin
   //do random things to clock face color properties
   With Sender As TNuClock Do
   Begin
      HourHand.Brush_Color:=RandomColor;
      MinuteHand.Brush_Color:=RandomColor;
      SecondHand.Brush_Color:=RandomColor;
      SecondHand.Pen_Color:=RandomColor;
      Bezel.Brush_Color:=RandomColor;
      If random(20)=1 then//subtle shades Of gray for the face
      Face_Color:=RGB(156+random(20),156+random(20),156+random(20));

      //clock15 to display mirror image of clock14, approximately
      With NuClock15Position Do
      Begin
         hour:=60-HandPosition.Hour;
         minute:=60-HandPosition.Minute;
         Second:=60-HandPosition.Second;
      End;
   End;

   //NuClock15 is controlled by NuClock14
   NuClock15.HandPosition:=NuClock15Position;
   //if ClockMode=cmManual the update has to be explicitly called
   NuClock15.UpdateClock;
End;








end.
