unit NTRemoteDateTime;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  PTime_Of_Day_Info = ^TTime_Of_Day_Info;
  TTime_Of_Day_Info = record
    tod_elapsedt  :Integer;
    tod_msecs     :Integer;
    tod_hours     :Integer;
    tod_mins      :Integer;
    tod_secs      :Integer;
    tod_hunds     :Integer;
    tod_timezone  :LongInt;
    tod_tinterval :Integer;
    tod_day       :Integer;
    tod_month     :Integer;
    tod_year      :Integer;
    tod_weekday   :Integer;
  end;

type
  TNTRemoteDateTime = class(TComponent)
  private
    FDateTime   :String;
    FServerName :WideString;
    FElapseDt   :Integer;
    FMSecs      :Integer;
    FHours      :Integer;
    FMins       :Integer;
    FSecs       :Integer;
    FHunds      :Integer;
    FTimeZone   :LongInt;
    FTInterval  :Integer;
    FDay        :Integer;
    FMonth      :Integer;
    FYear       :Integer;
    FWeekDay    :Integer;
    function GetDateTime :String;
  protected
    { Protected declarations }
  public
    Function GetTOD(ServerName :WideString) :Integer;
    property DateTime :String read GetDateTime;
    property ServerName :WideString read FServerName write FServerName;
    property ElapseDt  :Integer read FElapseDt write FElapseDt;
    property MSecs     :Integer read FMSecs write FMSecs;
    property Hours     :Integer read FHours write FHours;
    property Mins      :Integer read FMins write FMins;
    property Secs      :Integer read FSecs write FSecs;
    property Hunds     :Integer read FHunds write FHunds;
    property TimeZone  :LongInt read FTimeZone write FTimeZone;
    property TInterval :Integer read FTInterval write FTInterval;
    property Day       :Integer read FDay write FDay;
    property Month     :Integer read FMonth write FMonth;
    property Year      :Integer read FYear write FYear;
    property WeekDay   :Integer read FWeekDay write FWeekDay;
  published
  end;

  function NetRemoteTOD(ServerName :PWideChar;
                        var buffer :pointer) :Integer; stdcall; external 'netapi32.dll';
  function NetApiBufferFree(buffer : Pointer) :Integer; stdcall; external 'netapi32.dll';


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('LanMan', [TNTRemoteDateTime]);
end;

{ TNTTimeOfDay }

function TNTRemoteDateTime.GetDateTime: String;
var  TheTime  :TDateTime;
     TheDate  :TDateTime;
     TheSTime :String;
     TheSDate :String;
     TheMSecs :Integer;
     Diff     :Integer;
begin

  TheTime := EncodeTime(Word(hours),Word(mins),Word(secs),Word(Hunds));
  TheSTime:=TimeToStr(TheTime);
  TheDate := EncodeDate(Year,Month,Day);
  TheSDate:=DateToStr(TheDate);
  Result:=TheSDate + ' ' + TheSTime;
end;

function TNTRemoteDateTime.GetTOD(ServerName: WideString): Integer;
var Buffer     :pointer;
    Rek        :PTime_Of_Day_Info;
    ADate      :TDateTime;
    ATime      :TDateTime;
    FinalTime  :TDateTime;
    THours,
    TMins,
    TSecs,
    TMSecs     :Word;
    TYear,
    TMonth,
    TDay       :Word;
begin

  result:=NetRemoteTOD(PWideChar(ServerName),
                       Buffer);
  if result=0 then
  begin
    Rek:=PTime_Of_Day_Info(Buffer);
    FServerName :=ServerName;
    FElapseDt   :=Rek.tod_elapsedt;
    FMSecs      :=Rek.tod_msecs;
    FHours      :=Rek.tod_hours;
    FMins       :=Rek.tod_mins;
    FSecs       :=Rek.tod_secs;
    FHunds      :=Rek.tod_hunds;
    FTInterval  :=Rek.tod_tinterval;

    If Rek.tod_timezone <> -1 then
    begin
      FTimeZone:=Rek.tod_timezone div 60;
    end
    else
      FTimeZone:=0;

    FDay        :=Rek.tod_day;
    FMonth      :=Rek.tod_month;
    FYear       :=Rek.tod_year;
    FWeekDay    :=Rek.tod_weekday;

    ADate:=EncodeDate(FYear, FMonth, FDay);
    ATime:=EnCodeTime(FHours, FMins, FSecs, FHunds);

    FinalTime:=StrToDateTime(DateTimeToStr(ADate) + ' ' + TimeToStr(ATime));
    FinalTime:=FinalTime - (FTimeZone / 24);

    decodetime(FinalTime,THours, TMins,TSecs, TSecs);

    FHours:=Integer(THours);

    decodeDate(FinalTime,TYear, TMonth,TDay);
    FYear:=Integer(TYear);
    FMonth:=Integer(TMonth);
    FDay:=Integer(TDay);

  end;
  NetApiBufferFree(Buffer);
end;

end.
