unit MainTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  NCHSGraph, StdCtrls, ExtCtrls, Buttons;


type
  TForm1 = class(TForm)
    Button1: TButton;
    NCHSGraph1: TNCHSGraph;
    ComboBox1: TComboBox;
    Label1: TLabel;
    RadioGroup1: TRadioGroup;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    Label4: TLabel;
    Edit3: TEdit;
    Button2: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
with nchsgraph1 do begin
     combobox1.itemindex:=2;
     radiogroup1.itemindex:=1;
     EvaluationType:=WeightforAge;
     sex:=Girl;
     values.clear;
     values.add('3'+#9+'8');
     values.add('5'+#9+'10');
     values.add('7'+#9+'12');
     values.add('17'+#9+'13');
     drawline;
     end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
combobox1.itemindex:=2;
radiogroup1.itemindex:=0;
label2.caption:='Age (months):';
label3.caption:='Weight (kg):';
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
case combobox1.itemindex of
     0:Begin
       nchsgraph1.EvaluationType:=LengthforAge;
       label2.caption:='Age (months):';
       label3.caption:='Length (cm):';
       end;
     1:Begin
       nchsgraph1.EvaluationType:=StatureforAge;
       label2.caption:='Age (months):';
       label3.caption:='Stature (cm):';
       end;
     2:Begin
       nchsgraph1.EvaluationType:=WeightforAge;
       label2.caption:='Age (months):';
       label3.caption:='Weight (kg):';
       end;
     3:Begin
       nchsgraph1.EvaluationType:=WeightforLength;
       label2.caption:='Length (cm):';
       label3.caption:='Weight (kg):';
       end;
     4:Begin
       nchsgraph1.EvaluationType:=WeightforStature;
       label2.caption:='Stature (cm):';
       label3.caption:='Weight (kg):';
       end;
     end;{case}
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
if radiogroup1.itemindex=0 then nchsgraph1.sex:=Boy
                           else nchsgraph1.sex:=Girl;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var first,second,z:single;
begin
try first:=strtofloat(edit1.text)
    except on EConvertError do begin
           showmessage('Please give valid value');
           edit1.setfocus;
           exit;
           end;
    end;{try}
try second:=strtofloat(edit2.text)
    except on EConvertError do begin
           showmessage('Please give valid value');
           edit2.setfocus;
           exit;
           end;
    end;{try}
nchsgraph1.values.add(edit1.text+#9+edit2.text);
nchsgraph1.drawline;
case combobox1.itemindex of
     0:Begin
       if radiogroup1.itemindex=0 then z:=nchsgraph1.ZScore(LengthForAge,Boy,first,second)
                                  else z:=nchsgraph1.ZScore(LengthForAge,Girl,first,second)
       end;
     1:Begin
       if radiogroup1.itemindex=0 then z:=nchsgraph1.ZScore(StatureForAge,Boy,first,second)
                                  else z:=nchsgraph1.ZScore(StatureForAge,Girl,first,second)
       end;
     2:Begin
       if radiogroup1.itemindex=0 then z:=nchsgraph1.ZScore(WeightForAge,Boy,first,second)
                                  else z:=nchsgraph1.ZScore(WeightForAge,Girl,first,second)
       end;
     3:Begin
       if radiogroup1.itemindex=0 then z:=nchsgraph1.ZScore(WeightforLength,Boy,first,second)
                                  else z:=nchsgraph1.ZScore(WeightforLength,Girl,first,second)
       end;
     4:Begin
       if radiogroup1.itemindex=0 then z:=nchsgraph1.ZScore(WeightforStature,Boy,first,second)
                                  else z:=nchsgraph1.ZScore(WeightforStature,Girl,first,second)
       end;
     end;{case}
edit3.text:=formatfloat('0.000',z);
end;

function getbirthdate(str:String):TDateTime;
var txt:string;
Begin
delete(str,1,pos(#9,str));
txt:=copy(str,1,pos(#9,str)-1);
try result:=strtodate(txt)
    except on EConvertError do result:=0;
    end;{try}
end;

function getweight(str:String):single;
var txt:string;
Begin
delete(str,1,pos(#9,str));
delete(str,1,pos(#9,str));
txt:=copy(str,1,pos(#9,str)-1);
try result:=strtofloat(txt)
    except on EConvertError do result:=-1;
    end;{try}
end;

function getstature(str:String):single;
var txt:string;
Begin
delete(str,1,pos(#9,str));
delete(str,1,pos(#9,str));
delete(str,1,pos(#9,str));
txt:=copy(str,1,pos(#9,str)-1);
try result:=strtofloat(txt)
    except on EConvertError do result:=-1;
    end;{try}
end;

function getsex(str:String):Boolean;
var txt:string;
Begin
delete(str,1,pos(#9,str));
delete(str,1,pos(#9,str));
delete(str,1,pos(#9,str));
delete(str,1,pos(#9,str));
txt:=str;
if comparestr(txt,'m')=0 then result:=true
                         else result:=false;
end;


procedure TForm1.Button2Click(Sender: TObject);
var f,g:textfile;
    txt,txt1:string;
    studydate:TDateTime;
    Age,Weight,Stature:single;
    Sex:Boolean;
begin
if not fileexists('kids.txt') then begin
   showmessage('Sorry, can''t run this demo, file "kids.txt" is missing');
   exit;
   end;
studydate:=strtodate('01/03/1997');
assignfile(f,'kids.txt');
reset(f);
assignfile(g,'kids-z.txt');
rewrite(g);
readln(f,txt);{Columnnames}
writeln(g,txt+#9+'Age'+#9+'WFA-Z'+#9+'SFA-Z'+#9+'WFL-Z');
while not eof(f) do begin
 readln(f,txt);
 txt1:=txt+#9;
 age:=(studydate-getbirthdate(txt))/30;
 txt1:=txt1+formatfloat('0.0',age)+#9;
 weight:=getweight(txt);
 stature:=getstature(txt);
 sex:=getsex(txt);
 if weight=-1 then txt1:=txt1+'-'+#9
              else begin
                   if sex then txt1:=txt1+formatfloat('0.000',nchsgraph1.ZScore(WeightForAge,Boy,age,weight))+#9
                          else txt1:=txt1+formatfloat('0.000',nchsgraph1.ZScore(WeightForAge,Girl,age,weight))+#9;
                   end;
 if stature=-1 then txt1:=txt1+'-'+#9
              else begin
                   if sex then txt1:=txt1+formatfloat('0.000',nchsgraph1.ZScore(StatureForAge,Boy,age,stature))+#9
                          else txt1:=txt1+formatfloat('0.000',nchsgraph1.ZScore(StatureForAge,Girl,age,stature))+#9;
                   end;
 if (stature=-1) or (weight=-1) then txt1:=txt1+'-'
                    else begin
                         if sex then txt1:=txt1+formatfloat('0.000',nchsgraph1.ZScore(WeightForLength,Boy,stature,weight))
                                else txt1:=txt1+formatfloat('0.000',nchsgraph1.ZScore(WeightForLength,Girl,stature,weight));
                         end;
 writeln(g,txt1);
 end;
closefile(f);
closefile(g);
showmessage('Data processed, results in file kids-z.txt');
end;

end.
