unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, NccLED, StdCtrls, Buttons, ComCtrls, ExtDlgs;

type
  TForm1 = class(TForm)
    NccLED1: TNccLED;
    Edit1: TEdit;
    Label1: TLabel;
    ScrollBtn: TBitBtn;
    Edit2: TEdit;
    Edit3: TEdit;
    UpDown1: TUpDown;
    UpDown2: TUpDown;
    Label2: TLabel;
    Label3: TLabel;
    OpenPictureDialog1: TOpenPictureDialog;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    FontDialog1: TFontDialog;
    ColorDialog1: TColorDialog;
    BitBtn5: TBitBtn;
    CheckBox1: TCheckBox;
    Edit4: TEdit;
    UpDown3: TUpDown;
    Label4: TLabel;
    WidthEdit: TEdit;
    WidthNum: TUpDown;
    Label5: TLabel;
    HeightEdit: TEdit;
    HeightNum: TUpDown;
    Label6: TLabel;
    ComboBox1: TComboBox;
    Label7: TLabel;
    Label8: TLabel;
    Edit5: TEdit;
    SpeedNum: TUpDown;
    Label9: TLabel;
    Edit6: TEdit;
    StepNum: TUpDown;
    NccLED2: TNccLED;
    procedure ScrollBtnClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WidthEditChange(Sender: TObject);
    procedure HeightEditChange(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ScrollBtnClick(Sender: TObject);
begin
     NccLED1.Scroll := not NccLED1.Scroll;
     if NccLED1.Scroll then
          ScrollBtn.Caption := 'Stop'
     else ScrollBtn.Caption := 'Scroll';
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
     NccLED1.Text := Edit1.Text;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
     NccLED1.DotSize := UpDown1.Position;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
     NccLED1.DotSpace := UpDown2.Position;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
     with OpenPictureDialog1 do
          if Execute then
             NccLED1.Picture.LoadFromFile(FileName);
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
     with FontDialog1 do
          if Execute then
             NccLED1.Font.Assign(Font);
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
     with ColorDialog1 do
          if Execute then
             NccLED1.EnabledDotColor := Color;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
     NccLED1.AutoSize := CheckBox1.Checked;
end;

procedure TForm1.Edit4Change(Sender: TObject);
begin
     NccLED1.TextBorderWidth := UpDown3.Position;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     WidthNum.Position := NccLED1.Width;
     HeightNum.Position := NccLED1.Height;
     ComboBox1.ItemIndex := 1;
end;

procedure TForm1.WidthEditChange(Sender: TObject);
begin
     NccLED1.Width := WidthNum.Position;
end;

procedure TForm1.HeightEditChange(Sender: TObject);
begin
     NccLED1.Height := HeightNum.Position;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
     case ComboBox1.ItemIndex of
          0: NccLED1.ScrollMode := smNone;
          1: NccLED1.ScrollMode := smLeftToRight;
          2: NccLED1.ScrollMode := smRightToLeft;
          3: NccLED1.ScrollMode := smTopToBottom;
          4: NccLED1.ScrollMode := smBottomToTop;
          5: NccLED1.ScrollMode := smFlash;
     end;
end;

procedure TForm1.Edit5Change(Sender: TObject);
begin
     NccLED1.Speed := SpeedNum.Position;
end;

procedure TForm1.Edit6Change(Sender: TObject);
begin
     NccLED1.MoveStep := StepNum.Position;
end;

end.
