unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Winsock, StdCtrls, ExtCtrls, Menus ,clipbrd;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    Exit1: TMenuItem;
    Label1: TLabel;
    Copy1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
   procedure formmousedown(sender: tobject; button: tmousebutton;
                                    shift: tshiftstate; x, y: integer);
    procedure Edit1StartDrag(Sender: TObject; var DragObject: TDragObject);
    procedure Copy1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// returns ISP assigned IP
function LocalIP : string;
type
    TaPInAddr = array [0..10] of PInAddr;
    PaPInAddr = ^TaPInAddr;
var
    phe  : PHostEnt;
    pptr : PaPInAddr;
    Buffer : array [0..63] of char;
    I    : Integer;
    GInitData      : TWSADATA;

begin
    WSAStartup($101, GInitData);
    Result := '';
    GetHostName(Buffer, SizeOf(Buffer));
    phe :=GetHostByName(buffer);
    if phe = nil then Exit;
    pptr := PaPInAddr(Phe^.h_addr_list);
    I := 0;
    while pptr^[I] <> nil do begin
      result:=StrPas(inet_ntoa(pptr^[I]^));
      Inc(I);
    end;
    WSACleanup;
end;

{subject : moving forms (and other twincontrols) without using the caption-bar}

procedure tForm1.formmousedown(sender: tobject; button: tmousebutton;
                                    shift: tshiftstate; x, y: integer);
const
  sc_dragmove = $f012;
begin
  releasecapture;
  twincontrol(application.mainform).perform(wm_syscommand,sc_dragmove, 0);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  FullRgn, ClientRgn, ButtonRgn: THandle;
  Margin, X, Y: Integer;
  r:boolean;
begin
  top:=screen.Height-50;
  left:=screen.width-120;
  height:=Label1.Height;
  width:=Label1.width;
  Margin := (Width - ClientWidth) div 2;
  FullRgn := CreateRectRgn(0, 0, Width, Height);
  X := Margin;
  Y := Height - ClientHeight - Margin;
  ClientRgn := CreateRectRgn(X, Y, X + ClientWidth, Y + ClientHeight);
  CombineRgn(FullRgn, FullRgn, ClientRgn, RGN_DIFF);
  X := X + Label1.Left;
  Y := Y + Label1.Top;
  ButtonRgn := CreateRectRgn(X, Y, X + Label1.Width, Y + Label1.Height);
  CombineRgn(FullRgn, FullRgn, ButtonRgn, RGN_OR);
  SetWindowRgn(Handle, FullRgn, True);
  //Hide Taskbar Icon
  ShowWindow( Application.Handle, SW_HIDE );
  SetWindowLong( Application.Handle, GWL_EXSTYLE,
                 GetWindowLong(Application.Handle, GWL_EXSTYLE) or
                 WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW);
  ShowWindow( Application.Handle, SW_SHOW );
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Timer1.interval:=1000*100;
  Label1.Caption:='IP: '+LocalIP;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  application.terminate;
end;

procedure TForm1.Edit1StartDrag(Sender: TObject;
  var DragObject: TDragObject);
const
  sc_dragmove = $f012;
begin
  releasecapture;
  twincontrol(application.mainform).perform(wm_syscommand,sc_dragmove, 0);

end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  Clipboard.SetTextBuf(Pchar(copy(Label1.caption,4,255)));
end;

end.



