unit mwidevmt;
{
  Vcl IdeVmt Expert

  Author:  Martin_Waldenburg
  Created: 10.97
  The routines to access the VMT are 
  from the book " Secrets of Delphi 2 "
  by Ray Lischner.
  In my opinion the best Delphi book.
  Secret30.dpl needed.

  It's provided as is, expressly without
  a warranty of any kind.
  You use it at your own risc.
}

interface

uses SysUtils,
  Classes,
  Messages,
  Consts,
  Forms,
  Windows,
  Dialogs,
  ClipBrd,
  Controls,
  EditIntf,
  ExptIntf,
  ToolIntf,
  ExtCtrls,
  Menus,
  comCtrls,
  StdCtrls,
  LibIntf,
  TypInfo,
  WinTypes,
  S_Vmt;

type
  TfrmIdeVmt = class(TForm)
    Memo1: TMemo;
    TreeView1: TTreeView;
    Splitter1: TSplitter;
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure FormShow(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
  private
    { private declarations }
  protected
    { protected declarations }
  public
    { public declarations }
  published
    { published declarations }
  end;

  TIdeVmtExpert = class(TIExpert)
  private
    MenuItem: TIMenuItemIntf;
  protected
    procedure OnClick( Sender: TIMenuItemIntf); virtual;
  public
    constructor Create; virtual;
    destructor Destroy; override;
    function GetName: string; override;
    function GetAuthor: string; override;
    function GetStyle: TExpertStyle; override;
    function GetIDString: string; override;
  published
    { published declarations }
  end;

procedure Register;

var
  frmIdeVmt: TfrmIdeVmt;
  TopNode, Level1Child, Level2Child, Level3Child, Level4Child: TTreenode;

implementation

{$R *.DFM}

uses
  S_IO, VmtInfo;

  procedure Register;
begin
  RegisterLibraryExpert(TIdeVmtExpert.Create);
end;

{ TIdeVmtExpert code }
function TIdeVmtExpert.GetName: String;
begin
  Result := 'IdeVmtExpert'
end;

function TIdeVmtExpert.GetAuthor: String;
begin
  Result := 'Martin_Waldenburg'; { author }
end;

function TIdeVmtExpert.GetStyle: TExpertStyle;
begin
  Result := esAddIn;
end;

function TIdeVmtExpert.GetIDString: String;
begin
  Result := 'private.IdeVmtExpert';
end;

constructor TIdeVmtExpert.Create;
var
  Main: TIMainMenuIntf;
  ReferenceMenuItem: TIMenuItemIntf;
  Menu: TIMenuItemIntf;
begin
  inherited Create;
  MenuItem := nil;
  if ToolServices <> nil then begin { I'm an expert! }
    Main := ToolServices.GetMainMenu;
    if Main <> nil then begin { we've got the main menu! }
      try 
        { add the menu of your choice }
        ReferenceMenuItem := Main.FindMenuItem('ToolsOptionsItem');
        if ReferenceMenuItem <> nil then
        try
          Menu := ReferenceMenuItem.GetParent;
          if Menu <> nil then
          try
            MenuItem := Menu.InsertItem(ReferenceMenuItem.GetIndex+1,
                              'IdeVmt',
                              'IdeVmtExpertItem','',
                              0,0,0,
                              [mfEnabled, mfVisible], OnClick);
          finally
            Menu.DestroyMenuItem;
          end;
        finally
          ReferenceMenuItem.DestroyMenuItem;
        end;
      finally
        Main.Free;
      end;
    end;
  end;
end;

destructor TIdeVmtExpert.Destroy;
begin
  if MenuItem <> nil then
    MenuItem.DestroyMenuItem;
  if Assigned(frmIdeVmt) then
    frmIdeVmt.Free;
  inherited Destroy;
end;{Destroy}

procedure TIdeVmtExpert.OnClick( Sender: TIMenuItemIntf);
begin
  if not Assigned(frmIdeVmt) then
    frmIdeVmt := TfrmIdeVmt.Create(nil);
  frmIdeVmt.Show;
  frmIdeVmt.SetFocus
end;


function AddType(aNode: TTreeNode; Name: String; Info: PTypeInfo; aComponent:TComponent): TTreeNode;
begin
  Result:= frmIdeVmt.TreeView1.Items.AddChild(aNode, Name + ': ' + Info^.Name);
  Result.Data:= aComponent;
end;

Function LookupStuff : Boolean;
Var
  i, j, k, l: Integer;
Begin
  frmIdeVmt.TreeView1.items.clear;
  TopNode:=
    AddType(
      nil,
      Application.Name,
      Application.ClassInfo,
      Application);
  frmIdeVmt.Memo1.Clear;
  Try
  for i:=0 to Application.ComponentCount-1 do
    Begin
      Level1Child:=
        AddType(
          TopNode,
          Application.Components[i].Name,
          Application.Components[i].ClassInfo,
          Application.Components[i]);
      for j:=0 to Application.Components[i].ComponentCount-1 do
        begin
          Level2Child:=
            AddType(
              Level1Child,
              Application.Components[i].Components[j].Name,
              Application.Components[i].Components[j].ClassInfo,
              Application.Components[i].Components[j]);
          for k:=0 to Application.Components[i].Components[j].ComponentCount-1 do
            begin
              Level3Child:=
                AddType(
                  Level2Child,
                  Application.Components[i].Components[j].Components[k].Name,
                  Application.Components[i].Components[j].Components[k].ClassInfo,
                  Application.Components[i].Components[j].Components[k]);
              for l:=0 to Application.Components[i].Components[j].Components[k].ComponentCount-1 do
                begin
                  Level4Child:=
                    AddType(
                      Level3Child,
                      Application.Components[i].Components[j].Components[k].Components[l].Name,
                      Application.Components[i].Components[j].Components[k].Components[l].ClassInfo,
                      Application.Components[i].Components[j].Components[k].Components[l]);
                end;
            end;
        end;
      End;
  finally
  End;
End;
{ TfrmIdeVmt code }

procedure TfrmIdeVmt.TreeView1Change(Sender: TObject; Node: TTreeNode);
var
  Vmt: PVmt;
  aClass: TClass;
begin
  aClass:= TComponent(Node.Data).ClassType;
  Rewrite(Output);
  try
    Memo1.Lines.BeginUpdate;
    try
      Vmt:= GetVmt(aClass);
      while Vmt <> nil do
      begin
        WriteVmtInfo(aClass);
        Vmt:= GetVmt(GetParentClass(Vmt));
        aClass:= VmtToClass(Vmt);
        writeln(output, '');
        writeln(output, 'ParentClass:');
        writeln(output, '');
      end;
    finally
      Memo1.Lines.EndUpdate;
      aClass:= nil;
      Vmt:= nil;
    end;
  finally
    CloseFile(Output);
  end;
end;

procedure TfrmIdeVmt.FormShow(Sender: TObject);
begin
  AssignStrings(Output, Memo1.Lines);
  Memo1.Clear;
  TreeView1.Items.BeginUpdate;
  LookupStuff;
  TreeView1.Items.EndUpdate;
end;

procedure TfrmIdeVmt.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  Node.Data:= nil;
end;

end.
