unit MSSQLLib;

interface

uses Windows;

const
  DBSETHOST        = 1;
  DBSETUSER        = 2;
  DBSETPWD         = 3;
  DBSETAPP         = 4;
  DBSETID          = 5;
  DBSETLANG        = 6;

  DBNOERR          = -1;
  DBFAIL           =  0;
  DBSUCCEED        =  1;
  NO_MORE_RESULTS  =  2;

  (* dbBind Datentypen                                                  *)
  TINYBIND	   =  1;
  SMALLBIND        =  2;
  INTBIND          =  3;
  CHARBIND         =  4;
  BINARYBIND       =  5;
  DATETIMEBIND     =  7;
  STRINGBIND       = 10;
  NTBSTRINGBIND    = 11;
  VARYCHARBIND     = 12;
  VARYBINBIND      = 13;


  MORE_ROWS        = -1;
  REG_ROW          = MORE_ROWS;
  NO_MORE_ROWS     = -2;
  BUF_FULL         = -3;

  DBRPCRETURN      = 1;

  SQLTEXT          = $23;
  SQLVARBINARY     = $25;
  SQLVARCHAR       = $27;
  SQLBINARY        = $2d;
  SQLIMAGE         = $22;
  SQLCHAR          = $2f;
  SQLINT1          = $30;
  SQLINT2          = $34;
  SQLINT4          = $38;
  SQLINTN          = $26;
  SQLDATETIME      = $3d;
  SQLFLT8          = $3e;
  SQLFLTN          = $6d;
  SQLMONEYN        = $6e;
  SQLDATETIMN      = $6f;

  (* Fehlerlevels im Error-Handler                                      *)
  EXINFO           =  1;                    (* informational, non-error *)
  EXUSER           =  2;                                  (* user error *)
  EXNONFATAL       =  3;                             (* non-fatal error *)
  EXCONVERSION     =  4;        (* Error in DB-LIBRARY data conversion. *)
  EXSERVER         =  5;      (* The Server has returned an error flag. *)
  EXTIME           =  6;   (* We have exceeded our timeout period while *)
                           (* waiting for a response from the Server -  *)
                           (* the DBPROCESS is still alive.             *)
  EXPROGRAM        =  7;                (* coding error in user program *)
  EXRESOURCE       =  8;    (* running out of resources - the DBPROCESS *)
                            (* may be dead.                             *)
  EXCOMM           =  9;      (* failure in communication with Server - *)
                              (* the DBPROCESS is dead.                 *)
  EXFATAL          = 10;        (* fatal error - the DBPROCESS is dead. *)
  EXCONSISTENCY    = 11;         (* internal software error - notify MS *)
				 (* Technical Support.                  *)

  (* Fehlerrueckgabewerte des Error-Handles                             *)
  INT_EXIT         = 0;
  INT_CONTINUE     = 1;
  INT_CANCEL       = 2;

type
  PLOGINREC        = Pointer;
  PDBPROCESS       = Pointer;
  PDBCURSOR        = Pointer;
  RETCODE          = Integer;
  LPINT            = ^Integer;
  LPBYTE           = ^BYTE;
  LPDBINT          = ^Integer;
  DBINT            = Integer;

  PDBINTArray      = ^TDBINTArray;
  TDBINTArray      = array[0..0] of DBINT;

  PDBMsgHandler    = ^TDBMsgHandler;
  TDBMsgHandler    = function (DBProc    : Pointer;
                               MsgNo     : Integer;
                               MsgStarte : Integer;
                               Severity  : Integer;
                               MsgText   : PChar;
                               SrvName   : PChar;
                               ProcName  : PChar;
                               LineNr    : SmallInt) : Integer; stdcall;

  PDBErrHandler    = ^TDBErrHandler;
  TDBErrHandler    = function (DBProc    : Pointer;
                               Severity  : Integer;
                               DBError   : Integer;
                               OSError   : Integer;
                               DBErrStr  : PChar;
                               OSErrStr  : PChar) : Integer; stdcall;

  PDBCursorInfo    = ^TDBCursorInfo;
  TDBCursorInfo    = record
    SizeOfStruct     : DBINT;               (* Groesse dieser Strucktur *)
    TotCols          : ULONG;  (* Anzahl der Spalten des SQL-Statements *)
    TotRows          : ULONG;   (* Anzahl der Zeilen des SQL-Statements *)
    CurRow           : ULONG;     (* Aktuelle Position, 1 ist die erste *)
    TotRowsFetched   : ULONG;      (* Anzahl der Zeilen im Fetch-Buffer *)
    CursorType       : ULONG;          (* Cursortyp, siehe dbcursoropen *)
    Status           : ULONG;                (* Status des Cursors, ??? *)
  end;

(* Setzen der Meldung- und Fehlercallbacks. Einzige Moeglichkeit an die *)
(* aufgetretenen Fehler zu kommen.                                      *)
function  dberrhandle(Handler : TDBErrHandler) : TDBErrHandler; cdecl;
function  dbmsghandle(Handler : TDBMsgHandler) : TDBMsgHandler; cdecl;

(* Library-Funktionen                                                   *)
function  dbinit: PChar; cdecl;
function  dbsetlogintime(Seconds : Integer) : RETCODE; cdecl;
function  dbsettime(Seconds : Integer) : RETCODE; cdecl;
function  dblogin: PLOGINREC; cdecl;
function  dbsetlname(login : PLOGINREC;
                     val   : PChar;
                     item  : Integer): Integer; cdecl;
procedure dbfreelogin(login: PLOGINREC); cdecl;
procedure dbexit; cdecl;

function  dbopen(login: PLOGINREC; ServerName: PChar): PDBPROCESS; cdecl;
function  dbtabcount(dbproc : PDBPROCESS) : Integer; cdecl;
function  dbtabname(dbproc : PDBPROCESS; table : Integer) : PChar; cdecl;
procedure dbclose(proc: PDBPROCESS); cdecl;

function  dbcmd(proc: PDBPROCESS; cmd: PChar): Integer; cdecl;
function  dbsqlexec(proc: PDBPROCESS) : Integer; cdecl;
function  dbresults(proc: PDBPROCESS) : RETCODE; cdecl;
function  dbnumcols(proc : PDBPROCESS) : Integer; cdecl;
function  dbdead(dbproc : PDBPROCESS) : Bool; cdecl;
function  dbcanquery(proc: PDBPROCESS) : RETCODE; cdecl;
function  dbcancel(proc: PDBPROCESS) : RETCODE; cdecl;
function  dbcollen(proc   : PDBPROCESS;
                   Column : Integer) : Integer; cdecl;
function  dbcolname(proc   : PDBPROCESS;
                    Column : Integer) : PChar; cdecl;
function  dbbind(proc                    : PDBPROCESS;
                 Column, VarType, VarLen : Integer;
                 VarAddr                 : Pointer) : Integer; cdecl;
function  dbnextrow(proc: PDBPROCESS): Integer; cdecl;
function  dbdata(proc: PDBPROCESS; column: Integer): Pointer; cdecl;
function  dbdatlen(proc: PDBPROCESS; column: Integer): Integer; cdecl;
function  dbrpcinit(proc     : PDBPROCESS;
                    ProcName : PChar;
                    Options  : Integer): Integer; cdecl;
function  dbrpcparam(proc            : PDBPROCESS;
                     paramname       : PChar;
                     status          : Byte;
                     ptype           : Integer;
                     maxlen, datalen : Integer;
                     value           : Pointer): Integer; cdecl;
function  dbrpcsend(proc: PDBPROCESS): Integer; cdecl;
function  dbsqlok(proc: PDBPROCESS): Integer; cdecl;
function  dbretdata(proc: PDBPROCESS; column: Integer): Pointer; cdecl;
function  dbrpcexec(proc: PDBPROCESS): Integer; cdecl;
function  dbuse(proc: PDBPROCESS; DBName: PChar): Integer; cdecl;
function  dbcurrow(proc: PDBPROCESS) : DBINT; cdecl;

(* Two-Phase-Commit Funktionen                                          *)
function  open_commit(Login   : PLOGINREC;
                      AppName : PChar) : PDBPROCESS; cdecl;
procedure close_commit(dbproc : PDBPROCESS); cdecl;
procedure build_xact_string(XActName    : PChar;
                            ServiceName : PCHAR;
                            CommID      : DBINT;
                            Result      : PChar); cdecl;
function  start_xact(dbproc    : PDBPROCESS;
                     AppName   : PChar;
                     XActName  : PChar;
                     SiteCount : DBINT) : Integer; cdecl;
function  commit_xact(dbproc : PDBPROCESS;
                      CommID : DBINT) : RETCODE; cdecl;
function  abort_xact(dbproc : PDBPROCESS; CommID : DBINT) : RETCODE; cdecl;
function  remove_xact(dbproc    : PDBPROCESS;
                      CommID    : DBINT;
                      SiteCount : Integer) : RETCODE; cdecl;
function  scan_xact(dbproc : PDBPROCESS; CommID : DBINT) : RETCODE; cdecl;
function  stat_xact(dbproc : PDBPROCESS; CommID : DBINT) : Integer; cdecl;

(* Transparent/Explicit Cursor functions                                *)
const
  CUR_READONLY     = 1;    (* Read only cursor, no data modifications   *)
  CUR_LOCKCC       = 2;    (* Intent to update, all fetched data locked *)
                           (* when dbcursorfetch is called inside a     *)
                           (* transaction block.                        *)
  CUR_OPTCC        = 3;	   (* Optimistic concurrency control, data      *)
			   (* modifications succeed only if the row     *)
                           (* hasn't been updated since the last fetch  *)
  CUR_OPTCCVAL     = 4;    (* Optimistic concurrency control based on   *)
                           (* selected column values                    *)


  CUR_FORWARD	   =  0;                      (* Forward only scrolling *)
  CUR_KEYSET	   = -1;                     (* Keyset driven scrolling *)
  CUR_DYNAMIC	   =  1;                               (* Fully dynamic *)

type
  TCursorWalk      = (
                       FETCH_NOT_USED,                             (* 0 *)
                       FETCH_FIRST,                                (* 1 *)
                       FETCH_NEXT,                                 (* 2 *)
                       FETCH_PREV,                                 (* 3 *)
                       FETCH_RANDOM,                               (* 4 *)
                       FETCH_RELATIVE,                             (* 5 *)
                       FETCH_LAST                                  (* 6 *)
                     );

const
  FTC_SUCCEED      = 1;         (* Fetch succeeded, (failed if not set) *)
  FTC_MISSING      = 2;                           (* The row is missing *)
  FTC_ENDOFKEYSET  = 4;                    (* End of the keyset reached *)
  FTC_ENDOFRESULTS = 8;                   (* End of results set reached *)

(* Following flags define the operator types for the dbcursor function  *)
  CRS_UPDATE       = 1;                             (* Update operation *)
  CRS_DELETE       = 2;                             (* Delete operation *)
  CRS_INSERT       = 3;                             (* Insert operation *)
  CRS_REFRESH      = 4;                            (* Refetch given row *)
  CRS_LOCKCC       = 5; (* Lock given row, if only inside a transaction *)


function dbcursoropen(DBProc    : PDBPROCESS;
                      SQL       : PChar;
                      ScrollOpt : Integer;
                      ConcurOpt : Integer;
                      NRows     : Integer;
                      PStatus   : LPDBINT) : PDBCURSOR; cdecl;

function dbcursor(hCursor : PDBCURSOR;
                  OPType  : Integer;
                  Row     : Integer;
                  Table   : LPCSTR;
                  Values  : LPCSTR) : RETCODE;

function dbcursorinfo(hCursor : PDBCursor;
                      NCols   : LPINT;
                      NRows   : LPDBINT) : RETCODE; cdecl;

function dbcursorinfoex(hCursor : PDBCURSOR;
                        Info    : PDBCURSORINFO) : RETCODE; cdecl;

function dbcursorcolinfo(hCursor  : PDBCursor;
                         Column   : Integer;
                         ColName  : LPSTR;
                         ColType  : LPINT;
                         ColLen   : LPDBINT;
                         UserType : LPINT) : RETCODE; cdecl;

function dbcursorbind(hCursor  : PDBCursor;
                      Col      : Integer;
                      VarType  : Integer;
                      VarLen   : Integer;
                      POutLen  : LPDBINT;
                      PVarAddr : PCHAR) : RETCODE; cdecl;

function dbcursorfetch(hCursor   : PDBCursor;
                       FetchType : TCursorWalk;
                       RowNum    : Integer) : RETCODE; cdecl;

function dbcursorfetchex(hCursor   : PDBCursor;
                         FetchType : TCursorWalk;
                         RowNum    : Integer;
                         NRows     : Integer;
                         Unknown   : Integer) : RETCODE; cdecl;

function dbcursorclose(hCursor : PDBCURSOR) : RETCODE; cdecl;

implementation

function  dberrhandle;       external 'ntwdblib.dll';
function  dbmsghandle;       external 'ntwdblib.dll';
function  dbsetlogintime;    external 'ntwdblib.dll';
function  dbsettime;         external 'ntwdblib.dll';
function  dblogin;           external 'ntwdblib.dll';
function  dbopen;            external 'ntwdblib.dll';
function  dbinit;            external 'ntwdblib.dll';
procedure dbexit;            external 'ntwdblib.dll';
function  dbsetlname;        external 'ntwdblib.dll';
procedure dbfreelogin;       external 'ntwdblib.dll';
function  dbtabcount;        external 'ntwdblib.dll';
function  dbtabname;         external 'ntwdblib.dll';
procedure dbclose;           external 'ntwdblib.dll';
function  dbcmd;             external 'ntwdblib.dll';
function  dbsqlexec;         external 'ntwdblib.dll';
function  dbresults;         external 'ntwdblib.dll';
function  dbnumcols;         external 'ntwdblib.dll';
function  dbdead;            external 'ntwdblib.dll';
function  dbcanquery;        external 'ntwdblib.dll';
function  dbcancel;          external 'ntwdblib.dll';
function  dbcollen;          external 'ntwdblib.dll';
function  dbcolname;         external 'ntwdblib.dll';
function  dbbind;            external 'ntwdblib.dll';
function  dbnextrow;         external 'ntwdblib.dll';
function  dbdata;            external 'ntwdblib.dll';
function  dbdatlen;          external 'ntwdblib.dll';
function  dbrpcinit;         external 'ntwdblib.dll';
function  dbrpcparam;        external 'ntwdblib.dll';
function  dbrpcsend;         external 'ntwdblib.dll';
function  dbsqlok;           external 'ntwdblib.dll';
function  dbretdata;         external 'ntwdblib.dll';
function  dbrpcexec;         external 'ntwdblib.dll';
function  dbuse;             external 'ntwdblib.dll';
function  dbcurrow;          external 'ntwdblib.dll';

(* Two-Phase-Commit Funktionen                                          *)
function  open_commit;       external 'ntwdblib.dll';
procedure close_commit;      external 'ntwdblib.dll';
procedure build_xact_string; external 'ntwdblib.dll';
function  start_xact;        external 'ntwdblib.dll';
function  commit_xact;       external 'ntwdblib.dll';
function  abort_xact;        external 'ntwdblib.dll';
function  remove_xact;       external 'ntwdblib.dll';
function  scan_xact;         external 'ntwdblib.dll';
function  stat_xact;         external 'ntwdblib.dll';

(* Transparent/Explicit Cursor functions                                *)
function  dbcursoropen;      external 'ntwdblib.dll';
function  dbcursor;          external 'ntwdblib.dll';
function  dbcursorinfo;      external 'ntwdblib.dll';
function  dbcursorinfoex;    external 'ntwdblib.dll';
function  dbcursorcolinfo;   external 'ntwdblib.dll';
function  dbcursorbind;      external 'ntwdblib.dll';
function  dbcursorfetch;     external 'ntwdblib.dll';
function  dbcursorfetchex;   external 'ntwdblib.dll';
function  dbcursorclose;     external 'ntwdblib.dll';

end.
