unit LogFiles;

interface

uses Windows,
     SysUtils,
     Classes,
     FileCtrl;

type
  TLogLevel        = (
                       llErrorOnly,
                       llNone,
                       llLow,
                       llMed,
                       llHigh
                     );  


procedure SetOptions(aPrefix : String; aDaily : Boolean);
procedure OpenLogFile;
procedure AddLogItem(const sUnit   : String;
                     const LineNr  : Integer;
                     const ID      : String;
                     const Message : String;
                     const Param   : array of Const);
procedure AddLogStrings(List : TStringList);
procedure AddLogPChar(Message : PChar);

implementation

var
  Counter          : Integer;
  Datei            : Text;
  Prefix           : String;
  Daily            : Boolean;

procedure SetOptions(aPrefix : String; aDaily : Boolean);
begin
  if (Counter > 0) then begin
    raise EInOutError.Create('Logdatei schon geoeffnet!');
  end;

  Prefix := aPrefix;
  Daily  := aDaily;
end;

procedure OpenLogFile;
var
  Filename         : String;
begin
  try
    if (Counter > 0) then begin
      Inc(Counter);
      Exit;
    end;

    if not DirectoryExists('LOGS') then begin
      CreateDir('LOGS');
    end;

    Filename := 'LOGS\' + Prefix + FormatDateTime('YYMMDD', Now) + '.LOG';
    AssignFile(Datei, Filename);
    if FileExists(Filename) then begin
      Append(Datei);
    end else begin
      Rewrite(Datei);
    end;
    Write(Datei, 'Protokollierung am ' + DateToStr(Now));
    Write(Datei, ' um ' + TimeToStr(Now));
    Write(Datei, ' gestartet');
    WriteLn(Datei);
    Inc(Counter);
    Flush(Datei);
  except
    Counter := 0;
  end;
end;

procedure AddLogItem(const sUnit   : String;
                     const LineNr  : Integer;
                     const ID      : String;
                     const Message : String;
                     const Param   : array of Const);
begin
  if (Counter > 0) then begin
    Write(Datei, '  ' + Format('%-12s(%8s:%4d)', [sUnit, ID, LineNr]));
    Write(Datei, '(' + DateToStr(Now) + ', ');
    Write(Datei, TimeToStr(Now) + ') : ');
    Write(Datei, Format(Message, Param));
    WriteLn(Datei);
    Flush(Datei);
  end;
end;

procedure AddLogStrings(List : TStringList);
var
  Loop             : Integer;
begin
  if (Counter > 0) then begin
    for Loop := 0 to (List.Count - 1) do begin
      WriteLn(Datei, '  ' + TimeToStr(Now) + ': ' + List.Strings[Loop]);
    end;
    WriteLn(Datei);
    Flush(Datei);
  end;
end;

procedure AddLogPChar(Message : PChar);
begin
  if (Counter > 0) then begin
    Write(Datei, '  ' + TimeToStr(Now) + ': ', Message);
    Flush(Datei);
  end;
end;

procedure CloseLogFile;
begin
  if (Counter > 0) then begin
    Dec(Counter);
    if (Counter = 0) then begin
      Write(Datei, 'Protokollierung am ' + DateToStr(Now));
      Write(Datei, ' um ' + TimeToStr(Now));
      Write(Datei, ' beendet');
      WriteLn(Datei);
      CloseFile(Datei);
    end;
  end;
end;

initialization

  Prefix  := 'LOG';
  Daily   := False;
  Counter := 0;

finalization

  try
    CloseLogFile;
  except
  end;

end.
