unit msaUtility;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  comObj;

type
  TmsaUtility_Options = (fmsaCompact,fmsaRepair,fmsaRepairCompact,fmsaCreateDataBase);
  TmsaUtility = class(TComponent)
  private
    { Private declarations }
    fOptions : TmsaUtility_Options;
    fmDBFileName : String;
    //fmdbtempFile : String;
    fAbout : String;
    Function mdbMainFileOK : Boolean;
    Function mdbTempFileOK : Boolean;
    Function Repairmdb(mdbFileName:String): Boolean;
    Function Compactmdb(mdbFileName:String): Boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
    Function Execute : Boolean;
    Function GetDAO_Object{}:OLEVariant;
    Function SelectMDBFile: Boolean;
    Constructor Create(Aowner:TComponent); Override;
    Destructor Destroy; Override;
  published
    { Published declarations }
    Property Options : TmsaUtility_Options Read  fOptions write fOptions ;
    Property MDBFileName : String Read fmdbFilename Write fmdbFileName;
    //Property tempFileName : String read fmdbTempFile Write fmdbTempFile;
    Property About : String Read fAbout;

  end;

procedure Register;

implementation
Function tmsaUtility.SelectMDBFile{}: Boolean;
var t : TOpenDialog ;

begin
     result := false;
     try
        t := TOpenDialog.create(nil);
        t.Filter := 'Access File (mdb)|*.mdb';
        t.DefaultExt := 'mdb';
        t.filename := '*.mdb';
        t.Title := 'Select File To Open';
        result :=t.execute  ;
        if result then
           fmDBFileName := t.filename;
     finally
          t.free
     end;
end;

Function tmsaUtility.GetDAO_Object{}:OLEVariant;
Begin
   try

    try
      Result := GetActiveOLEObject('DAO.DBEngine');
    except
      Result := CreateOLEObject('DAO.DBEngine');
    end;
    except on EOleException do
      Result := null
    end;
end;
Function tmsaUtility.mdbMainFileOK : Boolean;
begin
     result := fileExists(fmdbFileName );

     if result = true then
        result := (ExtractFileExt (fmdbFileName) = '.mdb');

     if not(result) then
        MessageDlg('There is a problem with the datafile you want to repair/ compress. '+#13+#10+'The problam may be an invalid file name, the file does not exist or it is not the right type!',mtError,[mbOK],0);

end;
Function tmsaUtility.mdbTempFileOK : Boolean;
begin

    result := true;
    if (fOptions = fmsaRepair) then begin
        result := true;
    end

end;

Function tmsaUtility.Repairmdb(mdbFileName:String): Boolean;

var db : OLEVariant;
begin

     try
     screen.cursor := crSQLWait ;
     db := GetDAO_Object ;
     result := false;
     try
     db.RepairDataBase(mdbFIleName);
     Result := true;
     Except on EOLEexception do
     Result := false;
     end
     finally
     db := Unassigned ;
     screen.cursor := crDefault ;
     end;



end;


Function tmsaUtility.Compactmdb(mdbFileName:String): Boolean;
var db : OLEVariant;
    tempFile : String;
begin
     result := true;
     try
     screen.cursor := crSQLWait ;
     db := GetDAO_Object ;
     result := false;
     try
     tempFile := ExtractFilePath (mdbFilename) + '\msaTemp.mdb';
     db.CompactDataBase(mdbFIleName,tempFile);
     DeleteFile(mdbFileName);
     RenameFile (tempFile,mdbFileName);
     Result := true;
     Except on EOLEexception do
     Result := false;
     end
     finally
     db := Unassigned ;
     screen.cursor := crDefault ;
     end;

end;



Function tmsaUtility.Execute : Boolean;
var t : String;
begin


     // ... other wise do other tasks
     result := false;
     if fmDBFileName = '' then
        if not(SelectMDBFile) then abort;

     result := mdbMainFileOK;
     if not(result) then abort;

     if (foptions in [fmsaRepair,fmsaRepairCompact]) then
        result := Repairmdb(fmdbFileName );
             if not(result) then  abort;

     if (foptions in [fmsaCompact,fmsaRepairCompact]) then
        result := CompactmDB(fmdbFilename);


end;

Constructor TmsaUtility.Create(Aowner:TComponent);

begin
     inherited Create(Aowner);
     fOptions := fmsaCompact ;
     fAbout := 'msaUtility Component From Final Filer Software';


end;

destructor TmsaUtility.Destroy;

begin

   //  Close Word
   // free the variant

     inherited Destroy;

end;



procedure Register;
begin
  RegisterComponents('Data Access', [TmsaUtility]);
end;

end.
