unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, AgentObjects_TLB, StdCtrls, GenieAnimations, Menus, ToolWin,
  ComCtrls;

type
  TForm1 = class(TForm)
    MyAgent: TAgent;
    MainMenu1: TMainMenu;
    Animations1: TMenuItem;
    mnuPlayAll: TMenuItem;
    Conversation1: TMenuItem;
    mnuStartConversation: TMenuItem;
    Help1: TMenuItem;
    mnuAbout: TMenuItem;
    mnuExit: TMenuItem;
    CoolBar1: TCoolBar;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MyAgentShow(Sender: TObject; const CharacterID: WideString;
      Cause: Smallint);
    procedure Button1Click(Sender: TObject);
    procedure MyAgentIdleStart(Sender: TObject;
      const CharacterID: WideString);
    procedure FormCreate(Sender: TObject);
    procedure MyAgentClick(Sender: TObject; const CharacterID: WideString;
      Button, Shift, x, y: Smallint);
    procedure mnuPlayAllClick(Sender: TObject);
    procedure MyAgentDblClick(Sender: TObject;
      const CharacterID: WideString; Button, Shift, x, y: Smallint);
    procedure mnuExitClick(Sender: TObject);
    procedure mnuStartConversationClick(Sender: TObject);
    procedure mnuAboutClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure AppDeactivate(Sender: TObject);
   private
    Genie: IAgentCtlCharacter;
    req: IAgentCtlRequest;
   { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Genie.Hide(1);
  MyAgent.Characters.Unload('Genie');
  MyAgent.Connected := False;
end;

procedure TForm1.MyAgentShow(Sender: TObject; const CharacterID: WideString;
  Cause: Smallint);
Var
   intSpeed, intPitch: Integer;
   strSpeed, strPitch: String;
begin
   //Genie.speak('','C:\Delphi Projecten\MS Agent\The_unex.wav');
   //Genie.MoveTo( (Screen.Width-Genie.Get_Width) Div 2, (Screen.Height-Genie.Get_Height) Div 2, 2 );
   //Genie.Play('Wave' );
   //Genie.Play( 'WaveReturn' );
   intSpeed := Genie.Get_Speed;
   intPitch := Genie.Get_Pitch;
   strSpeed := IntToStr(intSpeed);
   strPitch := IntToStr(intPitch);
   //Genie.Speak('My word speed is ... ' + strSpeed + 'words per minute', '');
   //Genie.Speak('\spd=100\The pitch of my voice is ... ' + strPitch + 'Herz', '');
   //IF CharacterID = 'Genie' THEN Application.messagebox('Hello world!','',MB_OK);
end;

procedure TForm1.Button1Click(Sender: TObject);
//'AnimationType',
//'Animation',
//'ReturnAnimation',
//'SupportsSpeaking',
//'AssignedToState',
//'Description'
VAR
  i: INTEGER;
begin
  Genie.StopAll('');
  FOR i := 1 to 49 DO
    BEGIN
      IF GenieAnimation[i,4] = 'Yes'
         THEN Genie.Speak( 'Genie ' + GenieAnimation[i,6], '' );
      Genie.Play( GenieAnimation[i,2] );
      //IF GenieAnimation[i,3] = 'Yes'
      //   THEN Genie.Play( GenieAnimation[i,2] + 'Return' );
    END;
  Genie.Play( 'RestPose' );
  Genie.Speak( 'These were my animations ', '' );
end;

procedure TForm1.MyAgentIdleStart(Sender: TObject;
  const CharacterID: WideString);
VAR
  i,x,y: INTEGER;
begin
  Randomize;
  x := RANDOM(Screen.Width-Genie.Get_Width);
  y := RANDOM(Screen.Height-Genie.Get_Height);
  Genie.MoveTo(x,y, RANDOM(1000));
  i := Random(11) + 1;
  Genie.Play( GenieAnimationIdle[i,2] );
  i := Random(11) + 1;
  Genie.Play( GenieAnimationIdle[i,2] );
  i := Random(49) + 1;
  Genie.Play( GenieAnimation[i,2] );
  i := Random(11) + 1;
      IF GenieAnimation[i,3] = 'Yes'
         THEN Genie.Play( GenieAnimation[i,2] + 'Return' );
  i := Random(11) + 1;
  IF (GenieAnimationIdle[i,6] = 'Reads') or (GenieAnimationIdle[i,6] = 'Writes')
     THEN Genie.Speak('... just checking...|... well .. you''ll never know|oops...forgot something', '');
  IF (GenieAnimationIdle[i,6] = 'Yawns')
     THEN Genie.Speak('... oops, I''m sorry...|... well .. you know .. some things are verry borring', '');
  Genie.Play( GenieAnimationIdle[i,2] );
  //Genie.Speak('Now, I am doing nothing ... My status is .. idle', '' );
end;


procedure TForm1.AppDeactivate(Sender: TObject);
begin
  Application.Minimize;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  h,w: INTEGER;
begin
     Self.WindowState := wsMinimized;
     Application.OnDeactivate := AppDeactivate;
     //Agent1.Connected := True;
     req := MyAgent.Characters.Load( 'Genie', 'C:\Program Files\Microsoft Agent\Characters\Genie.acs' );
     Genie := MyAgent.Characters.Character( 'Genie' );
     h := Genie.Get_Height;
     w := Genie.Get_Width;
     Genie.Set_Height( round(h / 1.5 ));
     Genie.Set_Width( round( w / 1.5 ));
     Genie.MoveTo( (Screen.Width-Genie.Get_Width) Div 2, (Screen.Height-Genie.Get_Height) Div 2, 2 );
     Genie.Show(0);
     //Genie.Speak('','C:\Delphi Projecten\MS Agent\GenieStart.wav');
     Genie.Speak('Hello, Master', '' );
end;

procedure TForm1.MyAgentClick(Sender: TObject;
  const CharacterID: WideString; Button, Shift, x, y: Smallint);
begin
  Case Button Of
    1: Begin //left button
         Genie.StopAll('');
         //Genie.speak('oops...that hurts!|keep your hands off me|I don''t like this| you just can''t find the right spot| that tiggles, ha, ha, ha ... ', '');
         Genie.Speak('','C:\Delphi Projecten\MS Agent\error.wav');
       End;
    2: Begin //right button
       end;
    4: Begin //middle button
       End;
    End;
end;

procedure TForm1.mnuPlayAllClick(Sender: TObject);
//'AnimationType',
//'Animation',
//'ReturnAnimation',
//'SupportsSpeaking',
//'AssignedToState',
//'Description'
VAR
  i: INTEGER;
begin
  Genie.StopAll('');
  Genie.Speak( 'Click me, when you want to stop me showing my animations', '' );
  frmAnimations.Show;
  FOR i := 1 to 49 DO
    BEGIN
      IF GenieAnimation[i,4] = 'Yes'
         THEN Genie.Speak( 'Genie ' + GenieAnimation[i,6], '' );
      Genie.Play( GenieAnimation[i,2] );
      //IF GenieAnimation[i,3] = 'Yes'
      //   THEN Genie.Play( GenieAnimation[i,2] + 'Return' );
    END;
  Genie.Play( 'RestPose' );
  Genie.Speak( 'These were my animations ', '' );
end;

procedure TForm1.MyAgentDblClick(Sender: TObject;
  const CharacterID: WideString; Button, Shift, x, y: Smallint);
begin
  Genie.StopAll('');
end;

procedure TForm1.mnuExitClick(Sender: TObject);
begin
  Self.Close;
end;

procedure TForm1.mnuStartConversationClick(Sender: TObject);
begin
//
end;

procedure TForm1.mnuAboutClick(Sender: TObject);
begin
//
end;

procedure TForm1.FormHide(Sender: TObject);
begin
   Application.Minimize
end;

end.
