unit AgentObjects_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Microsoft Agent Control 1.5 }
{ Version 1.5 }

{ Conversion log:
  Warning: 'Type' is a reserved word. Parameter 'Type' in IAgentCtlCharacter.Get changed to 'Type_'
 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_AgentObjects: TGUID = '{F5BE8BC2-7DE6-11D0-91FE-00C04FD701A5}';

const

{ Component class GUIDs }
  Class_Agent: TGUID = '{F5BE8BD2-7DE6-11D0-91FE-00C04FD701A5}';

type

{ Forward declarations: Interfaces }
  IAgentCtlCharacters = interface;
  IAgentCtlCharactersDisp = dispinterface;
  IAgentCtlCharacter = interface;
  IAgentCtlCharacterDisp = dispinterface;
  IAgentCtlBalloon = interface;
  IAgentCtlBalloonDisp = dispinterface;
  IAgentCtlCommands = interface;
  IAgentCtlCommandsDisp = dispinterface;
  IAgentCtlCommand = interface;
  IAgentCtlCommandDisp = dispinterface;
  IAgentCtlRequest = interface;
  IAgentCtlRequestDisp = dispinterface;
  IAgentCtlAudioObject = interface;
  IAgentCtlAudioObjectDisp = dispinterface;
  IAgentCtlSpeechInput = interface;
  IAgentCtlSpeechInputDisp = dispinterface;
  IAgentCtlPropertySheet = interface;
  IAgentCtlPropertySheetDisp = dispinterface;
  IAgentCtlUserInput = interface;
  IAgentCtlUserInputDisp = dispinterface;
  IAgentCtlCommandsWindow = interface;
  IAgentCtlCommandsWindowDisp = dispinterface;
  _AgentEvents = dispinterface;
  IAgentCtl = interface;
  IAgentCtlDisp = dispinterface;

{ Forward declarations: CoClasses }
  Agent = IAgentCtl;

{ IAgentCtlCharacters Interface }

  IAgentCtlCharacters = interface(IDispatch)
    ['{F5BE8BE8-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Item(const CharacterID: WideString): IAgentCtlCharacter; safecall;
    function Character(const CharacterID: WideString): IAgentCtlCharacter; safecall;
    function Get_Enum: IUnknown; safecall;
    procedure Unload(const CharacterID: WideString); safecall;
    function Load(const CharacterID: WideString; LoadKey: OleVariant): IAgentCtlRequest; safecall;
    property Item[const CharacterID: WideString]: IAgentCtlCharacter read Get_Item; default;
    property Enum: IUnknown read Get_Enum;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlCharacters }

  IAgentCtlCharactersDisp = dispinterface
    ['{F5BE8BE8-7DE6-11D0-91FE-00C04FD701A5}']
    property Item[const CharacterID: WideString]: IAgentCtlCharacter readonly dispid 0; default;
    function Character(const CharacterID: WideString): IAgentCtlCharacter; dispid 3;
    procedure Unload(const CharacterID: WideString); dispid 2;
    function Load(const CharacterID: WideString; LoadKey: OleVariant): IAgentCtlRequest; dispid 1;
  end;

{ IAgentCtlCharacter Interface }

  IAgentCtlCharacter = interface(IDispatch)
    ['{F5BE8BD9-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Balloon: IAgentCtlBalloon; safecall;
    function Get_Commands: IAgentCtlCommands; safecall;
    function Get_Name: WideString; safecall;
    function Get_Description: WideString; safecall;
    function Get_Visible: WordBool; safecall;
    procedure Set_Left(Value: Smallint); safecall;
    function Get_Left: Smallint; safecall;
    procedure Set_Top(Value: Smallint); safecall;
    function Get_Top: Smallint; safecall;
    procedure Set_Height(Value: Smallint); safecall;
    function Get_Height: Smallint; safecall;
    procedure Set_Width(Value: Smallint); safecall;
    function Get_Width: Smallint; safecall;
    function Get_Speed: Integer; safecall;
    function Get_Pitch: Integer; safecall;
    procedure Set_IdleOn(Value: WordBool); safecall;
    function Get_IdleOn: WordBool; safecall;
    function Activate(State: OleVariant): WordBool; safecall;
    function Play(const Animation: WideString): IAgentCtlRequest; safecall;
    function Get(const Type_, Name: WideString; Queue: OleVariant): IAgentCtlRequest; safecall;
    procedure Stop(Request: OleVariant); safecall;
    function Wait(WaitForRequest: IDispatch): IAgentCtlRequest; safecall;
    function Interrupt(InterruptRequest: IDispatch): IAgentCtlRequest; safecall;
    function Speak(Text, Url: OleVariant): IAgentCtlRequest; safecall;
    function GestureAt(x, y: Smallint): IAgentCtlRequest; safecall;
    function MoveTo(x, y: Smallint; Speed: OleVariant): IAgentCtlRequest; safecall;
    function Hide(Fast: OleVariant): IAgentCtlRequest; safecall;
    function Show(Fast: OleVariant): IAgentCtlRequest; safecall;
    procedure StopAll(Types: OleVariant); safecall;
    function Get_MoveCause: Smallint; safecall;
    function Get_VisibilityCause: Smallint; safecall;
    function Get_HasOtherClients: WordBool; safecall;
    procedure Set_SoundEffectsOn(Value: WordBool); safecall;
    function Get_SoundEffectsOn: WordBool; safecall;
    procedure Set_Name(const Value: WideString); safecall;
    procedure Set_Description(const Value: WideString); safecall;
    function Get_ExtraData: WideString; safecall;
    property Balloon: IAgentCtlBalloon read Get_Balloon;
    property Commands: IAgentCtlCommands read Get_Commands;
    property Name: WideString read Get_Name write Set_Name;
    property Description: WideString read Get_Description write Set_Description;
    property Visible: WordBool read Get_Visible;
    property Left: Smallint read Get_Left write Set_Left;
    property Top: Smallint read Get_Top write Set_Top;
    property Height: Smallint read Get_Height write Set_Height;
    property Width: Smallint read Get_Width write Set_Width;
    property Speed: Integer read Get_Speed;
    property Pitch: Integer read Get_Pitch;
    property IdleOn: WordBool read Get_IdleOn write Set_IdleOn;
    property MoveCause: Smallint read Get_MoveCause;
    property VisibilityCause: Smallint read Get_VisibilityCause;
    property HasOtherClients: WordBool read Get_HasOtherClients;
    property SoundEffectsOn: WordBool read Get_SoundEffectsOn write Set_SoundEffectsOn;
    property ExtraData: WideString read Get_ExtraData;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlCharacter }

  IAgentCtlCharacterDisp = dispinterface
    ['{F5BE8BD9-7DE6-11D0-91FE-00C04FD701A5}']
    property Balloon: IAgentCtlBalloon readonly dispid 23;
    property Commands: IAgentCtlCommands readonly dispid 25;
    property Name: WideString dispid 24;
    property Description: WideString dispid 28;
    property Visible: WordBool readonly dispid 2;
    property Left: Smallint dispid 3;
    property Top: Smallint dispid 4;
    property Height: Smallint dispid 5;
    property Width: Smallint dispid 6;
    property Speed: Integer readonly dispid 10;
    property Pitch: Integer readonly dispid 11;
    property IdleOn: WordBool dispid 29;
    function Activate(State: OleVariant): WordBool; dispid 26;
    function Play(const Animation: WideString): IAgentCtlRequest; dispid 13;
    function Get(const Type_, Name: WideString; Queue: OleVariant): IAgentCtlRequest; dispid 27;
    procedure Stop(Request: OleVariant); dispid 14;
    function Wait(WaitForRequest: IDispatch): IAgentCtlRequest; dispid 22;
    function Interrupt(InterruptRequest: IDispatch): IAgentCtlRequest; dispid 21;
    function Speak(Text, Url: OleVariant): IAgentCtlRequest; dispid 15;
    function GestureAt(x, y: Smallint): IAgentCtlRequest; dispid 17;
    function MoveTo(x, y: Smallint; Speed: OleVariant): IAgentCtlRequest; dispid 18;
    function Hide(Fast: OleVariant): IAgentCtlRequest; dispid 19;
    function Show(Fast: OleVariant): IAgentCtlRequest; dispid 20;
    procedure StopAll(Types: OleVariant); dispid 31;
    property MoveCause: Smallint readonly dispid 32;
    property VisibilityCause: Smallint readonly dispid 33;
    property HasOtherClients: WordBool readonly dispid 34;
    property SoundEffectsOn: WordBool dispid 35;
    property ExtraData: WideString readonly dispid 36;
  end;

{ IAgentCtlBalloon Interface }

  IAgentCtlBalloon = interface(IDispatch)
    ['{F5BE8BD3-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Enabled: WordBool; safecall;
    function Get_NumberOfLines: Integer; safecall;
    function Get_CharsPerLine: Integer; safecall;
    function Get_FontName: WideString; safecall;
    function Get_FontSize: Integer; safecall;
    function Get_FontBold: WordBool; safecall;
    function Get_FontItalic: WordBool; safecall;
    function Get_FontStrikethru: WordBool; safecall;
    function Get_FontUnderline: WordBool; safecall;
    function Get_ForeColor: Integer; safecall;
    function Get_BackColor: Integer; safecall;
    function Get_BorderColor: Integer; safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Visible: WordBool; safecall;
    procedure Set_FontName(const Value: WideString); safecall;
    procedure Set_FontSize(Value: Integer); safecall;
    procedure Set_FontCharSet(Value: Smallint); safecall;
    function Get_FontCharSet: Smallint; safecall;
    property Enabled: WordBool read Get_Enabled;
    property NumberOfLines: Integer read Get_NumberOfLines;
    property CharsPerLine: Integer read Get_CharsPerLine;
    property FontName: WideString read Get_FontName write Set_FontName;
    property FontSize: Integer read Get_FontSize write Set_FontSize;
    property FontBold: WordBool read Get_FontBold;
    property FontItalic: WordBool read Get_FontItalic;
    property FontStrikethru: WordBool read Get_FontStrikethru;
    property FontUnderline: WordBool read Get_FontUnderline;
    property ForeColor: Integer read Get_ForeColor;
    property BackColor: Integer read Get_BackColor;
    property BorderColor: Integer read Get_BorderColor;
    property Visible: WordBool read Get_Visible write Set_Visible;
    property FontCharSet: Smallint read Get_FontCharSet write Set_FontCharSet;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlBalloon }

  IAgentCtlBalloonDisp = dispinterface
    ['{F5BE8BD3-7DE6-11D0-91FE-00C04FD701A5}']
    property Enabled: WordBool readonly dispid 1;
    property NumberOfLines: Integer readonly dispid 2;
    property CharsPerLine: Integer readonly dispid 3;
    property FontName: WideString dispid 4;
    property FontSize: Integer dispid 5;
    property FontBold: WordBool readonly dispid 10;
    property FontItalic: WordBool readonly dispid 11;
    property FontStrikethru: WordBool readonly dispid 12;
    property FontUnderline: WordBool readonly dispid 13;
    property ForeColor: Integer readonly dispid 7;
    property BackColor: Integer readonly dispid 8;
    property BorderColor: Integer readonly dispid 9;
    property Visible: WordBool dispid 14;
    property FontCharSet: Smallint dispid 15;
  end;

{ IAgentCtlCommands Interface }

  IAgentCtlCommands = interface(IDispatch)
    ['{F5BE8BE1-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Item(const Name: WideString): IAgentCtlCommand; safecall;
    function Command(const Name: WideString): IAgentCtlCommand; safecall;
    function Get_Count: Integer; safecall;
    function Get_Caption: WideString; safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    function Get_Voice: WideString; safecall;
    procedure Set_Voice(const Value: WideString); safecall;
    function Get_Visible: WordBool; safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Enum: IUnknown; safecall;
    function Add(const Name: WideString; Caption, Voice, Enabled, Visible: OleVariant): IAgentCtlCommand; safecall;
    function Insert(const Name, RefName: WideString; Before, Caption, Voice, Enabled, Visible: OleVariant): IAgentCtlCommand; safecall;
    procedure Remove(const Name: WideString); safecall;
    procedure RemoveAll; safecall;
    property Item[const Name: WideString]: IAgentCtlCommand read Get_Item; default;
    property Count: Integer read Get_Count;
    property Caption: WideString read Get_Caption write Set_Caption;
    property Voice: WideString read Get_Voice write Set_Voice;
    property Visible: WordBool read Get_Visible write Set_Visible;
    property Enum: IUnknown read Get_Enum;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlCommands }

  IAgentCtlCommandsDisp = dispinterface
    ['{F5BE8BE1-7DE6-11D0-91FE-00C04FD701A5}']
    property Item[const Name: WideString]: IAgentCtlCommand readonly dispid 0; default;
    function Command(const Name: WideString): IAgentCtlCommand; dispid 15;
    property Count: Integer readonly dispid 2;
    property Caption: WideString dispid 3;
    property Voice: WideString dispid 4;
    property Visible: WordBool dispid 5;
    function Add(const Name: WideString; Caption, Voice, Enabled, Visible: OleVariant): IAgentCtlCommand; dispid 10;
    function Insert(const Name, RefName: WideString; Before, Caption, Voice, Enabled, Visible: OleVariant): IAgentCtlCommand; dispid 11;
    procedure Remove(const Name: WideString); dispid 13;
    procedure RemoveAll; dispid 14;
  end;

{ IAgentCtlCommand Interface }

  IAgentCtlCommand = interface(IDispatch)
    ['{F5BE8BE3-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Voice: WideString; safecall;
    procedure Set_Voice(const Value: WideString); safecall;
    function Get_Caption: WideString; safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    function Get_Enabled: WordBool; safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    function Get_Visible: WordBool; safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Confidence: Integer; safecall;
    procedure Set_Confidence(Value: Integer); safecall;
    function Get_ConfidenceText: WideString; safecall;
    procedure Set_ConfidenceText(const Value: WideString); safecall;
    property Voice: WideString read Get_Voice write Set_Voice;
    property Caption: WideString read Get_Caption write Set_Caption;
    property Enabled: WordBool read Get_Enabled write Set_Enabled;
    property Visible: WordBool read Get_Visible write Set_Visible;
    property Confidence: Integer read Get_Confidence write Set_Confidence;
    property ConfidenceText: WideString read Get_ConfidenceText write Set_ConfidenceText;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlCommand }

  IAgentCtlCommandDisp = dispinterface
    ['{F5BE8BE3-7DE6-11D0-91FE-00C04FD701A5}']
    property Voice: WideString dispid 1;
    property Caption: WideString dispid 2;
    property Enabled: WordBool dispid 5;
    property Visible: WordBool dispid 6;
    property Confidence: Integer dispid 3;
    property ConfidenceText: WideString dispid 4;
  end;

{ IAgentCtlRequest Interface }

  IAgentCtlRequest = interface(IDispatch)
    ['{1DAB85C3-803A-11D0-AC63-00C04FD97575}']
    function Get_ID: Integer; safecall;
    function Get_Status: Integer; safecall;
    function Get_Description: WideString; safecall;
    function Get_Number: Integer; safecall;
    property ID: Integer read Get_ID;
    property Status: Integer read Get_Status;
    property Description: WideString read Get_Description;
    property Number: Integer read Get_Number;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlRequest }

  IAgentCtlRequestDisp = dispinterface
    ['{1DAB85C3-803A-11D0-AC63-00C04FD97575}']
    property ID: Integer readonly dispid 0;
    property Status: Integer readonly dispid 1;
    property Description: WideString readonly dispid 2;
    property Number: Integer readonly dispid 3;
  end;

{ IAgentCtlAudioObject Interface }

  IAgentCtlAudioObject = interface(IDispatch)
    ['{F5BE8BDB-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Enabled: WordBool; safecall;
    function Get_SoundEffects: WordBool; safecall;
    property Enabled: WordBool read Get_Enabled;
    property SoundEffects: WordBool read Get_SoundEffects;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlAudioObject }

  IAgentCtlAudioObjectDisp = dispinterface
    ['{F5BE8BDB-7DE6-11D0-91FE-00C04FD701A5}']
    property Enabled: WordBool readonly dispid 1;
    property SoundEffects: WordBool readonly dispid 2;
  end;

{ IAgentCtlSpeechInput Interface }

  IAgentCtlSpeechInput = interface(IDispatch)
    ['{F5BE8BDD-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Enabled: WordBool; safecall;
    function Get_Language: WideString; safecall;
    function Get_HotKey: WideString; safecall;
    function Get_Installed: WordBool; safecall;
    function Get_Engine: WideString; safecall;
    procedure Set_Engine(const Value: WideString); safecall;
    function Get_ListeningTip: WordBool; safecall;
    property Enabled: WordBool read Get_Enabled;
    property Language: WideString read Get_Language;
    property HotKey: WideString read Get_HotKey;
    property Installed: WordBool read Get_Installed;
    property Engine: WideString read Get_Engine write Set_Engine;
    property ListeningTip: WordBool read Get_ListeningTip;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlSpeechInput }

  IAgentCtlSpeechInputDisp = dispinterface
    ['{F5BE8BDD-7DE6-11D0-91FE-00C04FD701A5}']
    property Enabled: WordBool readonly dispid 1;
    property Language: WideString readonly dispid 2;
    property HotKey: WideString readonly dispid 3;
    property Installed: WordBool readonly dispid 4;
    property Engine: WideString dispid 5;
    property ListeningTip: WordBool readonly dispid 6;
  end;

{ IAgentCtlPropertySheet Interface }

  IAgentCtlPropertySheet = interface(IDispatch)
    ['{F5BE8BDF-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Left: Smallint; safecall;
    function Get_Top: Smallint; safecall;
    function Get_Height: Smallint; safecall;
    function Get_Width: Smallint; safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Visible: WordBool; safecall;
    procedure Set_Page(const Value: WideString); safecall;
    function Get_Page: WideString; safecall;
    property Left: Smallint read Get_Left;
    property Top: Smallint read Get_Top;
    property Height: Smallint read Get_Height;
    property Width: Smallint read Get_Width;
    property Visible: WordBool read Get_Visible write Set_Visible;
    property Page: WideString read Get_Page write Set_Page;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlPropertySheet }

  IAgentCtlPropertySheetDisp = dispinterface
    ['{F5BE8BDF-7DE6-11D0-91FE-00C04FD701A5}']
    property Left: Smallint readonly dispid 1;
    property Top: Smallint readonly dispid 2;
    property Height: Smallint readonly dispid 3;
    property Width: Smallint readonly dispid 4;
    property Visible: WordBool dispid 6;
    property Page: WideString dispid 5;
  end;

  IAgentCtlUserInput = interface(IDispatch)
    ['{C4ABF875-8100-11D0-AC63-00C04FD97575}']
    function Get_Count: Smallint; safecall;
    function Get_Name: WideString; safecall;
    function Get_CharacterID: WideString; safecall;
    function Get_Confidence: Integer; safecall;
    function Get_Voice: WideString; safecall;
    function Get_Alt1Name: WideString; safecall;
    function Get_Alt1Confidence: Integer; safecall;
    function Get_Alt1Voice: WideString; safecall;
    function Get_Alt2Name: WideString; safecall;
    function Get_Alt2Confidence: Integer; safecall;
    function Get_Alt2Voice: WideString; safecall;
    property Count: Smallint read Get_Count;
    property Name: WideString read Get_Name;
    property CharacterID: WideString read Get_CharacterID;
    property Confidence: Integer read Get_Confidence;
    property Voice: WideString read Get_Voice;
    property Alt1Name: WideString read Get_Alt1Name;
    property Alt1Confidence: Integer read Get_Alt1Confidence;
    property Alt1Voice: WideString read Get_Alt1Voice;
    property Alt2Name: WideString read Get_Alt2Name;
    property Alt2Confidence: Integer read Get_Alt2Confidence;
    property Alt2Voice: WideString read Get_Alt2Voice;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlUserInput }

  IAgentCtlUserInputDisp = dispinterface
    ['{C4ABF875-8100-11D0-AC63-00C04FD97575}']
    property Count: Smallint readonly dispid 1610743808;
    property Name: WideString readonly dispid 1610743809;
    property CharacterID: WideString readonly dispid 1610743810;
    property Confidence: Integer readonly dispid 1610743811;
    property Voice: WideString readonly dispid 1610743812;
    property Alt1Name: WideString readonly dispid 1610743813;
    property Alt1Confidence: Integer readonly dispid 1610743814;
    property Alt1Voice: WideString readonly dispid 1610743815;
    property Alt2Name: WideString readonly dispid 1610743816;
    property Alt2Confidence: Integer readonly dispid 1610743817;
    property Alt2Voice: WideString readonly dispid 1610743818;
  end;

{ IAgentCtlCommandsWindow Interface }

  IAgentCtlCommandsWindow = interface(IDispatch)
    ['{6D0ECB27-9968-11D0-AC6E-00C04FD97575}']
    function Get_Visible: WordBool; safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Left: Smallint; safecall;
    function Get_Top: Smallint; safecall;
    function Get_Height: Smallint; safecall;
    function Get_Width: Smallint; safecall;
    property Visible: WordBool read Get_Visible write Set_Visible;
    property Left: Smallint read Get_Left;
    property Top: Smallint read Get_Top;
    property Height: Smallint read Get_Height;
    property Width: Smallint read Get_Width;
  end;

{ DispInterface declaration for Dual Interface IAgentCtlCommandsWindow }

  IAgentCtlCommandsWindowDisp = dispinterface
    ['{6D0ECB27-9968-11D0-AC6E-00C04FD97575}']
    property Visible: WordBool dispid 5;
    property Left: Smallint readonly dispid 6;
    property Top: Smallint readonly dispid 7;
    property Height: Smallint readonly dispid 8;
    property Width: Smallint readonly dispid 9;
  end;

{ IAgentCtl event interface }

  _AgentEvents = dispinterface
    ['{F5BE8BD4-7DE6-11D0-91FE-00C04FD701A5}']
    procedure ActivateInput(const CharacterID: WideString); dispid 1;
    procedure DeactivateInput(const CharacterID: WideString); dispid 3;
    procedure Click(const CharacterID: WideString; Button, Shift, x, y: Smallint); dispid 2;
    procedure DblClick(const CharacterID: WideString; Button, Shift, x, y: Smallint); dispid 4;
    procedure DragStart(const CharacterID: WideString; Button, Shift, x, y: Smallint); dispid 5;
    procedure DragComplete(const CharacterID: WideString; Button, Shift, x, y: Smallint); dispid 6;
    procedure Show(const CharacterID: WideString; Cause: Smallint); dispid 15;
    procedure Hide(const CharacterID: WideString; Cause: Smallint); dispid 7;
    procedure RequestStart(Request: IDispatch); dispid 9;
    procedure RequestComplete(Request: IDispatch); dispid 11;
    procedure Restart; dispid 21;
    procedure Shutdown; dispid 12;
    procedure Bookmark(BookmarkID: Integer); dispid 16;
    procedure Command(UserInput: IDispatch); dispid 17;
    procedure IdleStart(const CharacterID: WideString); dispid 19;
    procedure IdleComplete(const CharacterID: WideString); dispid 20;
    procedure Move(const CharacterID: WideString; x, y, Cause: Smallint); dispid 22;
    procedure Size(const CharacterID: WideString; Width, Height: Smallint); dispid 23;
    procedure BalloonShow(const CharacterID: WideString); dispid 24;
    procedure BalloonHide(const CharacterID: WideString); dispid 25;
  end;

{ IAgentCtl Interface }

  IAgentCtl = interface(IDispatch)
    ['{F5BE8BD1-7DE6-11D0-91FE-00C04FD701A5}']
    function Get_Characters: IAgentCtlCharacters; safecall;
    function Get_AudioOutput: IAgentCtlAudioObject; safecall;
    function Get_SpeechInput: IAgentCtlSpeechInput; safecall;
    function Get_PropertySheet: IAgentCtlPropertySheet; safecall;
    function Get_CommandsWindow: IAgentCtlCommandsWindow; safecall;
    function Get_Connected: WordBool; safecall;
    procedure Set_Connected(Value: WordBool); safecall;
    function Get_Suspended: WordBool; safecall;
    property Characters: IAgentCtlCharacters read Get_Characters;
    property AudioOutput: IAgentCtlAudioObject read Get_AudioOutput;
    property SpeechInput: IAgentCtlSpeechInput read Get_SpeechInput;
    property PropertySheet: IAgentCtlPropertySheet read Get_PropertySheet;
    property CommandsWindow: IAgentCtlCommandsWindow read Get_CommandsWindow;
    property Connected: WordBool read Get_Connected write Set_Connected;
    property Suspended: WordBool read Get_Suspended;
  end;

{ DispInterface declaration for Dual Interface IAgentCtl }

  IAgentCtlDisp = dispinterface
    ['{F5BE8BD1-7DE6-11D0-91FE-00C04FD701A5}']
    property Characters: IAgentCtlCharacters readonly dispid 3;
    property AudioOutput: IAgentCtlAudioObject readonly dispid 4;
    property SpeechInput: IAgentCtlSpeechInput readonly dispid 5;
    property PropertySheet: IAgentCtlPropertySheet readonly dispid 8;
    property CommandsWindow: IAgentCtlCommandsWindow readonly dispid 12;
    property Connected: WordBool dispid 9;
    property Suspended: WordBool readonly dispid 14;
  end;

{ AgentCtl Class }

  TAgentActivateInput = procedure(Sender: TObject; const CharacterID: WideString) of object;
  TAgentDeactivateInput = procedure(Sender: TObject; const CharacterID: WideString) of object;
  TAgentClick = procedure(Sender: TObject; const CharacterID: WideString; Button, Shift, x, y: Smallint) of object;
  TAgentDblClick = procedure(Sender: TObject; const CharacterID: WideString; Button, Shift, x, y: Smallint) of object;
  TAgentDragStart = procedure(Sender: TObject; const CharacterID: WideString; Button, Shift, x, y: Smallint) of object;
  TAgentDragComplete = procedure(Sender: TObject; const CharacterID: WideString; Button, Shift, x, y: Smallint) of object;
  TAgentShow = procedure(Sender: TObject; const CharacterID: WideString; Cause: Smallint) of object;
  TAgentHide = procedure(Sender: TObject; const CharacterID: WideString; Cause: Smallint) of object;
  TAgentRequestStart = procedure(Sender: TObject; Request: IDispatch) of object;
  TAgentRequestComplete = procedure(Sender: TObject; Request: IDispatch) of object;
  TAgentBookmark = procedure(Sender: TObject; BookmarkID: Integer) of object;
  TAgentCommand = procedure(Sender: TObject; UserInput: IDispatch) of object;
  TAgentIdleStart = procedure(Sender: TObject; const CharacterID: WideString) of object;
  TAgentIdleComplete = procedure(Sender: TObject; const CharacterID: WideString) of object;
  TAgentMove = procedure(Sender: TObject; const CharacterID: WideString; x, y, Cause: Smallint) of object;
  TAgentSize = procedure(Sender: TObject; const CharacterID: WideString; Width, Height: Smallint) of object;
  TAgentBalloonShow = procedure(Sender: TObject; const CharacterID: WideString) of object;
  TAgentBalloonHide = procedure(Sender: TObject; const CharacterID: WideString) of object;

  TAgent = class(TOleControl)
  private
    FOnActivateInput: TAgentActivateInput;
    FOnDeactivateInput: TAgentDeactivateInput;
    FOnClick: TAgentClick;
    FOnDblClick: TAgentDblClick;
    FOnDragStart: TAgentDragStart;
    FOnDragComplete: TAgentDragComplete;
    FOnShow: TAgentShow;
    FOnHide: TAgentHide;
    FOnRequestStart: TAgentRequestStart;
    FOnRequestComplete: TAgentRequestComplete;
    FOnRestart: TNotifyEvent;
    FOnShutdown: TNotifyEvent;
    FOnBookmark: TAgentBookmark;
    FOnCommand: TAgentCommand;
    FOnIdleStart: TAgentIdleStart;
    FOnIdleComplete: TAgentIdleComplete;
    FOnMove: TAgentMove;
    FOnSize: TAgentSize;
    FOnBalloonShow: TAgentBalloonShow;
    FOnBalloonHide: TAgentBalloonHide;
    FIntf: IAgentCtl;
    function GetControlInterface: IAgentCtl;
    function Get_Characters: IAgentCtlCharacters;
    function Get_AudioOutput: IAgentCtlAudioObject;
    function Get_SpeechInput: IAgentCtlSpeechInput;
    function Get_PropertySheet: IAgentCtlPropertySheet;
    function Get_CommandsWindow: IAgentCtlCommandsWindow;
  protected
    procedure CreateControl;
    procedure InitControlData; override;
    function GetTOleEnumProp(Index: Integer): TOleEnum;
    procedure SetTOleEnumProp(Index: Integer; Value: TOleEnum);
  public
    property ControlInterface: IAgentCtl read GetControlInterface;
    property Characters: IAgentCtlCharacters read Get_Characters;
    property AudioOutput: IAgentCtlAudioObject read Get_AudioOutput;
    property SpeechInput: IAgentCtlSpeechInput read Get_SpeechInput;
    property PropertySheet: IAgentCtlPropertySheet read Get_PropertySheet;
    property CommandsWindow: IAgentCtlCommandsWindow read Get_CommandsWindow;
    property Suspended: WordBool index 14 read GetWordBoolProp;
  published
    property Connected: WordBool index 9 read GetWordBoolProp write SetWordBoolProp stored False;
    property OnActivateInput: TAgentActivateInput read FOnActivateInput write FOnActivateInput;
    property OnDeactivateInput: TAgentDeactivateInput read FOnDeactivateInput write FOnDeactivateInput;
    property OnClick: TAgentClick read FOnClick write FOnClick;
    property OnDblClick: TAgentDblClick read FOnDblClick write FOnDblClick;
    property OnDragStart: TAgentDragStart read FOnDragStart write FOnDragStart;
    property OnDragComplete: TAgentDragComplete read FOnDragComplete write FOnDragComplete;
    property OnShow: TAgentShow read FOnShow write FOnShow;
    property OnHide: TAgentHide read FOnHide write FOnHide;
    property OnRequestStart: TAgentRequestStart read FOnRequestStart write FOnRequestStart;
    property OnRequestComplete: TAgentRequestComplete read FOnRequestComplete write FOnRequestComplete;
    property OnRestart: TNotifyEvent read FOnRestart write FOnRestart;
    property OnShutdown: TNotifyEvent read FOnShutdown write FOnShutdown;
    property OnBookmark: TAgentBookmark read FOnBookmark write FOnBookmark;
    property OnCommand: TAgentCommand read FOnCommand write FOnCommand;
    property OnIdleStart: TAgentIdleStart read FOnIdleStart write FOnIdleStart;
    property OnIdleComplete: TAgentIdleComplete read FOnIdleComplete write FOnIdleComplete;
    property OnMove: TAgentMove read FOnMove write FOnMove;
    property OnSize: TAgentSize read FOnSize write FOnSize;
    property OnBalloonShow: TAgentBalloonShow read FOnBalloonShow write FOnBalloonShow;
    property OnBalloonHide: TAgentBalloonHide read FOnBalloonHide write FOnBalloonHide;
  end;

procedure Register;

implementation

uses ComObj;

procedure TAgent.InitControlData;
const
  CEventDispIDs: array[0..19] of Integer = (
    $00000001, $00000003, $00000002, $00000004, $00000005, $00000006,
    $0000000F, $00000007, $00000009, $0000000B, $00000015, $0000000C,
    $00000010, $00000011, $00000013, $00000014, $00000016, $00000017,
    $00000018, $00000019);
  CControlData: TControlData = (
    ClassID: '{F5BE8BD2-7DE6-11D0-91FE-00C04FD701A5}';
    EventIID: '{F5BE8BD4-7DE6-11D0-91FE-00C04FD701A5}';
    EventCount: 20;
    EventDispIDs: @CEventDispIDs;
    LicenseKey: nil;
    Flags: $00000000;
    Version: 300);
begin
  ControlData := @CControlData;
end;

procedure TAgent.CreateControl;

  procedure DoCreate;
  begin
    FIntf := IUnknown(OleObject) as IAgentCtl;
  end;

begin
  if FIntf = nil then DoCreate;
end;

function TAgent.GetControlInterface: IAgentCtl;
begin
  CreateControl;
  Result := FIntf;
end;

function TAgent.GetTOleEnumProp(Index: Integer): TOleEnum;
begin
  Result := GetIntegerProp(Index);
end;

procedure TAgent.SetTOleEnumProp(Index: Integer; Value: TOleEnum);
begin
  SetIntegerProp(Index, Value);
end;

function TAgent.Get_Characters: IAgentCtlCharacters;
begin
  CreateControl;
  Result := FIntf.Characters;
end;

function TAgent.Get_AudioOutput: IAgentCtlAudioObject;
begin
  CreateControl;
  Result := FIntf.AudioOutput;
end;

function TAgent.Get_SpeechInput: IAgentCtlSpeechInput;
begin
  CreateControl;
  Result := FIntf.SpeechInput;
end;

function TAgent.Get_PropertySheet: IAgentCtlPropertySheet;
begin
  CreateControl;
  Result := FIntf.PropertySheet;
end;

function TAgent.Get_CommandsWindow: IAgentCtlCommandsWindow;
begin
  CreateControl;
  Result := FIntf.CommandsWindow;
end;


procedure Register;
begin
  RegisterComponents('ActiveX', [TAgent]);
end;

end.
