unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, MPDelTreeU;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    StatusBar1: TStatusBar;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure ProcessFile ( Sender : TObject ; FileName : TFileName ; SearchRec : TSearchRec ;
                            var Cancel : Boolean ) ;
  end;

var
  Form1: TForm1;

implementation
uses FileCtrl ;
{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
var fPath : string;
begin
      //Select the path to delete

     fPath := Edit1.Text;
     if SelectDirectory ( fPath , [] , 0 ) then
        Edit1.Text := fPath;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
     with TMPDelTree.Create ( Self ) do begin
          Verbose := CheckBox1.Checked;
          Path := Edit1.Text;
          OnProcessFile := ProcessFile ;
          if Execute then
             ShowMessage ( 'Tree deleted' )
          else
              ShowMessage ( 'Tree not deleted' );
          Free;
     end;
end;

procedure TForm1.ProcessFile ( Sender : TObject ; FileName : TFileName ; SearchRec : TSearchRec ;
                               var Cancel : Boolean ) ;
begin
     StatusBar1.SimpleText := FileName;
     StatusBar1.Update;
end;


end.
