unit mStored;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, ODBCsql, Db, mDataBas;

const PAR_NAME_LENGTH = 128;
const PAR_STR_LENGTH = 255;
const PROC_STATEMENT_LENGTH = 255;

const SQL_DATA_TYPE_NONE		= 0;
const SQL_DATA_TYPE_INTEGER		= 1;
const SQL_DATA_TYPE_DOUBLE		= 2;
const SQL_DATA_TYPE_DATETIME		= 3;
const SQL_DATA_TYPE_STRING		= 4;

type
	SQL_C_TYPE_TIMESTAMP = record
    	year : SQLUSMALLINT;
    	month : SQLUSMALLINT;
    	day : SQLUSMALLINT;
    	hour : SQLUSMALLINT;
    	minute : SQLUSMALLINT;
        second : SQLUSMALLINT;
    	fraction : SQLUINTEGER;
	end;

	PProcedureParameter = ^TProcedureParameter;
    TProcedureParameter = record
		ParName : array[0..PAR_NAME_LENGTH + 1] of char;
        ParType : integer;
        FieldLength : integer;

        ParValueInt : integer;
        ParValueDouble : double;
        ParValueStr : array[0..PAR_STR_LENGTH + 1] of char;
        ParValueDateTime : SQL_C_TYPE_TIMESTAMP;
        cbReserved : SQLINTEGER;
    end;

  TmStoredProc = class(TComponent)
  private
  	fDataBase : TmDataBase;
    fShowError : boolean;
    fProcName : string;
    fErrorCode : integer;
    procedure SetDataBase(Value: TmDataBase);
    function ExecuteStoredProcedure( pAParList : PProcedureParameter; AParListCount : integer ) : integer;
    function DoCheckSQLResult( AHandle : SQLHANDLE; AResultCode : SQLRETURN ) : integer;
  protected
    procedure Notification( AComponent : TComponent; Operation : TOperation ); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Execute( pAParList : PProcedureParameter; AParListCount : integer ) : boolean;
  published
    property DataBase : TmDataBase read fDataBase write SetDataBase;
    property StoredProcName : string read fProcName write fProcName;
    property IsShowError : boolean read fShowError write fShowError;
    property ErrorCode : integer read fErrorCode write fErrorCode;
  end;

implementation

constructor TmStoredProc.Create( AOwner : TComponent );
begin
	inherited Create( AOwner );
end;//Create

destructor TmStoredProc.Destroy;
begin
  inherited Destroy;
end;//Destroy

procedure TmStoredProc.SetDataBase( Value : TmDataBase );
begin
  fDataBase := Value;
end;//SetDataBase

procedure TmStoredProc.Notification( AComponent : TComponent; Operation : TOperation );
begin
  inherited Notification( AComponent,Operation );
  if ( Operation = opRemove ) and ( AComponent = fDataBase ) then
    fDataBase := nil;
end;//Notification


function TmStoredProc.DoCheckSQLResult( AHandle : SQLHANDLE; AResultCode : SQLRETURN ) : integer;
var
  ACode : SQLINTEGER;
  SQLState : array[0..5] of char;
  MessageText : array[0..500+1] of char;
  ALen : SQLSMALLINT;
begin
  case AResultCode of
    SQL_SUCCESS,SQL_SUCCESS_WITH_INFO: Result := 0;
  else
    begin
      ACode := AResultCode;
      SQLGetDiagRec( SQL_HANDLE_STMT, AHandle, 1, @SQLState[0], ACode, @Messagetext[0], 500, ALen);
      if IsShowError then
        MessageDlg( '<' + StrPas(SQLState) + '> :' + StrPas(MessageText), mtError, [mbOk],0 );
      Result := -1;
    end;
  end;
end;//DoCheckSQLResult

function TmStoredProc.ExecuteStoredProcedure( pAParList : PProcedureParameter; AParListCount : integer ) : integer;
var
	i : integer;
  p : PProcedureParameter;
  h : SQLHANDLE;
  AStatment : array[0..PROC_STATEMENT_LENGTH + 1] of char;
  ParStr : string;
begin
  Result := -1;
  ParStr := '';

  if SQLAllocHandle( SQL_HANDLE_STMT,DataBase.hdbc,h ) = SQL_SUCCESS then
  begin
    p := pAParList;
    for i := 0 to AParListCount - 1 do
    begin
      case p^.ParType of
        SQL_DATA_TYPE_INTEGER:
              ErrorCode := SQLBindParameter( h,i + 1,SQL_PARAM_INPUT,SQL_INTEGER,SQL_INTEGER,0,0,@p.ParValueInt,0,@p.cbReserved );
        SQL_DATA_TYPE_DOUBLE:
              ErrorCode := SQLBindParameter( h,i + 1,SQL_PARAM_INPUT,SQL_DOUBLE,SQL_DOUBLE,8,0,@p.ParValueDouble,0,@p.cbReserved );
        SQL_DATA_TYPE_DATETIME:
              ErrorCode := SQLBindParameter( h,i + 1,SQL_PARAM_INPUT,SQL_TYPE_TIMESTAMP,SQL_TYPE_TIMESTAMP,0,0,@p^.ParValueDateTime,0,@p.cbReserved );
        SQL_DATA_TYPE_STRING:
              ErrorCode := SQLBindParameter( h,i + 1,SQL_PARAM_INPUT,SQL_CHAR,SQL_CHAR,p^.FieldLength,0,@p^.ParValueStr,p^.FieldLength,nil );
      end; // case

      DoCheckSQLResult( h,ErrorCode );

      if ParStr = '' then ParStr := '?'
                     else ParStr := ParStr + ',?';

      Inc( p );
    end;

    StrPCopy( AStatment,'{call ' + StoredProcName + ' ( ' + ParStr + ' )}' );
    ErrorCode := SQLExecDirect( h, AStatment, StrLen(AStatment)  );
    Result := DoCheckSQLResult( h, ErrorCode );

    SQLFreeHandle( SQL_HANDLE_STMT,h );
  end;
end;//ExecuteStoredProcedure

function TmStoredProc.Execute( pAParList: PProcedureParameter; AParListCount: integer): boolean;
begin
	Result := False;
	if Assigned( DataBase ) then
		Result := ExecuteStoredProcedure( pAParList, AParListCount ) = 0
	else
    if IsShowError then
      MessageDlg( 'mStoredProc Error: There are no defined databases', mtError, [mbOk], 0);
end;//Execute

end.//mStoredProc
