unit Mqueryex;
{$I mODBC.INC}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls,db,mquery,DsgnIntf;

{$IFDEF QUERYEDITOR}

type
  TmQueryEditor = class(TComponentEditor)
  private
    stdEditor: TComponentEditor;
    stdEditorVerbs:integer;
  public
    constructor Create(AComponent: TComponent; ADesigner: IFormDesigner); override;
    destructor Destroy;  override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure ShowEditor;
    procedure ShowWizard;
  end;

implementation

uses
   mqueryed,mDBWiz;

type PClass = ^TClass;

constructor TmQueryEditor.Create(AComponent: TComponent; ADesigner: IFormDesigner);
var
  saveClass: TClass;
begin
  inherited Create(AComponent,ADesigner);
  saveClass:=PClass(AComponent)^;
  try
    PClass(AComponent)^:=TDataSet;
    stdEditor:=GetComponentEditor(AComponent,ADesigner);
    stdEditorVerbs:=stdEditor.GetVerbCount;
  finally
    PClass(AComponent)^:=saveClass;
  end;
end;

destructor TmQueryEditor.Destroy;
begin
  stdEditor.Free;
  inherited Destroy;
end;

procedure TmQueryEditor.ExecuteVerb(Index: Integer);
begin
  if Index < stdEditor.GetVerbCount then begin
    stdEditor.ExecuteVerb(Index)
  end else begin
    case index-stdEditorVerbs of
      0:begin
        Showeditor;
      end;
      1:begin
        ShowWizard;
      end;
    end;
  end;
end;

function TmQueryEditor.GetVerb(Index: Integer): String;
begin
  if Index < stdEditorVerbs then begin
    Result:=stdEditor.GetVerb(Index)
  end else begin
    case index-stdEditorVerbs of
      0: Result := '&mQuery Editor ...';
      1: Result := '&Add Detail mQuery ...';
      else Result := '';
    end;
  end;
end;

function TmQueryEditor.GetVerbCount: Integer;
begin
  Result:=stdEditorVerbs+2;
end;

procedure TmQueryEditor.ShowWizard;
begin
  dbWizForm:=TdbWizForm.Create( Application);
  try
    dbWizForm.showDataSets:=true;
    dbWizForm.DataBase :=TmQuery(Component).Database;
    dbWizForm.theFormDesigner:=designer;
    if dbWizForm.ShowModal=mrOk then begin
      Designer.Modified;
    end;
  finally
    dbWizForm.free;
  end;
end;

procedure TmQueryEditor.ShowEditor;
Var
   AQuery: TmQuery;
begin
  AQuery := TmQuery(Component);
  if AQuery.DataBase = nil then begin
    ShowMessage ('Assign Database first.');
    exit;
  end;
  if (AQuery <> nil) then begin
    QueryEditDlg:=TQueryEditDlg.Create(Application);
    try
      QueryEditDlg.caption:='Editing mQuery "'+Component.name+'"';
      QueryEditDlg.FMquery:=Tmquery.Create(QueryEditDlg);
       QueryEditDlg.FMquery.DataBase := AQuery.DataBase;
       QueryEditDlg.FMquery.DataSource := AQuery.DataSource;
       QueryEditDlg.DeleteMemo.Lines := AQuery.DeleteSQL;
       QueryEditDlg.InsertMemo.Lines := AQuery.InsertSQL;
       QueryEditDlg.ModifyMemo.Lines := AQuery.ModifySQL;
       QueryEditDlg.SelectMemo.Lines := AQuery.SQL;
       if QueryEditDlg.ShowModal = mrOK then
       begin
         AQuery.DataBase.DataBaseName:=QueryEditDlg.FMquery.DataBase.DataBaseName;
         AQuery.SQL:=QueryEditDlg.SelectMemo.Lines;
         AQuery.DeleteSQL:=QueryEditDlg.DeleteMemo.Lines;
         AQuery.InsertSQL:=QueryEditDlg.InsertMemo.Lines;
         AQuery.ModifySQL:=QueryEditDlg.ModifyMemo.Lines;
         Designer.Modified;
       end;
    finally
       QueryEditDlg.FMquery.Destroy;
       QueryEditDlg.Free;
    end;
  end;
end;

{$ELSE}
implementation
{$ENDIF}
end.
