unit mDBWiz;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dsgnintf,mDatabas,mQuery,StdCtrls, ExtCtrls, ComCtrls;

type
  TdbWizForm = class(TForm)
    Panel7: TPanel;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    Panel2: TPanel;
    Label3: TLabel;
    Label2: TLabel;
    NameEdit: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    Panel3: TPanel;
    DataSourceComboBox: TComboBox;
    MasterLabel: TLabel;
    CreateButton: TButton;
    Button2: TButton;
    SuggestCheckBox: TCheckBox;
    DataSourceNameEdit: TEdit;
    mQueryNameEdit: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure CreateButtonClick(Sender: TObject);
    procedure NameEditChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SuggestCheckBoxClick(Sender: TObject);
  private
    { Private declarations }
    first:boolean;
  public
    { Public declarations }
    DataBase: TmDataBase;
    theFormDesigner:IFormDesigner;
    showDataSets:boolean;
  end;

var
  dbWizForm: TdbWizForm;

implementation
uses
  TypInfo,db;
{$R *.DFM}

procedure TdbWizForm.FormCreate(Sender: TObject);
begin
  first:=true;
end;
procedure TdbWizForm.FormActivate(Sender: TObject);
begin
  if first then begin
    first:=false;
    if showDataSets then begin
      DataSourceComboBox.items.Clear;
      theFormDesigner.GetComponentNames(GetTypeData(TDataSource.ClassInfo),
        DataSourceComboBox.items.Append);
    end else begin

    end;
    MasterLabel.visible:=showDataSets;
    DataSourceComboBox.visible:=showDataSets;
    NameEditChange(sender);
  end;
end;


procedure TdbWizForm.CreateButtonClick(Sender: TObject);
var
  aMquery:TMquery;
  adataSource:tdataSource;
begin
  if showDataSets then begin
    if DataSourceComboBox.text='' then begin
      showmessage('You must select a "Master" dataset in order to create a "Detail" mquery');
      exit;
    end;
  end;
  adataSource:=tdataSource(theFormDesigner.CreateComponent(TdataSource,theFormDesigner.GetRoot,0,0,0,0));
  adataSource.name:=DataSourceNameEdit.text;
  aMquery:=TMquery(theFormDesigner.CreateComponent(TMquery,theFormDesigner.GetRoot,0,0,0,0));
  aMquery.name:=mQueryNameEdit.text;
  adataSource.DataSet:=aMquery;
  aMquery.DataBase:=DataBase;
  if showDataSets then begin
    aMquery.DataSource:=TDataSource(theFormDesigner.GetComponent(DataSourceComboBox.text));
  end;

  ModalResult:=mrok;
end;

procedure TdbWizForm.NameEditChange(Sender: TObject);
begin
  if SuggestCheckBox.checked then begin
    if NameEdit.text<>'' then begin
      DataSourceNameEdit.text:=NameEdit.text+'DataSource';
      mQueryNameEdit.text:=NameEdit.text+'mQuery';
    end else begin
      DataSourceNameEdit.text:=theFormDesigner.UniqueName('DataSource');
      mQueryNameEdit.text:=theFormDesigner.UniqueName('mQuery');
    end;
  end;
end;




procedure TdbWizForm.SuggestCheckBoxClick(Sender: TObject);
begin
  DataSourceNameEdit.enabled:=not SuggestCheckBox.checked;
  mQueryNameEdit.enabled:=not SuggestCheckBox.checked;
end;

end.
